/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.util.hook;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.util.hook.PluginHook;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractHookManager<P extends JavaPlugin> {
    protected final P plugin;
    private final Map<Class<? extends PluginHook<P>>, PluginHook<P>> hooks = new HashMap<Class<? extends PluginHook<P>>, PluginHook<P>>();

    public AbstractHookManager(P plugin) {
        this.plugin = plugin;
    }

    protected void register(String name, Class<? extends PluginHook<P>> clazz) {
        Plugin target = Bukkit.getPluginManager().getPlugin(name);
        if (target == null || !target.isEnabled()) {
            return;
        }
        try {
            if (this.hooks.putIfAbsent(clazz, clazz.getConstructor(this.plugin.getClass()).newInstance(this.plugin)) != null) {
                this.plugin.getLogger().warning("Failed to hook into " + name + ": There was already a hook registered with same name");
                return;
            }
            DuelsPlugin.sendMessage("&aSuccessfully hooked into '" + name + "'!");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            DuelsPlugin.sendMessage("&b&lFailed to hook into " + name + ": " + throwable2.getMessage());
        }
    }

    public <T extends PluginHook<P>> T getHook(Class<T> clazz) {
        return (T)(clazz != null ? (PluginHook)clazz.cast(this.hooks.get(clazz)) : null);
    }
}

