/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.validator.validators.match;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.validator.BaseBiValidator;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class CheckMoveValidator
extends BaseBiValidator<Collection<Player>, Settings> {
    private static final String MESSAGE_KEY = "DUEL.start-failure.player-moved";
    private static final String PARTY_MESSAGE_KEY = "DUEL.party-start-failure.player-moved";

    public CheckMoveValidator(DuelsPlugin plugin) {
        super(plugin);
    }

    @Override
    public boolean shouldValidate() {
        return this.config.isCancelIfMoved();
    }

    private boolean notInLoc(Player player, Location location) {
        if (location == null) {
            return false;
        }
        Location source = player.getLocation();
        return !source.getWorld().equals((Object)location.getWorld()) || source.getBlockX() != location.getBlockX() || source.getBlockY() != location.getBlockY() || source.getBlockZ() != location.getBlockZ();
    }

    @Override
    public boolean validate(Collection<Player> players, Settings settings) {
        if (players.stream().anyMatch(player -> this.notInLoc((Player)player, settings.getBaseLoc((Player)player)))) {
            this.lang.sendMessage(players, settings.isPartyDuel() ? PARTY_MESSAGE_KEY : MESSAGE_KEY, new Object[0]);
            return false;
        }
        return true;
    }
}

