/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.arena;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.arena.Arena;
import com.meteordevelopments.duels.api.event.arena.ArenaSetPositionEvent;
import com.meteordevelopments.duels.api.event.arena.ArenaStateChangeEvent;
import com.meteordevelopments.duels.api.event.match.MatchEndEvent;
import com.meteordevelopments.duels.countdown.DuelCountdown;
import com.meteordevelopments.duels.countdown.party.PartyDuelCountdown;
import com.meteordevelopments.duels.gui.BaseButton;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.match.party.PartyDuelMatch;
import com.meteordevelopments.duels.match.team.TeamDuelMatch;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.queue.Queue;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.spectate.SpectatorImpl;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArenaImpl
extends BaseButton
implements Arena {
    private final String name;
    private boolean disabled;
    private final Set<KitImpl> kits = new HashSet<KitImpl>();
    private final Map<Integer, Location> positions = new HashMap<Integer, Location>();
    private DuelMatch match;
    private boolean removed;
    private DuelCountdown countdown;

    public ArenaImpl(DuelsPlugin plugin, String name, boolean disabled) {
        super(plugin, ItemBuilder.of(Items.EMPTY_MAP).name(plugin.getLang().getMessage("GUI.arena-selector.buttons.arena.name", "name", name), plugin.getLang()).lore(plugin.getLang(), plugin.getLang().getMessage("GUI.arena-selector.buttons.arena.lore-unavailable").split("\n")).build());
        this.name = name;
        this.disabled = disabled;
    }

    public ArenaImpl(DuelsPlugin plugin, String name) {
        this(plugin, name, false);
    }

    public void refreshGui(boolean available) {
        this.setLore(this.lang, this.lang.getMessage("GUI.arena-selector.buttons.arena.lore-" + (available ? "available" : "unavailable")).split("\n"));
        this.arenaManager.getGui().calculatePages();
    }

    @Override
    @Nullable
    public Location getPosition(int pos) {
        return this.positions.get(pos);
    }

    @Override
    public boolean setPosition(@Nullable Player source, int pos, @NotNull Location location) {
        Objects.requireNonNull(location, "location");
        if (pos <= 0 || pos > 2) {
            return false;
        }
        ArenaSetPositionEvent event = new ArenaSetPositionEvent((CommandSender)source, this, pos, location);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.positions.put(event.getPos(), event.getLocation());
        this.arenaManager.saveArenas();
        this.refreshGui(this.isAvailable());
        return true;
    }

    @Override
    public boolean setPosition(int pos, @NotNull Location location) {
        return this.setPosition(null, pos, location);
    }

    @Override
    public boolean setDisabled(@Nullable CommandSender source, boolean disabled) {
        ArenaStateChangeEvent event = new ArenaStateChangeEvent(source, this, disabled);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.disabled = event.isDisabled();
        this.arenaManager.saveArenas();
        this.refreshGui(this.isAvailable());
        return true;
    }

    @Override
    public boolean setDisabled(boolean disabled) {
        return this.setDisabled(null, disabled);
    }

    public boolean isBoundless() {
        return this.kits.isEmpty();
    }

    public boolean isBound(@Nullable KitImpl kit) {
        return kit != null && this.kits.contains(kit);
    }

    public void bind(KitImpl kit) {
        if (this.isBound(kit)) {
            this.kits.remove(kit);
        } else {
            this.kits.add(kit);
        }
        this.arenaManager.saveArenas();
    }

    @Override
    public boolean isUsed() {
        return this.match != null;
    }

    public boolean isAvailable() {
        return !this.isDisabled() && !this.isUsed() && this.getPosition(1) != null && this.getPosition(2) != null;
    }

    public DuelMatch startMatch(KitImpl kit, Map<UUID, List<ItemStack>> items, Settings settings, Queue source) {
        this.match = settings.isPartyDuel() ? new PartyDuelMatch((DuelsPlugin)this.plugin, this, kit, items, settings.getBet(), source) : (source != null && source.getTeamSize() > 1 ? new TeamDuelMatch((DuelsPlugin)this.plugin, this, kit, items, settings.getBet(), source) : new DuelMatch((DuelsPlugin)this.plugin, this, kit, items, settings.getBet(), source));
        this.refreshGui(false);
        return this.match;
    }

    public void endMatch(UUID winner, UUID loser, MatchEndEvent.Reason reason) {
        this.spectateManager.stopSpectating(this);
        MatchEndEvent event = new MatchEndEvent(this.match, winner, loser, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        Queue source = this.match.getSource();
        this.match.setFinished();
        for (Block block : this.match.placedBlocks) {
            block.setType(Material.AIR);
        }
        for (Map.Entry entry : this.match.brokenBlocks.entrySet()) {
            ((Location)entry.getKey()).getBlock().setBlockData((BlockData)entry.getValue());
        }
        for (Entity entity : this.match.placedEntities) {
            entity.remove();
        }
        block3: for (Block block : this.match.liquids) {
            Location loc = block.getLocation();
            int radius = 1;
            while (true) {
                boolean waterFound = false;
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            Block findBlock = loc.clone().add((double)x, (double)y, (double)z).getBlock();
                            String type = findBlock.getType().name().toLowerCase();
                            if (!type.contains("water") && !type.contains("lava") && !type.contains("cobblestone") && !type.contains("obsidian")) continue;
                            waterFound = true;
                            findBlock.setType(Material.AIR);
                        }
                    }
                }
                if (!waterFound) continue block3;
                ++radius;
            }
        }
        if (this.config.isClearItemsAfterMatch()) {
            this.match.droppedItems.forEach(Entity::remove);
        }
        this.match = null;
        if (source != null) {
            source.update();
            this.queueManager.getGui().calculatePages();
        }
        this.refreshGui(true);
    }

    public void startCountdown() {
        this.countdown = this.match instanceof PartyDuelMatch ? new PartyDuelCountdown((DuelsPlugin)this.plugin, this, (PartyDuelMatch)this.match) : new DuelCountdown((DuelsPlugin)this.plugin, this, this.match);
        this.countdown.startCountdown(0L, 20L);
    }

    boolean isCountingComplete() {
        return this.countdown == null;
    }

    @Override
    public boolean has(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.isUsed() && !this.match.isDead(player);
    }

    public void add(Player player) {
        if (this.isUsed()) {
            this.match.addPlayer(player);
        }
    }

    public void remove(Player player) {
        if (this.isUsed()) {
            this.match.markAsDead(player);
        }
    }

    public boolean isEndGame() {
        return this.size() <= 1;
    }

    public int size() {
        return this.isUsed() ? this.match.size() : 0;
    }

    public Player first() {
        return this.isUsed() ? this.match.getAlivePlayers().iterator().next() : null;
    }

    @Override
    public Player getOpponent(Player player) {
        return this.isUsed() ? (Player)this.match.getAllPlayers().stream().filter(other -> !player.equals(other)).findFirst().orElse(null) : null;
    }

    public Party getOpponent(Party party) {
        return this.isUsed() ? (Party)((PartyDuelMatch)this.match).getAllParties().stream().filter(other -> !party.equals(other)).findFirst().orElse(null) : null;
    }

    public Set<Player> getPlayers() {
        return this.isUsed() ? this.match.getAllPlayers() : Collections.emptySet();
    }

    public void broadcast(String message) {
        this.getPlayers().forEach(player -> player.sendMessage(message));
        this.spectateManager.getSpectatorsImpl(this).stream().map(SpectatorImpl::getPlayer).filter(Objects::nonNull).forEach(player -> player.sendMessage(message));
    }

    @Override
    public void onClick(Player player) {
        String kitName;
        if (!this.isAvailable()) {
            return;
        }
        Settings settings = this.settingManager.getSafely(player);
        String string = kitName = settings.getKit() != null ? settings.getKit().getName() : this.lang.getMessage("GENERAL.none");
        if (!this.arenaManager.isSelectable(settings.getKit(), this)) {
            this.lang.sendMessage((CommandSender)player, "ERROR.setting.arena-not-applicable", "kit", kitName, "arena", this.name);
            return;
        }
        settings.setArena(this);
        settings.openGui(player);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ArenaImpl arena = (ArenaImpl)other;
        return Objects.equals(this.name, arena.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public Set<KitImpl> getKits() {
        return this.kits;
    }

    @Generated
    public Map<Integer, Location> getPositions() {
        return this.positions;
    }

    @Override
    @Generated
    public DuelMatch getMatch() {
        return this.match;
    }

    @Override
    @Generated
    public boolean isRemoved() {
        return this.removed;
    }

    @Generated
    public DuelCountdown getCountdown() {
        return this.countdown;
    }

    @Generated
    void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Generated
    public void setCountdown(DuelCountdown countdown) {
        this.countdown = countdown;
    }
}

