/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.party.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.party.PartyMember;
import com.meteordevelopments.duels.util.StringUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListCommand
extends BaseCommand {
    public ListCommand(DuelsPlugin plugin) {
        super(plugin, "list", (String)null, (String)null, "duels.party", 1, true, "ls");
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        if (args.length > this.getLength()) {
            if (!sender.hasPermission("duels.party.list.others")) {
                this.lang.sendMessage(sender, "ERROR.no-permission", "permission", "duels.party.list.others");
                return;
            }
            Player target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null || !player.canSee(target)) {
                this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[1]);
                return;
            }
            Party party = this.partyManager.get(target);
            if (party == null) {
                this.lang.sendMessage(sender, "ERROR.party.not-in-party.target", "name", target.getName());
                return;
            }
            this.showList(sender, party);
            return;
        }
        Party party = this.partyManager.get(player);
        if (party == null) {
            this.lang.sendMessage(sender, "ERROR.party.not-in-party.sender", new Object[0]);
            return;
        }
        this.showList(sender, party);
    }

    private void showList(CommandSender sender, Party party) {
        if (party == null) {
            this.lang.sendMessage(sender, "ERROR.party.not-in-party.sender", new Object[0]);
            return;
        }
        ArrayList<String> memberNames = new ArrayList<String>(party.size());
        ArrayList<String> onlineNames = new ArrayList<String>();
        for (PartyMember member : party.getMembers()) {
            memberNames.add(member.getName());
            if (!member.isOnline()) continue;
            onlineNames.add(member.getName());
        }
        this.lang.sendMessage(sender, "COMMAND.party.list", "members_count", memberNames.size(), "members", !memberNames.isEmpty() ? StringUtil.join(memberNames, ", ") : this.lang.getMessage("GENERAL.none"), "online_count", onlineNames.size(), "online_members", !onlineNames.isEmpty() ? StringUtil.join(onlineNames, ", ") : this.lang.getMessage("GENERAL.none"), "owner", party.getOwner().getName());
    }
}

