/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.countdown.party;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.countdown.DuelCountdown;
import com.meteordevelopments.duels.match.party.PartyDuelMatch;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.compat.Titles;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class PartyDuelCountdown
extends DuelCountdown {
    private final PartyDuelMatch match;
    private final Map<Party, String> info = new HashMap<Party, String>();

    public PartyDuelCountdown(DuelsPlugin plugin, ArenaImpl arena, PartyDuelMatch match) {
        super(plugin, arena, match, plugin.getConfiguration().getCdPartyDuelMessages(), plugin.getConfiguration().getCdPartyDuelTitles());
        this.match = match;
        match.getAllParties().forEach(party -> this.info.put((Party)party, StringUtil.join(match.getNames((Party)party), ", ")));
    }

    @Override
    protected void sendMessage(String rawMessage, String message, String title) {
        String kitName = this.match.getKit() != null ? this.match.getKit().getName() : this.lang.getMessage("GENERAL.none");
        this.match.getPlayerToParty().forEach((player, value) -> {
            this.config.playSound((Player)player, rawMessage);
            player.sendMessage(message.replace("%opponents%", this.info.get(this.arena.getOpponent((Party)value))).replace("%kit%", kitName).replace("%arena%", this.arena.getName()));
            if (title != null) {
                Titles.send(player, title, null, 0, 20, 50);
            }
        });
    }
}

