/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.kit.edit;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.kit.edit.KitEditManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.projectiles.ProjectileSource;

public class KitEditListener
implements Listener {
    private final DuelsPlugin plugin;

    public KitEditListener(DuelsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (!KitEditManager.getInstance().isEditing(player)) {
            return;
        }
        String command = event.getMessage().toLowerCase().trim();
        if (!command.equals("/kit save") && !command.startsWith("/kit save ")) {
            event.setCancelled(true);
            this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.command-blocked", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player)) {
            event.setCancelled(true);
            this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.drop-blocked", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (KitEditManager.getInstance().isEditing(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (KitEditManager.getInstance().isEditing(player)) {
            if (event.getInventory().getType() != InventoryType.PLAYER && event.getInventory().getType() != InventoryType.CRAFTING) {
                event.setCancelled(true);
                this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.inventory-blocked", new Object[0]);
            }
            if (event.getClick() == ClickType.DROP || event.getClick() == ClickType.CONTROL_DROP) {
                event.setCancelled(true);
                this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.drop-blocked", new Object[0]);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (KitEditManager.getInstance().isEditing(player) && event.getInventory().getType() != InventoryType.PLAYER && event.getInventory().getType() != InventoryType.CRAFTING) {
            event.setCancelled(true);
            this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.inventory-blocked", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player) && event.getInventory().getType() != InventoryType.PLAYER) {
            event.setCancelled(true);
            this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.inventory-blocked", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player) && event.getInventory().getType() != InventoryType.PLAYER) {
            event.getInventory().clear();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (KitEditManager.getInstance().isEditing(player)) {
            event.setKeepInventory(true);
            event.getDrops().clear();
            event.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player)) {
            event.setCancelled(true);
            this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.block-break-blocked", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player)) {
            event.setCancelled(true);
            this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.block-place-blocked", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
            this.plugin.getLang().sendMessage((CommandSender)player, "KIT.EDIT.interact-blocked", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player)) {
            this.plugin.getLogger().info("Player " + player.getName() + " left during kit editing session. Restoring inventory.");
            KitEditManager.getInstance().handlePlayerQuit(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerKick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player)) {
            this.plugin.getLogger().info("Player " + player.getName() + " was kicked during kit editing session. Restoring inventory.");
            KitEditManager.getInstance().handlePlayerQuit(player);
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        ProjectileSource projectileSource = projectile.getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            if (KitEditManager.getInstance().isEditing(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (KitEditManager.getInstance().isEditing(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            player = (Player)entity;
            if (KitEditManager.getInstance().isEditing(player)) {
                event.setCancelled(true);
            }
        }
        if ((entity = event.getEntity()) instanceof Player) {
            player = (Player)entity;
            if (KitEditManager.getInstance().isEditing(player)) {
                event.setCancelled(true);
            }
        }
    }
}

