/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.kit.edit;

import com.meteordevelopments.duels-optimised.shaded.paperlib.PaperLib;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.kit.edit.EditSession;
import com.meteordevelopments.duels.util.hook.PluginHook;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class KitEditManager
extends PluginHook<DuelsPlugin> {
    private static KitEditManager instance;
    private final Map<UUID, EditSession> activeSessions = new HashMap<UUID, EditSession>();
    private final File playerKitsDirectory;
    private final Yaml yaml;

    public KitEditManager(DuelsPlugin plugin) {
        super(plugin, "KitEditManager");
        instance = this;
        this.playerKitsDirectory = new File(plugin.getDataFolder(), "playerkits");
        if (!this.playerKitsDirectory.exists()) {
            this.playerKitsDirectory.mkdirs();
        }
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        this.yaml = new Yaml(options);
    }

    public static KitEditManager getInstance() {
        return instance;
    }

    public boolean startEditSession(Player player, String kitName) {
        UUID playerId = player.getUniqueId();
        if (this.activeSessions.containsKey(playerId)) {
            return false;
        }
        KitImpl kit = ((DuelsPlugin)this.plugin).getKitManager().get(kitName);
        if (kit == null) {
            return false;
        }
        EditSession session = new EditSession(player, kitName);
        this.activeSessions.put(playerId, session);
        PaperLib.teleportAsync((Entity)player, ((DuelsPlugin)this.plugin).getPlayerManager().getKitLobby());
        player.getInventory().clear();
        if (this.hasPlayerKit(player, kitName)) {
            this.loadPlayerKit(player, kitName);
        } else {
            this.loadKitToPlayer(player, kit);
        }
        return true;
    }

    public boolean saveKit(Player player) {
        UUID playerId = player.getUniqueId();
        EditSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return false;
        }
        if (!this.validateKitItems(player, session.getKitName())) {
            ((DuelsPlugin)this.plugin).getLang().sendMessage((CommandSender)player, "KIT.EDIT.invalid-items", new Object[0]);
            this.abortEditSession(player);
            return false;
        }
        try {
            this.savePlayerKit(player, session.getKitName());
            session.restoreInventory(player);
            session.returnToOldLocation(player);
            this.activeSessions.remove(playerId);
            return true;
        }
        catch (IOException e) {
            ((DuelsPlugin)this.plugin).getLogger().severe("Failed to save kit for player " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    public boolean abortEditSession(Player player) {
        UUID playerId = player.getUniqueId();
        EditSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return false;
        }
        session.restoreInventory(player);
        session.returnToOldLocation(player);
        this.activeSessions.remove(playerId);
        return true;
    }

    public boolean forceFreshEditSession(Player player, String kitName) {
        if (this.activeSessions.containsKey(player.getUniqueId())) {
            this.abortEditSession(player);
        }
        return this.startEditSession(player, kitName);
    }

    public boolean isEditing(Player player) {
        return this.activeSessions.containsKey(player.getUniqueId());
    }

    public EditSession getEditSession(Player player) {
        return this.activeSessions.get(player.getUniqueId());
    }

    public void handlePlayerQuit(Player player) {
        UUID playerId = player.getUniqueId();
        EditSession session = this.activeSessions.get(playerId);
        if (session != null) {
            ((DuelsPlugin)this.plugin).getLogger().info("Player " + player.getName() + " left during kit editing session. Restoring inventory.");
            session.returnToOldLocation(player);
            session.restoreInventory(player);
            this.activeSessions.remove(playerId);
        }
    }

    private void loadKitToPlayer(Player player, KitImpl kit) {
        player.getInventory().clear();
        Map<String, Map<Integer, ItemStack>> kitItems = kit.getItems();
        int slot = 0;
        block2: for (Map.Entry<String, Map<Integer, ItemStack>> entry : kitItems.entrySet()) {
            Map<Integer, ItemStack> slotItems = entry.getValue();
            for (ItemStack item : slotItems.values()) {
                if (item == null || item.getType() == Material.AIR) continue;
                try {
                    ItemStack clonedItem = item.clone();
                    player.getInventory().setItem(slot, clonedItem);
                    ++slot;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    continue block2;
                }
            }
        }
        player.updateInventory();
    }

    private void savePlayerKit(Player player, String kitName) throws IOException {
        UUID playerId = player.getUniqueId();
        File playerDir = new File(this.playerKitsDirectory, playerId.toString());
        if (!playerDir.exists()) {
            playerDir.mkdirs();
        }
        File kitFile = new File(playerDir, kitName + ".yml");
        HashMap<String, Object> kitData = new HashMap<String, Object>();
        PlayerInventory inv = player.getInventory();
        ItemStack[] contents = inv.getContents();
        HashMap<String, Map> inventoryData = new HashMap<String, Map>();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null) continue;
            inventoryData.put(String.valueOf(i), contents[i].serialize());
        }
        kitData.put("inventory", inventoryData);
        ItemStack[] armor = inv.getArmorContents();
        HashMap<String, Map> armorData = new HashMap<String, Map>();
        for (int i = 0; i < armor.length; ++i) {
            if (armor[i] == null) continue;
            armorData.put(String.valueOf(i), armor[i].serialize());
        }
        kitData.put("armor", armorData);
        ItemStack offhand = inv.getItemInOffHand();
        if (offhand != null && !offhand.getType().isAir()) {
            kitData.put("offhand", offhand.serialize());
        }
        kitData.put("name", kitName);
        kitData.put("player", player.getName());
        kitData.put("saved_at", System.currentTimeMillis());
        try (FileWriter writer = new FileWriter(kitFile);){
            this.yaml.dump(kitData, (Writer)writer);
        }
    }

    public Map<UUID, EditSession> getActiveSessions() {
        return new HashMap<UUID, EditSession>(this.activeSessions);
    }

    public boolean hasPlayerKit(Player player, String kitName) {
        UUID playerId = player.getUniqueId();
        File playerDir = new File(this.playerKitsDirectory, playerId.toString());
        File kitFile = new File(playerDir, kitName + ".yml");
        return kitFile.exists();
    }

    public void checkAndAbortIfInQueueOrMatch(Player player) {
        if (this.isEditing(player) && (((DuelsPlugin)this.plugin).getQueueManager().get(player) != null || ((DuelsPlugin)this.plugin).getArenaManager().isInMatch(player))) {
            this.abortEditSession(player);
            ((DuelsPlugin)this.plugin).getLang().sendMessage((CommandSender)player, "KIT.EDIT.session-aborted", new Object[0]);
        }
    }

    private boolean validateKitItems(Player player, String kitName) {
        try {
            KitImpl defaultKit = ((DuelsPlugin)this.plugin).getKitManager().get(kitName);
            if (defaultKit == null) {
                return false;
            }
            List<ItemStack> defaultItems = this.getAllItemsFromKit(defaultKit);
            List<ItemStack> playerItems = this.getAllItemsFromPlayer(player);
            return this.itemListsMatch(defaultItems, playerItems);
        }
        catch (Exception e) {
            ((DuelsPlugin)this.plugin).getLogger().severe("Error validating kit items for " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    private List<ItemStack> getAllItemsFromKit(KitImpl kit) {
        HashMap<Material, Integer> itemCounts = new HashMap<Material, Integer>();
        Map<String, Map<Integer, ItemStack>> kitItems = kit.getItems();
        for (Map.Entry<String, Map<Integer, ItemStack>> entry : kitItems.entrySet()) {
            Map<Integer, ItemStack> slotItems = entry.getValue();
            for (ItemStack item : slotItems.values()) {
                if (item == null || item.getType() == Material.AIR) continue;
                itemCounts.put(item.getType(), itemCounts.getOrDefault(item.getType(), 0) + 1);
            }
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry entry : itemCounts.entrySet()) {
            Material material = (Material)entry.getKey();
            int count = (Integer)entry.getValue();
            items.add(new ItemStack(material, count));
        }
        return items;
    }

    private List<ItemStack> getAllItemsFromPlayer(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        PlayerInventory inv = player.getInventory();
        for (ItemStack item : inv.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item);
        }
        for (ItemStack item : inv.getArmorContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item);
        }
        ItemStack offhand = inv.getItemInOffHand();
        if (offhand != null && offhand.getType() != Material.AIR) {
            items.add(offhand);
        }
        return items;
    }

    private boolean itemListsMatch(List<ItemStack> list1, List<ItemStack> list2) {
        HashSet<Material> defaultTypes = new HashSet<Material>();
        HashSet<Material> playerTypes = new HashSet<Material>();
        for (ItemStack item : list1) {
            if (item == null) continue;
            defaultTypes.add(item.getType());
        }
        for (ItemStack item : list2) {
            if (item == null) continue;
            playerTypes.add(item.getType());
        }
        for (Material playerType : playerTypes) {
            if (defaultTypes.contains(playerType)) continue;
            return false;
        }
        return true;
    }

    private boolean itemsMatch(ItemStack item1, ItemStack item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        return item1.getType() == item2.getType();
    }

    public boolean loadPlayerKit(Player player, String kitName) {
        try {
            UUID playerId = player.getUniqueId();
            File playerDir = new File(this.playerKitsDirectory, playerId.toString());
            File kitFile = new File(playerDir, kitName + ".yml");
            if (!kitFile.exists()) {
                return false;
            }
            Map kitData = (Map)this.yaml.load((Reader)new FileReader(kitFile));
            PlayerInventory inv = player.getInventory();
            inv.clear();
            if (kitData.containsKey("inventory")) {
                Map inventoryData = (Map)kitData.get("inventory");
                for (Map.Entry entry : inventoryData.entrySet()) {
                    int slot = Integer.parseInt((String)entry.getKey());
                    Map itemData = (Map)entry.getValue();
                    ItemStack item = ItemStack.deserialize((Map)itemData);
                    inv.setItem(slot, item);
                }
            }
            if (kitData.containsKey("armor")) {
                Map armorData = (Map)kitData.get("armor");
                ItemStack[] armor = new ItemStack[4];
                for (Map.Entry entry : armorData.entrySet()) {
                    ItemStack item;
                    int slot = Integer.parseInt((String)entry.getKey());
                    Map itemData = (Map)entry.getValue();
                    armor[slot] = item = ItemStack.deserialize((Map)itemData);
                }
                inv.setArmorContents(armor);
            }
            if (kitData.containsKey("offhand")) {
                Map offhandData = (Map)kitData.get("offhand");
                ItemStack offhand = ItemStack.deserialize((Map)offhandData);
                inv.setItemInOffHand(offhand);
            }
            player.updateInventory();
            return true;
        }
        catch (Exception e) {
            ((DuelsPlugin)this.plugin).getLogger().severe("Failed to load player kit " + kitName + " for " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }
}

