/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.match.team;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.queue.Queue;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TeamDuelMatch
extends DuelMatch {
    private final Map<Player, Team> playerToTeam = new HashMap<Player, Team>();
    private final Map<Team, Set<Player>> teamToPlayers = new HashMap<Team, Set<Player>>();
    private final Map<Team, Integer> alivePlayers = new HashMap<Team, Integer>();

    public TeamDuelMatch(DuelsPlugin plugin, ArenaImpl arena, KitImpl kit, Map<UUID, List<ItemStack>> items, int bet, Queue source) {
        super(plugin, arena, kit, items, bet, source);
    }

    public Set<Team> getAllTeams() {
        return this.teamToPlayers.keySet();
    }

    public List<String> getTeamNames(Team team) {
        Set<Player> members = this.teamToPlayers.get(team);
        if (members == null) {
            return Collections.emptyList();
        }
        return members.stream().map(Player::getName).collect(Collectors.toList());
    }

    @Override
    public void addPlayer(Player player) {
        super.addPlayer(player);
        Team team = this.getOrCreateTeam(player);
        this.playerToTeam.put(player, team);
        this.teamToPlayers.computeIfAbsent(team, k -> new HashSet()).add(player);
        this.alivePlayers.compute(team, (k, count) -> count == null ? 1 : count + 1);
    }

    private Team getOrCreateTeam(Player player) {
        int totalPlayers = this.getAllPlayers().size();
        int teamNumber = totalPlayers <= this.getSource().getTeamSize() ? 1 : 2;
        return new Team(teamNumber);
    }

    @Override
    public void markAsDead(Player player) {
        super.markAsDead(player);
        Team team = this.playerToTeam.get(player);
        if (team == null) {
            return;
        }
        player.spigot().respawn();
        player.setGameMode(GameMode.SPECTATOR);
        Integer count = this.alivePlayers.get(team);
        if (count == null) {
            return;
        }
        this.alivePlayers.put(team, count - 1);
    }

    @Override
    public int size() {
        return (int)this.alivePlayers.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).count();
    }

    public boolean isTeamEliminated(Team team) {
        return this.alivePlayers.getOrDefault(team, 0) <= 0;
    }

    public Set<Player> getAlivePlayersInTeam(Team team) {
        return this.teamToPlayers.getOrDefault(team, Collections.emptySet()).stream().filter(player -> !this.isDead((Player)player)).collect(Collectors.toSet());
    }

    public Team getWinningTeam() {
        return this.alivePlayers.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public Set<Player> getWinningTeamPlayers() {
        Team winningTeam = this.getWinningTeam();
        if (winningTeam == null) {
            return Collections.emptySet();
        }
        return this.teamToPlayers.getOrDefault(winningTeam, Collections.emptySet());
    }

    public Set<Player> getLosingTeamPlayers() {
        Team winningTeam = this.getWinningTeam();
        if (winningTeam == null) {
            return Collections.emptySet();
        }
        return this.teamToPlayers.entrySet().stream().filter(entry -> !((Team)entry.getKey()).equals(winningTeam)).flatMap(entry -> ((Set)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    @Generated
    public Map<Player, Team> getPlayerToTeam() {
        return this.playerToTeam;
    }

    @Generated
    public Map<Team, Set<Player>> getTeamToPlayers() {
        return this.teamToPlayers;
    }

    public static class Team {
        private final int teamNumber;

        public Team(int teamNumber) {
            this.teamNumber = teamNumber;
        }

        public int getTeamNumber() {
            return this.teamNumber;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Team team = (Team)obj;
            return this.teamNumber == team.teamNumber;
        }

        public int hashCode() {
            return Objects.hash(this.teamNumber);
        }

        public String toString() {
            return "Team " + this.teamNumber;
        }
    }
}

