/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.util;

import com.meteordevelopments.duels.DuelsPlugin;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import lombok.Generated;
import org.json.JSONObject;

public class UpdateManager {
    private DuelsPlugin main;
    private URL versionURL;
    private boolean updateIsAvailable = false;
    private String currentVersion;
    private String latestVersion;

    public UpdateManager(DuelsPlugin main) {
        this.main = main;
    }

    public void checkForUpdate() {
        if (this.versionURL == null) {
            try {
                this.versionURL = new URL("https://version.itzadarsh-kushwaha.workers.dev/legacy/update.php");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        URLConnection spigotConnection = null;
        try {
            spigotConnection = this.versionURL.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.latestVersion = new BufferedReader(new InputStreamReader(spigotConnection.getInputStream())).readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.latestVersion != null && !this.getCurrentVersion().equals(this.latestVersion)) {
            this.setLatestVersion(this.latestVersion);
            this.setUpdateAvailability(true);
            if (this.main.getConfiguration().isStayUpToDate()) {
                this.fetchAndDownloadFromModrinth();
            }
        }
    }

    private void fetchAndDownloadFromModrinth() {
        try {
            String inputLine;
            URL modrinthUrl = new URL("https://api.modrinth.com/v2/project/duels-optimised/version/" + this.latestVersion);
            URLConnection modrinthConnection = modrinthUrl.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(modrinthConnection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            String jsonResponse = response.toString();
            JSONObject jsonObject = new JSONObject(jsonResponse);
            String downloadUrl = jsonObject.getJSONArray("files").getJSONObject(0).getString("url");
            this.deleteOldFiles("plugins", "Duels-Optimised");
            this.downloadLatestPlugin(downloadUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteOldFiles(String directory, String prefix) {
        try (Stream<Path> paths = Files.list(Paths.get(directory, new String[0]));){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(prefix)).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void downloadLatestPlugin(String downloadUrl) {
        try (BufferedInputStream in = new BufferedInputStream(new URL(downloadUrl).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream("plugins/Duels-Optimised-" + this.latestVersion + ".jar");){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean updateIsAvailable() {
        return this.updateIsAvailable;
    }

    public void setUpdateAvailability(boolean availability) {
        this.updateIsAvailable = availability;
    }

    public String getCurrentVersion() {
        if (this.currentVersion == null) {
            this.currentVersion = this.main.getDescription().getVersion();
        }
        return this.currentVersion;
    }

    private void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }
}

