/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.extension.hooks;

import com.meteordevelopments.duels.api.arena.Arena;
import com.meteordevelopments.duels.api.kit.Kit;
import com.meteordevelopments.duels.api.match.Match;
import com.meteordevelopments.duels.api.spectate.Spectator;
import com.meteordevelopments.duels.api.user.User;
import com.meteordevelopments.extension.Placeholder;
import com.meteordevelopments.extension.compat.Ping;
import com.meteordevelopments.extension.util.StringUtil;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderHook
extends PlaceholderExpansion {
    Placeholder ext = Placeholder.getPx();

    @NotNull
    public String getIdentifier() {
        return "duels";
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return "Dumbo";
    }

    @NotNull
    public String getVersion() {
        return "1.0";
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        Kit kit;
        if (player == null) {
            return "Player is required";
        }
        switch (identifier) {
            case "wins": {
                User user = this.ext.getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(this.ext.getUserNotFound());
                }
                return String.valueOf(user.getWins());
            }
            case "losses": {
                User user = this.ext.getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(this.ext.getUserNotFound());
                }
                return String.valueOf(user.getLosses());
            }
            case "can_request": {
                User user = this.ext.getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(this.ext.getUserNotFound());
                }
                return String.valueOf(user.canRequest());
            }
            case "wl_ratio": 
            case "wlr": {
                User user = this.ext.getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(this.ext.getUserNotFound());
                }
                int wins = user.getWins();
                int losses = user.getLosses();
                return String.valueOf(this.wlr(wins, losses));
            }
        }
        if (identifier.startsWith("rating_")) {
            User user = this.ext.getUserManager().get(player);
            if (user == null) {
                return StringUtil.color(this.ext.getUserNotFound());
            }
            if ((identifier = identifier.replace("rating_", "")).equals("-")) {
                return String.valueOf(user.getRating());
            }
            kit = this.ext.getKitManager().get(identifier);
            return kit != null ? String.valueOf(user.getRating(kit)) : StringUtil.color(this.ext.getNoKit());
        }
        if (identifier.startsWith("getplayersinqueue_")) {
            User user = this.ext.getUserManager().get(player);
            if (user == null) {
                return StringUtil.color(this.ext.getUserNotFound());
            }
            identifier = identifier.replace("getplayersinqueue_", "");
            kit = this.ext.getKitManager().get(identifier);
            if (kit == null) {
                return StringUtil.color(this.ext.getNoKit());
            }
            int queuedPlayers = this.ext.getQueueManager().get(kit, 0).getQueuedPlayers().size();
            return queuedPlayers > 0 ? String.valueOf(queuedPlayers) : "0";
        }
        if (identifier.startsWith("getplayersplayinginqueue_")) {
            User user = this.ext.getUserManager().get(player);
            if (user == null) {
                return StringUtil.color(this.ext.getUserNotFound());
            }
            identifier = identifier.replace("getplayersplayinginqueue_", "");
            kit = this.ext.getKitManager().get(identifier);
            if (kit == null) {
                return StringUtil.color(this.ext.getNoKit());
            }
            long playersInMatch = this.ext.getQueueManager().get(kit, 0).getPlayersInMatch();
            return Long.toString(playersInMatch);
        }
        if (identifier.startsWith("match_")) {
            Match match;
            identifier = identifier.replace("match_", "");
            Arena arena = this.ext.getArenaManager().get(player);
            if (arena == null) {
                Spectator spectator = this.ext.getSpectateManager().get(player);
                if (spectator == null) {
                    return StringUtil.color(this.ext.getNotInMatch());
                }
                arena = spectator.getArena();
                player = spectator.getTarget();
                if (player == null) {
                    return StringUtil.color(this.ext.getNotInMatch());
                }
            }
            if ((match = arena.getMatch()) == null) {
                return StringUtil.color(this.ext.getNotInMatch());
            }
            if (identifier.equalsIgnoreCase("duration")) {
                return DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - match.getStart()), (String)this.ext.getDurationFormat());
            }
            if (identifier.equalsIgnoreCase("kit")) {
                return match.getKit() != null ? match.getKit().getName() : StringUtil.color(this.ext.getNoKit());
            }
            if (identifier.equalsIgnoreCase("arena")) {
                return match.getArena().getName();
            }
            if (identifier.equalsIgnoreCase("bet")) {
                return String.valueOf(match.getBet());
            }
            if (identifier.equalsIgnoreCase("rating")) {
                User user = this.ext.getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(this.ext.getUserNotFound());
                }
                return String.valueOf(match.getKit() != null ? user.getRating(match.getKit()) : user.getRating());
            }
            if (identifier.startsWith("opponent")) {
                Player opponent = null;
                for (Player matchPlayer : match.getPlayers()) {
                    if (matchPlayer.equals((Object)player)) continue;
                    opponent = matchPlayer;
                    break;
                }
                if (opponent == null) {
                    return StringUtil.color(this.ext.getNoOpponent());
                }
                if (identifier.equalsIgnoreCase("opponent")) {
                    return opponent.getName();
                }
                if (identifier.endsWith("_health")) {
                    return String.valueOf(Math.ceil(opponent.getHealth()) * 0.5);
                }
                if (identifier.endsWith("_ping")) {
                    return String.valueOf(Ping.getPing(opponent));
                }
                User user = this.ext.getUserManager().get(opponent);
                if (user == null) {
                    return StringUtil.color(this.ext.getUserNotFound());
                }
                return String.valueOf(match.getKit() != null ? user.getRating(match.getKit()) : user.getRating());
            }
        }
        return null;
    }

    private float wlr(int wins, int losses) {
        if (wins == 0) {
            return losses == 0 ? 0.0f : (float)(-losses);
        }
        if (losses == 0) {
            return wins;
        }
        return wins / losses;
    }
}

