/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.enderscapepatch.impl.res;

import eu.pb4.enderscapepatch.impl.EnderscapePolymerPatch;
import eu.pb4.enderscapepatch.impl.entity.model.EntityModels;
import eu.pb4.enderscapepatch.impl.res.EnabledBooleanProperty;
import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.factorytools.api.resourcepack.ModelModifiers;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.PolyModelInstance;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PackResource;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.AtlasAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ConditionItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.EmptyItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.BooleanProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.CustomModelDataFlagProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import net.bunten.enderscape.Enderscape;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class ResourcePackGenerator {
    private static final Set<String> EXPANDABLE = Set.of("wall", "fence", "slab", "stairs", "pressure_plate", "button");

    public static void setup() {
        BooleanProperty.TYPES.method_65325((Object)Enderscape.id((String)"enabled"), EnabledBooleanProperty.MAP_CODEC);
        PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(ResourcePackGenerator::build);
    }

    private static void build(ResourcePackBuilder builder) {
        class_243 expansion = new class_243(0.08, 0.08, 0.08);
        AtlasAsset.Builder atlas = AtlasAsset.builder();
        for (PolyModelInstance<?> polyModelInstance : EntityModels.ALL) {
            polyModelInstance.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)builder).addData(arg_0, arg_1), atlas);
        }
        try {
            BufferedImage main = ImageIO.read(new ByteArrayInputStream(Objects.requireNonNull(builder.getData("assets/enderscape/textures/entity/drifter/drifter.png"))));
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(Objects.requireNonNull(builder.getData("assets/enderscape/textures/entity/drifter/jelly.png"))));
            BufferedImage out = new BufferedImage(main.getWidth(), main.getHeight(), 2);
            for (int x = 0; x < out.getWidth(); ++x) {
                for (int y = 0; y < out.getHeight(); ++y) {
                    int color = main.getRGB(x, y);
                    int jellyColor = bufferedImage.getRGB(x, y);
                    out.setRGB(x, y, jellyColor != 0 ? jellyColor : color);
                }
            }
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)out, "png", b);
            builder.addData("assets/enderscape/textures/entity/drifter/drifter_with_jelly.png", b.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        builder.forEachResource((string, resource) -> {
            for (String expandable : EXPANDABLE) {
                ModelAsset asset;
                if (!string.contains(expandable) || !string.startsWith("assets/enderscape/models/block/") || !(asset = ModelAsset.fromJson((String)Objects.requireNonNull(resource.asString()))).parent().isPresent()) continue;
                class_2960 parentId = (class_2960)asset.parent().get();
                ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                builder.addData(AssetPaths.model((String)"enderscape-patch", (String)parentId.method_12832()) + ".json", (WritableAsset)ModelModifiers.expandModel((ModelAsset)parentAsset, (class_243)expansion));
            }
        });
        for (Map.Entry entry : ((Map)BlockStateModelManager.UV_LOCKED_MODELS.get("enderscape")).entrySet()) {
            class_243 expand = EXPANDABLE.stream().anyMatch(expandable -> ((String)entry.getKey()).contains((CharSequence)expandable) && ((String)entry.getKey()).startsWith("block/")) ? expansion : class_243.field_1353;
            for (StateModelVariant v : (List)entry.getValue()) {
                String suffix = "_uvlock_" + v.x() + "_" + v.y();
                class_2960 modelId = v.model().method_48331(suffix);
                ModelAsset asset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getData(AssetPaths.model((class_2960)v.model()) + ".json")), StandardCharsets.UTF_8));
                if (!asset.parent().isPresent()) continue;
                class_2960 parentId = (class_2960)asset.parent().get();
                ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                builder.addData(AssetPaths.model((String)"enderscape-patch", (String)(parentId.method_12832() + suffix)) + ".json", (WritableAsset)ModelModifiers.expandModelAndRotateUVLocked((ModelAsset)parentAsset, (class_243)expand, (int)v.x(), (int)v.y()));
                builder.addData(AssetPaths.model((class_2960)modelId) + ".json", new ModelAsset(Optional.of(class_2960.method_60655((String)"enderscape-patch", (String)(parentId.method_12832() + suffix))), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
            }
        }
        builder.addResourceConverter((string, resource) -> {
            if (!string.contains("_uvlock_")) {
                for (String expandable : EXPANDABLE) {
                    if (!string.contains(expandable) || !string.startsWith("assets/enderscape/models/block/")) continue;
                    ModelAsset asset = ModelAsset.fromJson((String)Objects.requireNonNull(resource.asString()));
                    return PackResource.fromAsset((WritableAsset)new ModelAsset(asset.parent().map(x -> EnderscapePolymerPatch.id(x.method_12832())), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()));
                }
            }
            if (string.equals("assets/enderscape/items/magnia_attractor.json")) {
                ItemAsset asset = ItemAsset.fromJson((String)Objects.requireNonNull(resource.asString()));
                ItemModel.Replacer[] replacer = new ItemModel.Replacer[]{null};
                replacer[0] = (parent, model) -> {
                    ConditionItemModel conditionItemModel;
                    if (model instanceof ConditionItemModel && (conditionItemModel = (ConditionItemModel)model).property() instanceof EnabledBooleanProperty) {
                        return new ConditionItemModel((BooleanProperty)new CustomModelDataFlagProperty(0), replacer[0].modifyDeep(model, conditionItemModel.onTrue()), replacer[0].modifyDeep(model, conditionItemModel.onFalse()));
                    }
                    return model;
                };
                return PackResource.fromAsset((WritableAsset)new ItemAsset(replacer[0].modifyDeep((ItemModel)EmptyItemModel.INSTANCE, asset.model()), asset.properties()));
            }
            return resource;
        });
        ModelModifiers.createSignModel((ResourcePackBuilder)builder, (String)"enderscape", (String)"veiled", (AtlasAsset.Builder)atlas);
        ModelModifiers.createSignModel((ResourcePackBuilder)builder, (String)"enderscape", (String)"celestial", (AtlasAsset.Builder)atlas);
        ModelModifiers.createSignModel((ResourcePackBuilder)builder, (String)"enderscape", (String)"murublight", (AtlasAsset.Builder)atlas);
        builder.addData("assets/minecraft/atlases/blocks.json", (WritableAsset)atlas.build());
    }
}

