/*
 * Decompiled with CFR 0.152.
 */
package me.drex.quickpack.packs;

import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FastFilePackResources
extends AbstractPackResources {
    public static final Logger LOGGER = LogUtils.getLogger();
    private final TreeMap<String, byte[]> fileMap = new TreeMap();
    private final Map<String, Set<String>> namespaces = new HashMap<String, Set<String>>();
    private ZipFile zipFile = null;
    private final List<String> prefixStack;
    private final Set<String> overlays = Collections.emptySet();

    public FastFilePackResources(File file) {
        super(file);
        try {
            this.zipFile = new ZipFile(file);
        }
        catch (IOException e) {
            LOGGER.error("Failed to open pack {}", (Object)file, (Object)e);
        }
        this.prefixStack = new ArrayList<String>(1);
        this.prefixStack.add("");
        this.extractFiles();
    }

    public void extractFiles() {
        if (this.zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            this.extractNamespace(path);
            try {
                InputStream in = this.zipFile.getInputStream(entry);
                try {
                    byte[] data = in.readAllBytes();
                    this.fileMap.put(path, data);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load resource {}", (Object)path, (Object)e);
            }
        }
    }

    private void extractNamespace(String path) {
        String namespace;
        String type;
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return;
        }
        boolean isOverlay = this.overlays.contains(parts[0]);
        if (isOverlay && parts.length >= 3) {
            type = parts[1];
            namespace = parts[2];
        } else if (!isOverlay && parts.length >= 2) {
            type = parts[0];
            namespace = parts[1];
        } else {
            return;
        }
        if (namespace.equals(namespace.toLowerCase(Locale.ROOT))) {
            this.namespaces.computeIfAbsent(type, s -> new HashSet()).add(namespace);
        } else {
            LOGGER.warn("Ignored non-lowercase namespace: {} in {}", (Object)namespace, (Object)this.zipFile);
        }
    }

    public Collection<ResourceLocation> m_214146_(PackType packType, String namespace, String path, Predicate<ResourceLocation> predicate) {
        LinkedList<ResourceLocation> list = new LinkedList<ResourceLocation>();
        for (String prefix : this.prefixStack) {
            String namespacePrefix = prefix + packType.m_10305_() + "/" + namespace + "/";
            String dirPrefix = namespacePrefix + path + "/";
            String end = dirPrefix + "\uffff";
            this.fileMap.subMap(dirPrefix, end).forEach((filePath, bytes) -> {
                if (filePath.endsWith(".mcmeta")) {
                    return;
                }
                String rlPath = filePath.substring(namespacePrefix.length());
                ResourceLocation location = ResourceLocation.m_214293_((String)namespace, (String)rlPath);
                if (location == null) {
                    LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)rlPath);
                } else if (predicate.test(location)) {
                    list.add(location);
                }
            });
        }
        return list;
    }

    public Set<String> m_5698_(PackType packType) {
        return this.namespaces.getOrDefault(packType.m_10305_(), Collections.emptySet());
    }

    public void close() {
        if (this.zipFile != null) {
            IOUtils.closeQuietly((Closeable)this.zipFile);
        }
    }

    protected InputStream m_5541_(String string) throws IOException {
        for (String prefix : this.prefixStack) {
            byte[] data = this.fileMap.get(prefix + string);
            if (data == null) continue;
            return new ByteArrayInputStream(data);
        }
        throw new ResourcePackFileNotFoundException(this.f_10203_, string);
    }

    protected boolean m_6105_(String string) {
        for (String prefix : this.prefixStack) {
            byte[] data = this.fileMap.get(prefix + string);
            if (data == null) continue;
            return true;
        }
        return false;
    }
}

