/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.allaboutengie.network;

import java.util.function.Supplier;
import net.mcreator.allaboutengie.AllaboutengieMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AllaboutengieModVariables {
    public static boolean decembercodeblock = true;
    public static boolean seasonwinter = false;
    public static boolean seasonautumn = false;
    public static boolean seasonsummer = false;
    public static boolean seasonspring = false;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AllaboutengieMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        AllaboutengieMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.firstplay = message.data.firstplay;
                    variables.detecstart = message.data.detecstart;
                    variables.coderedeemblock = message.data.coderedeemblock;
                    variables.coincount = message.data.coincount;
                    variables.browniescount = message.data.browniescount;
                    variables.cheeseballcount = message.data.cheeseballcount;
                    variables.PlayerX = message.data.PlayerX;
                    variables.PlayerY = message.data.PlayerY;
                    variables.PlayerZ = message.data.PlayerZ;
                    variables.HHGLookX = message.data.HHGLookX;
                    variables.HHGLookY = message.data.HHGLookY;
                    variables.HHGLookZ = message.data.HHGLookZ;
                    variables.GoodLuck = message.data.GoodLuck;
                    variables.playerready = message.data.playerready;
                    variables.AngryEngieKillCount = message.data.AngryEngieKillCount;
                    variables.EnragedEngieKillCount = message.data.EnragedEngieKillCount;
                    variables.OutragedEngieKillCount = message.data.OutragedEngieKillCount;
                    variables.InsanityKillCount = message.data.InsanityKillCount;
                    variables.MadEngieKillCount = message.data.MadEngieKillCount;
                    variables.solotrophyobtained = message.data.solotrophyobtained;
                    variables.multiplayertrophyobtained = message.data.multiplayertrophyobtained;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean firstplay = false;
        public boolean detecstart = false;
        public boolean coderedeemblock = false;
        public double coincount = 0.0;
        public double browniescount = 0.0;
        public double cheeseballcount = 0.0;
        public double PlayerX = 0.0;
        public double PlayerY = 0.0;
        public double PlayerZ = 0.0;
        public double HHGLookX = 0.0;
        public double HHGLookY = 0.0;
        public double HHGLookZ = 0.0;
        public boolean GoodLuck = false;
        public boolean playerready = false;
        public double AngryEngieKillCount = 0.0;
        public double EnragedEngieKillCount = 0.0;
        public double OutragedEngieKillCount = 0.0;
        public double InsanityKillCount = 0.0;
        public double MadEngieKillCount = 0.0;
        public boolean solotrophyobtained = false;
        public boolean multiplayertrophyobtained = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AllaboutengieMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("firstplay", this.firstplay);
            nbt.m_128379_("detecstart", this.detecstart);
            nbt.m_128379_("coderedeemblock", this.coderedeemblock);
            nbt.m_128347_("coincount", this.coincount);
            nbt.m_128347_("browniescount", this.browniescount);
            nbt.m_128347_("cheeseballcount", this.cheeseballcount);
            nbt.m_128347_("PlayerX", this.PlayerX);
            nbt.m_128347_("PlayerY", this.PlayerY);
            nbt.m_128347_("PlayerZ", this.PlayerZ);
            nbt.m_128347_("HHGLookX", this.HHGLookX);
            nbt.m_128347_("HHGLookY", this.HHGLookY);
            nbt.m_128347_("HHGLookZ", this.HHGLookZ);
            nbt.m_128379_("GoodLuck", this.GoodLuck);
            nbt.m_128379_("playerready", this.playerready);
            nbt.m_128347_("AngryEngieKillCount", this.AngryEngieKillCount);
            nbt.m_128347_("EnragedEngieKillCount", this.EnragedEngieKillCount);
            nbt.m_128347_("OutragedEngieKillCount", this.OutragedEngieKillCount);
            nbt.m_128347_("InsanityKillCount", this.InsanityKillCount);
            nbt.m_128347_("MadEngieKillCount", this.MadEngieKillCount);
            nbt.m_128379_("solotrophyobtained", this.solotrophyobtained);
            nbt.m_128379_("multiplayertrophyobtained", this.multiplayertrophyobtained);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.firstplay = nbt.m_128471_("firstplay");
            this.detecstart = nbt.m_128471_("detecstart");
            this.coderedeemblock = nbt.m_128471_("coderedeemblock");
            this.coincount = nbt.m_128459_("coincount");
            this.browniescount = nbt.m_128459_("browniescount");
            this.cheeseballcount = nbt.m_128459_("cheeseballcount");
            this.PlayerX = nbt.m_128459_("PlayerX");
            this.PlayerY = nbt.m_128459_("PlayerY");
            this.PlayerZ = nbt.m_128459_("PlayerZ");
            this.HHGLookX = nbt.m_128459_("HHGLookX");
            this.HHGLookY = nbt.m_128459_("HHGLookY");
            this.HHGLookZ = nbt.m_128459_("HHGLookZ");
            this.GoodLuck = nbt.m_128471_("GoodLuck");
            this.playerready = nbt.m_128471_("playerready");
            this.AngryEngieKillCount = nbt.m_128459_("AngryEngieKillCount");
            this.EnragedEngieKillCount = nbt.m_128459_("EnragedEngieKillCount");
            this.OutragedEngieKillCount = nbt.m_128459_("OutragedEngieKillCount");
            this.InsanityKillCount = nbt.m_128459_("InsanityKillCount");
            this.MadEngieKillCount = nbt.m_128459_("MadEngieKillCount");
            this.solotrophyobtained = nbt.m_128471_("solotrophyobtained");
            this.multiplayertrophyobtained = nbt.m_128471_("multiplayertrophyobtained");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("allaboutengie", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "allaboutengie_mapvars";
        public boolean SharkoRetryState = false;
        public boolean hewhowatches = false;
        public double nightmare = 0.0;
        public boolean HHGkilledtoggle = false;
        public double challengeplayerreadyupcount = 0.0;
        public boolean ChallengeToggle = false;
        public boolean BYEBYE = false;
        public boolean Birthday = false;
        public boolean WELCOMETOINSANITY = false;
        public boolean birthdaystart = false;
        public boolean SharkoLayCD = false;
        public boolean SharkoSleepCD = false;
        public boolean madlads = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.SharkoRetryState = nbt.m_128471_("SharkoRetryState");
            this.hewhowatches = nbt.m_128471_("hewhowatches");
            this.nightmare = nbt.m_128459_("nightmare");
            this.HHGkilledtoggle = nbt.m_128471_("HHGkilledtoggle");
            this.challengeplayerreadyupcount = nbt.m_128459_("challengeplayerreadyupcount");
            this.ChallengeToggle = nbt.m_128471_("ChallengeToggle");
            this.BYEBYE = nbt.m_128471_("BYEBYE");
            this.Birthday = nbt.m_128471_("Birthday");
            this.WELCOMETOINSANITY = nbt.m_128471_("WELCOMETOINSANITY");
            this.birthdaystart = nbt.m_128471_("birthdaystart");
            this.SharkoLayCD = nbt.m_128471_("SharkoLayCD");
            this.SharkoSleepCD = nbt.m_128471_("SharkoSleepCD");
            this.madlads = nbt.m_128471_("madlads");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("SharkoRetryState", this.SharkoRetryState);
            nbt.m_128379_("hewhowatches", this.hewhowatches);
            nbt.m_128347_("nightmare", this.nightmare);
            nbt.m_128379_("HHGkilledtoggle", this.HHGkilledtoggle);
            nbt.m_128347_("challengeplayerreadyupcount", this.challengeplayerreadyupcount);
            nbt.m_128379_("ChallengeToggle", this.ChallengeToggle);
            nbt.m_128379_("BYEBYE", this.BYEBYE);
            nbt.m_128379_("Birthday", this.Birthday);
            nbt.m_128379_("WELCOMETOINSANITY", this.WELCOMETOINSANITY);
            nbt.m_128379_("birthdaystart", this.birthdaystart);
            nbt.m_128379_("SharkoLayCD", this.SharkoLayCD);
            nbt.m_128379_("SharkoSleepCD", this.SharkoSleepCD);
            nbt.m_128379_("madlads", this.madlads);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                AllaboutengieMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "allaboutengie_worldvars";
        public boolean yeah = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.yeah = nbt.m_128471_("yeah");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("yeah", this.yeah);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                AllaboutengieMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.detecstart = original.detecstart;
            clone.coderedeemblock = original.coderedeemblock;
            clone.coincount = original.coincount;
            clone.browniescount = original.browniescount;
            clone.cheeseballcount = original.cheeseballcount;
            clone.PlayerX = original.PlayerX;
            clone.PlayerY = original.PlayerY;
            clone.PlayerZ = original.PlayerZ;
            clone.HHGLookX = original.HHGLookX;
            clone.HHGLookY = original.HHGLookY;
            clone.HHGLookZ = original.HHGLookZ;
            clone.GoodLuck = original.GoodLuck;
            clone.playerready = original.playerready;
            clone.AngryEngieKillCount = original.AngryEngieKillCount;
            clone.EnragedEngieKillCount = original.EnragedEngieKillCount;
            clone.OutragedEngieKillCount = original.OutragedEngieKillCount;
            clone.InsanityKillCount = original.InsanityKillCount;
            clone.MadEngieKillCount = original.MadEngieKillCount;
            clone.solotrophyobtained = original.solotrophyobtained;
            clone.multiplayertrophyobtained = original.multiplayertrophyobtained;
            if (!event.isWasDeath()) {
                clone.firstplay = original.firstplay;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    AllaboutengieMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    AllaboutengieMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                AllaboutengieMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

