/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.client.screen.config.entry;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.deadlydiamond98.koalalib.client.screen.config.inputs.BooleanButton;
import net.deadlydiamond98.koalalib.client.screen.config.inputs.EnumButton;
import net.deadlydiamond98.koalalib.client.screen.config.inputs.IConfigEntry;
import net.deadlydiamond98.koalalib.client.screen.config.inputs.text.DoubleInput;
import net.deadlydiamond98.koalalib.client.screen.config.inputs.text.FloatInput;
import net.deadlydiamond98.koalalib.client.screen.config.inputs.text.NumberInput;
import net.deadlydiamond98.koalalib.client.screen.config.inputs.text.StringInput;
import net.deadlydiamond98.koalalib.config.CFGProperties;
import net.deadlydiamond98.koalalib.config.KoalaConfigCreator;
import net.deadlydiamond98.koalalib.config.KoalaLibConfigs;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;

public class ConfigEntries {
    public final List<class_339> entries = new ArrayList<class_339>();

    public List<class_339> getEntries() {
        return this.entries;
    }

    public void renderEntries(class_332 context, int mouseX, int mouseY, float delta, int width, int height) {
        this.entries.forEach(widget -> {
            if (KoalaLibConfigs.Main.fancyTransitions) {
                widget.method_46421((int)class_3532.method_16436((double)0.1, (double)widget.method_46426(), (double)(width - 100)));
            } else {
                widget.method_46421(width - 100);
            }
        });
    }

    public void renderEntryTooltips(class_327 textRenderer, class_332 context, int mouseX, int mouseY) {
        this.entries.forEach(widget -> {
            if (widget instanceof IConfigEntry) {
                IConfigEntry button = (IConfigEntry)widget;
                button.renderDescriptionTooltip(context, textRenderer, mouseX, mouseY);
            }
        });
    }

    public void scrollEntries(int scrollOffset) {
        this.entries.forEach(widget -> {
            if (widget instanceof IConfigEntry) {
                IConfigEntry entry = (IConfigEntry)widget;
                entry.scroll(-scrollOffset);
            }
        });
    }

    public void swapDisplayedConfigEntries(String oldModID, String modID, int width, class_327 textRenderer) {
        if (oldModID != null) {
            Class oldConfigScreen = (Class)KoalaConfigCreator.MOD_CONFIGS.get(oldModID).getA();
            this.applyConfigValues(oldConfigScreen);
        }
        Class configScreen = (Class)KoalaConfigCreator.MOD_CONFIGS.get(modID).getA();
        this.entries.clear();
        try {
            int i = 0;
            for (Field field : configScreen.getFields()) {
                Object value = field.get(configScreen);
                this.entries.add(this.getWidget(field, value, i++, width, textRenderer, modID));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyConfigValues(Class<?> configScreen) {
        try {
            int i = 0;
            for (Field field : configScreen.getFields()) {
                Object value;
                class_339 entry = this.entries.get(i++);
                Class<?> type = field.getType();
                if (entry instanceof BooleanButton) {
                    BooleanButton bl = (BooleanButton)entry;
                    value = bl.getBool();
                } else if (entry instanceof EnumButton) {
                    EnumButton enumm = (EnumButton)entry;
                    value = enumm.getEnum();
                } else if (entry instanceof StringInput) {
                    StringInput input = (StringInput)entry;
                    String tempVal = input.method_1882();
                    value = type == Integer.TYPE ? Integer.valueOf(Integer.parseInt(tempVal)) : (type == Double.TYPE ? Double.valueOf(Double.parseDouble(tempVal)) : (type == Float.TYPE ? Float.valueOf(Float.parseFloat(tempVal)) : tempVal));
                } else {
                    return;
                }
                field.set(configScreen, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class_339 getWidget(Field field, Object value, int offsetY, int screenWidth, class_327 textRenderer, String modID) {
        Class<?> type = field.getType();
        String translation = modID + ".config." + field.getName();
        int x = screenWidth + 400;
        int y = offsetY * 25 + 34;
        int width = 75;
        int height = 20;
        IConfigEntry entry = type == Integer.TYPE ? new NumberInput(translation, textRenderer, x, y, width, height, (Integer)value) : (type == Double.TYPE ? new DoubleInput(translation, textRenderer, x, y, width, height, (Double)value) : (type == Float.TYPE ? new FloatInput(translation, textRenderer, x, y, width, height, ((Float)value).floatValue()) : (type == Boolean.TYPE ? new BooleanButton(translation, x, y, width, height, (Boolean)value) : (type.isEnum() ? new EnumButton(translation, x, y, width, height, type, (Enum)value, modID + ".enum." + field.getName() + ".") : new StringInput(translation, textRenderer, x, y, width, height, value.toString())))));
        if (field.isAnnotationPresent(CFGProperties.class)) {
            CFGProperties cfgProperties = field.getAnnotation(CFGProperties.class);
            entry = this.applyProperties((class_339)entry, cfgProperties);
        }
        return entry;
    }

    private class_339 applyProperties(class_339 entry, CFGProperties cfgProperties) {
        if (entry instanceof IConfigEntry) {
            IConfigEntry configEntry = (IConfigEntry)entry;
            configEntry.enableDesc(cfgProperties.hasDesc());
        }
        if (entry instanceof StringInput) {
            StringInput configTextInput = (StringInput)entry;
            configTextInput.setMaxNumber(cfgProperties.max());
            configTextInput.setMinNumber(cfgProperties.min());
        }
        return entry;
    }
}

