/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.deadlydiamond98.koalalib.KoalaLib;
import net.deadlydiamond98.koalalib.ToggleableContent;
import net.deadlydiamond98.koalalib.config.KoalaLibConfigs;
import net.deadlydiamond98.koalalib.util.ColorHelper;
import net.deadlydiamond98.koalalib.util.magic.MagicBarHelper;
import net.deadlydiamond98.koalalib.util.magic.MagicMeterRenderType;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1309;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class MagicBarHud
implements HudRenderCallback {
    private static final class_2960 MAGIC_BAR_TEXTURE = new class_2960("koalalib", "textures/gui/magic_bar.png");
    private static float displayedManaLvl;
    private static final float LERP_VALUE = 0.05f;
    private static final int START_COLOR = -1;
    private static final int END_COLOR = -16711844;
    private static int currentColor;
    private static final float START_ALPHA = 1.0f;
    private static final float END_ALPHA = 0.0f;
    private static float centerBarAlpha;
    private static float globalAlpha;

    public void onHudRender(class_332 drawContext, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_4587 matrices = drawContext.method_51448();
        this.updateAlphaForRenderSometimes(client);
        if (!this.shouldRender(client)) {
            return;
        }
        int width = client.method_22683().method_4486();
        int height = client.method_22683().method_4502();
        int posX = width / 2 - 320 + KoalaLibConfigs.MagicBar.manaBarPositionX;
        int posY = height - 42 - KoalaLibConfigs.MagicBar.manaBarPositionY;
        this.renderMagicBar(drawContext, matrices, client, posX, posY, tickDelta);
    }

    private void renderMagicBar(class_332 drawContext, class_4587 matrices, class_310 client, int posX, int posY, float tickDelta) {
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.renderBarPart(drawContext, posX, posY, 0, 0, 42, globalAlpha);
        this.updateDisplayedManaLvl(client, tickDelta);
        this.updateCenterAlpha(client);
        int displayHeight = this.getDisplayHeight(client);
        this.renderBarPart(drawContext, posX, posY + 4 + (33 - displayHeight), 16, 33 - displayHeight + 4, displayHeight, (float)((double)globalAlpha * Math.ceil(centerBarAlpha)));
        this.renderBarPart(drawContext, posX, posY + 4 + (33 - displayHeight), 32, 33 - displayHeight + 4, displayHeight, globalAlpha * (1.0f - centerBarAlpha));
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)globalAlpha);
        this.renderMagicBarText(drawContext, matrices, client, posX, posY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22909();
    }

    private void renderMagicBarText(class_332 drawContext, class_4587 matrices, class_310 client, int posX, int posY) {
        class_327 textRenderer = client.field_1772;
        String displayManaText = Math.round(displayedManaLvl) + " / " + this.getMaxMana(client);
        String displayedZeros = "";
        if (Math.round(displayedManaLvl) < 10) {
            displayedZeros = "00";
        } else if (Math.round(displayedManaLvl) < 100) {
            displayedZeros = "0";
        }
        class_5250 magicLvlText = class_2561.method_43470((String)(displayedZeros + displayManaText)).method_10862(class_2583.field_24360.method_27704(KoalaLib.ZELDA_FONT));
        matrices.method_46416((float)(posX + KoalaLibConfigs.MagicBar.manaBarTextOffsetX), (float)(posY + KoalaLibConfigs.MagicBar.manaBarTextOffsetY), 0.0f);
        matrices.method_22905(0.75f, 0.75f, 0.75f);
        drawContext.method_51439(textRenderer, (class_2561)magicLvlText, 0, 0, this.getTextColor(client), false);
    }

    private void renderBarPart(class_332 drawContext, int posX, int posY, int u, int v, int height, float alpha) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShaderTexture((int)0, (class_2960)MAGIC_BAR_TEXTURE);
        drawContext.method_25290(MAGIC_BAR_TEXTURE, posX, posY, (float)u, (float)v, 16, height, 48, 42);
    }

    private void updateAlphaForRenderSometimes(class_310 client) {
        boolean isWhenNeededMode = KoalaLibConfigs.MagicBar.manaBarRenderType == MagicMeterRenderType.When_Needed;
        boolean cooldownGoesAway = MagicBarHelper.getBar((class_1309)client.field_1724).koalalib$getMagicBarRenderTime() <= 0;
        float end = isWhenNeededMode && cooldownGoesAway ? 0.0f : 1.0f;
        globalAlpha = class_3532.method_16439((float)0.05f, (float)globalAlpha, (float)end);
        globalAlpha = globalAlpha < 0.01f ? 0.0f : globalAlpha;
    }

    private void updateCenterAlpha(class_310 client) {
        float end = this.getManaLvl(client) >= this.getMaxMana(client) ? 0.0f : 1.0f;
        centerBarAlpha = class_3532.method_16439((float)0.05f, (float)centerBarAlpha, (float)end);
        centerBarAlpha = centerBarAlpha < 0.01f ? 0.0f : centerBarAlpha;
    }

    private int getTextColor(class_310 client) {
        int endHex = this.getManaLvl(client) >= this.getMaxMana(client) ? -16711844 : -1;
        currentColor = ColorHelper.blendHexColors(currentColor, endHex, 0.05f);
        return currentColor;
    }

    private int getDisplayHeight(class_310 client) {
        return (int)(displayedManaLvl / (float)this.getMaxMana(client) * 33.0f);
    }

    public void updateDisplayedManaLvl(class_310 client, float tickDelta) {
        displayedManaLvl = class_3532.method_16439((float)(tickDelta * 0.25f), (float)displayedManaLvl, (float)this.getManaLvl(client));
        displayedManaLvl = Math.min(displayedManaLvl, (float)this.getMaxMana(client));
    }

    private int getManaLvl(class_310 client) {
        return MagicBarHelper.getMana((class_1309)client.field_1724);
    }

    private int getMaxMana(class_310 client) {
        return MagicBarHelper.getMaxMana((class_1309)client.field_1724);
    }

    public boolean shouldRender(class_310 client) {
        class_746 player = client.field_1724;
        class_1934 currentGamemode = client.field_1761.method_2920();
        return player != null && currentGamemode.method_8388() && globalAlpha > 0.0f && KoalaLibConfigs.MagicBar.manaBarRenderType != MagicMeterRenderType.Never && ToggleableContent.isMagicBarEnabled();
    }

    static {
        currentColor = -1;
        centerBarAlpha = 1.0f;
        globalAlpha = 1.0f;
    }
}

