/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.common.entity;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2643;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class PhysicsProjectile
extends class_1676 {
    private static final class_2940<Float> DRAG = class_2945.method_12791(PhysicsProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> BOUNCINESS = class_2945.method_12791(PhysicsProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> GRAVITY = class_2945.method_12791(PhysicsProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> BUOYANCY = class_2945.method_12791(PhysicsProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> WATER_DRAG = class_2945.method_12791(PhysicsProjectile.class, (class_2941)class_2943.field_13320);
    protected boolean canEnterPortals = true;
    protected int maxLife = 100;
    private int despawnTimer;

    public PhysicsProjectile(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void method_5773() {
        super.method_5773();
        this.checkCollision();
        this.tickMovement();
        this.tickDespawn();
    }

    protected void tickDespawn() {
        if (!this.method_37908().field_9236) {
            if (this.method_18798().method_1027() < 0.005) {
                if (this.despawnTimer++ >= this.getMaxDespawnTime()) {
                    this.despawnProjectile();
                }
            } else {
                this.despawnTimer = 0;
            }
        }
    }

    protected void despawnProjectile() {
        this.method_31472();
    }

    protected void tickMovement() {
        this.moveWithBounce(class_1313.field_6308, this.method_18798());
        if (this.method_5799()) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)this.getBuoyancy(), 0.0));
            this.method_18799(this.method_18798().method_1021((double)this.getFluidDrag()));
        } else {
            this.method_18799(this.method_18798().method_1021((double)this.getDrag()));
        }
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)(-this.getGravity()), 0.0));
        }
    }

    protected void hitWall(boolean hitXAxis, boolean hitZAxis) {
        if (hitXAxis) {
            this.method_18799(this.method_18798().method_18805((double)(-this.getBounciness()), 1.0, 1.0));
        }
        if (hitZAxis) {
            this.method_18799(this.method_18798().method_18805(1.0, 1.0, (double)(-this.getBounciness())));
        }
    }

    protected void hitFloor(class_2248 block) {
        float slipperiness = block.method_9499();
        this.method_18799(this.method_18798().method_18805((double)slipperiness, (double)(-this.getBounciness()), (double)slipperiness));
    }

    protected void checkCollision() {
        class_239 hitResult = class_1675.method_49997((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
        boolean collidedWithPortal = false;
        if (hitResult.method_17783() == class_239.class_240.field_1332 && this.canEnterPortals) {
            class_2338 blockPos = ((class_3965)hitResult).method_17777();
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_10316)) {
                this.method_5717(blockPos);
                collidedWithPortal = true;
            } else if (blockState.method_27852(class_2246.field_10613)) {
                class_2586 blockEntity = this.method_37908().method_8321(blockPos);
                if (blockEntity instanceof class_2643 && class_2643.method_30276((class_1297)this)) {
                    class_2643.method_11409((class_1937)this.method_37908(), (class_2338)blockPos, (class_2680)blockState, (class_1297)this, (class_2643)((class_2643)blockEntity));
                }
                collidedWithPortal = true;
            }
        }
        if (hitResult.method_17783() != class_239.class_240.field_1333 && !collidedWithPortal) {
            this.method_7488(hitResult);
        }
    }

    protected int getMaxDespawnTime() {
        return this.maxLife;
    }

    protected void setMaxDespawnTime(int maxLife) {
        this.maxLife = maxLife;
    }

    public float getDrag() {
        return ((Float)this.field_6011.method_12789(DRAG)).floatValue();
    }

    public void setDrag(float drag) {
        this.field_6011.method_12778(DRAG, (Object)Float.valueOf(drag));
    }

    public float getGravity() {
        return ((Float)this.field_6011.method_12789(GRAVITY)).floatValue();
    }

    public void setGravity(float gravity) {
        this.field_6011.method_12778(GRAVITY, (Object)Float.valueOf(gravity));
    }

    public float getBounciness() {
        return ((Float)this.field_6011.method_12789(BOUNCINESS)).floatValue();
    }

    public void setBounciness(float bounce) {
        this.field_6011.method_12778(BOUNCINESS, (Object)Float.valueOf(bounce));
    }

    public float getBuoyancy() {
        return ((Float)this.field_6011.method_12789(BUOYANCY)).floatValue();
    }

    public void setBuoyancy(float buoyancy) {
        this.field_6011.method_12778(BUOYANCY, (Object)Float.valueOf(buoyancy));
    }

    public float getFluidDrag() {
        return ((Float)this.field_6011.method_12789(WATER_DRAG)).floatValue();
    }

    public void setWaterDrag(float drag) {
        this.field_6011.method_12778(WATER_DRAG, (Object)Float.valueOf(drag));
    }

    protected void method_5693() {
        this.field_6011.method_12784(DRAG, (Object)Float.valueOf(0.98f));
        this.field_6011.method_12784(WATER_DRAG, (Object)Float.valueOf(0.75f));
        this.field_6011.method_12784(GRAVITY, (Object)Float.valueOf(0.03f));
        this.field_6011.method_12784(BOUNCINESS, (Object)Float.valueOf(0.75f));
        this.field_6011.method_12784(BUOYANCY, (Object)Float.valueOf(0.07f));
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("PhysicsDrag", this.getDrag());
        nbt.method_10548("PhysicsWaterDrag", this.getFluidDrag());
        nbt.method_10548("PhysicsGravity", this.getGravity());
        nbt.method_10548("PhysicsBounce", this.getBounciness());
        nbt.method_10548("PhysicsBuoyancy", this.getBuoyancy());
        nbt.method_10569("PhysicsDespawnTimer", this.despawnTimer);
        nbt.method_10569("PhysicsMaxDespawnTimer", this.maxLife);
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setDrag(nbt.method_10583("PhysicsDrag"));
        this.setWaterDrag(nbt.method_10583("PhysicsWaterDrag"));
        this.setGravity(nbt.method_10583("PhysicsGravity"));
        this.setBounciness(nbt.method_10583("PhysicsBounce"));
        this.setBuoyancy(nbt.method_10583("PhysicsBuoyancy"));
        this.despawnTimer = nbt.method_10550("PhysicsDespawnTimer");
        this.maxLife = nbt.method_10550("PhysicsMaxDespawnTimer");
    }

    public void moveWithBounce(class_1313 movementType, class_243 movement) {
        if (this.field_5960) {
            this.method_5814(this.method_23317() + movement.field_1352, this.method_23318() + movement.field_1351, this.method_23321() + movement.field_1350);
        } else {
            class_243 vec3d;
            double d;
            this.field_28629 = this.method_5809();
            if (movementType == class_1313.field_6310 && (movement = this.method_18794(movement)).equals((Object)class_243.field_1353)) {
                return;
            }
            this.method_37908().method_16107().method_15396("move");
            if (this.field_17046.method_1027() > 1.0E-7) {
                movement = movement.method_18806(this.field_17046);
                this.field_17046 = class_243.field_1353;
                this.method_18799(class_243.field_1353);
            }
            if ((d = (vec3d = this.adjustMovementForCollisionsCopied(movement = this.method_18796(movement, movementType))).method_1027()) > 1.0E-7) {
                class_3965 blockHitResult;
                if (this.field_6017 != 0.0f && d >= 1.0 && (blockHitResult = this.method_37908().method_17742(new class_3959(this.method_19538(), this.method_19538().method_1019(vec3d), class_3959.class_3960.field_36337, class_3959.class_242.field_36338, (class_1297)this))).method_17783() != class_239.class_240.field_1333) {
                    this.method_38785();
                }
                this.method_5814(this.method_23317() + vec3d.field_1352, this.method_23318() + vec3d.field_1351, this.method_23321() + vec3d.field_1350);
            }
            this.method_37908().method_16107().method_15407();
            this.method_37908().method_16107().method_15396("rest");
            boolean bl = !class_3532.method_20390((double)movement.field_1352, (double)vec3d.field_1352);
            boolean bl2 = !class_3532.method_20390((double)movement.field_1350, (double)vec3d.field_1350);
            this.field_5976 = bl || bl2;
            this.field_5992 = movement.field_1351 != vec3d.field_1351;
            this.field_36331 = this.field_5992 && movement.field_1351 < 0.0;
            this.field_34927 = this.field_5976 ? this.method_39759(vec3d) : false;
            this.method_52208(this.field_36331, vec3d);
            class_2338 blockPos = this.method_43260();
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            this.method_5623(vec3d.field_1351, this.method_24828(), blockState, blockPos);
            if (this.method_31481()) {
                this.method_37908().method_16107().method_15407();
            } else {
                class_1297.class_5799 moveEffect;
                if (this.field_5976) {
                    this.hitWall(bl, bl2);
                }
                class_2248 block = blockState.method_26204();
                if (movement.field_1351 != vec3d.field_1351) {
                    this.hitFloor(block);
                }
                if (this.method_24828()) {
                    block.method_9591(this.method_37908(), blockPos, blockState, (class_1297)this);
                }
                if ((moveEffect = this.method_33570()).method_33576() && !this.method_5765()) {
                    double e = vec3d.field_1352;
                    double f = vec3d.field_1351;
                    double g = vec3d.field_1350;
                    this.field_28627 += (float)(vec3d.method_1033() * 0.6);
                    this.field_5973 += (float)vec3d.method_37267() * 0.6f;
                    this.field_5994 += (float)Math.sqrt(e * e + f * f + g * g) * 0.6f;
                }
                this.method_36974();
                float h = this.method_23326();
                this.method_18799(this.method_18798().method_18805((double)h, 1.0, (double)h));
                if (this.method_37908().method_29556(this.method_5829().method_1011(1.0E-6)).noneMatch(state -> state.method_26164(class_3481.field_21952) || state.method_27852(class_2246.field_10164))) {
                    if (this.method_20802() <= 0) {
                        this.method_20803(-this.method_5676());
                    }
                    if (this.field_28629 && (this.field_27857 || this.method_5637())) {
                        this.method_36975();
                    }
                }
                if (this.method_5809() && (this.field_27857 || this.method_5637())) {
                    this.method_20803(-this.method_5676());
                }
                this.method_37908().method_16107().method_15407();
            }
        }
    }

    protected class_243 adjustMovementForCollisionsCopied(class_243 movement) {
        boolean bl4;
        class_238 box = this.method_5829();
        List list = this.method_37908().method_20743((class_1297)this, box.method_18804(movement));
        class_243 vec3d = movement.method_1027() == 0.0 ? movement : PhysicsProjectile.method_20736((class_1297)this, (class_243)movement, (class_238)box, (class_1937)this.method_37908(), (List)list);
        boolean bl = movement.field_1352 != vec3d.field_1352;
        boolean bl2 = movement.field_1351 != vec3d.field_1351;
        boolean bl3 = movement.field_1350 != vec3d.field_1350;
        boolean bl5 = bl4 = this.method_24828() || bl2 && movement.field_1351 < 0.0;
        if (this.method_49476() > 0.0f && bl4 && (bl || bl3)) {
            class_243 vec3d4;
            class_243 vec3d2 = PhysicsProjectile.method_20736((class_1297)this, (class_243)new class_243(movement.field_1352, (double)this.method_49476(), movement.field_1350), (class_238)box, (class_1937)this.method_37908(), (List)list);
            class_243 vec3d3 = PhysicsProjectile.method_20736((class_1297)this, (class_243)new class_243(0.0, (double)this.method_49476(), 0.0), (class_238)box.method_1012(movement.field_1352, 0.0, movement.field_1350), (class_1937)this.method_37908(), (List)list);
            if (vec3d3.field_1351 < (double)this.method_49476() && (vec3d4 = PhysicsProjectile.method_20736((class_1297)this, (class_243)new class_243(movement.field_1352, 0.0, movement.field_1350), (class_238)box.method_997(vec3d3), (class_1937)this.method_37908(), (List)list).method_1019(vec3d3)).method_37268() > vec3d2.method_37268()) {
                vec3d2 = vec3d4;
            }
            if (vec3d2.method_37268() > vec3d.method_37268()) {
                return vec3d2.method_1019(PhysicsProjectile.method_20736((class_1297)this, (class_243)new class_243(0.0, -vec3d2.field_1351 + movement.field_1351, 0.0), (class_238)box.method_997(vec3d2), (class_1937)this.method_37908(), (List)list));
            }
        }
        return vec3d;
    }
}

