/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.util;

public class ColorHelper {
    public static int blendHexColors(int start, int end, float step) {
        int[] startARGB = ColorHelper.HexToARGB(start);
        int[] endARGB = ColorHelper.HexToARGB(end);
        int cA = ColorHelper.blendARGBValue(startARGB[0], endARGB[0], step);
        int cR = ColorHelper.blendARGBValue(startARGB[1], endARGB[1], step);
        int cG = ColorHelper.blendARGBValue(startARGB[2], endARGB[2], step);
        int cB = ColorHelper.blendARGBValue(startARGB[3], endARGB[3], step);
        return ColorHelper.ARGBToHex(cA, cR, cG, cB);
    }

    public static int blendARGBValue(int start, int end, float step) {
        if (step > 1.0f) {
            step = 1.0f;
        } else if (step < 0.0f) {
            step = 0.0f;
        }
        float iRatio = 1.0f - step;
        return (int)((float)start * iRatio) + (int)((float)end * step);
    }

    public static int[] HexToARGB(int hex) {
        int a = hex >> 24 & 0xFF;
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int ARGBToHex(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }
}

