/*
 * Decompiled with CFR 0.152.
 */
package io.github.fifthtundrag.namereplace;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.fifthtundrag.namereplace.NameReplace;
import io.github.fifthtundrag.namereplace.util.Platform;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_3324;

public class NameReplaceCommand {
    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"namereplace").requires(commandSourceStack -> commandSourceStack.method_9259(NameReplace.config.commandPermissionLevel))).executes(commandContext -> {
            ((class_2168)commandContext.getSource()).method_9226(() -> class_2561.method_43470((String)NameReplace.config.replacements.toString()), false);
            return 1;
        })).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"old_name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"new_name", (ArgumentType)StringArgumentType.string()).executes(commandContext -> NameReplaceCommand.addName((class_2168)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"old_name"), StringArgumentType.getString((CommandContext)commandContext, (String)"new_name"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(commandContext -> NameReplaceCommand.removeName((class_2168)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(class_2170.method_9247((String)"clear").executes(commandContext -> NameReplaceCommand.clearAll((class_2168)commandContext.getSource()))));
    }

    private static int addName(class_2168 commandSourceStack, String oldName, String newName) {
        NameReplace.config.replacements.put(oldName, newName);
        NameReplace.configIO.save(NameReplace.config);
        commandSourceStack.method_9226(() -> class_2561.method_43470((String)String.format("Set name for %s to \"%s\".", oldName, newName)), true);
        NameReplaceCommand.sendPlayerInfoUpdate(commandSourceStack.method_9211().method_3760());
        return 1;
    }

    private static int removeName(class_2168 commandSourceStack, String name) {
        NameReplace.config.replacements.remove(name);
        NameReplace.configIO.save(NameReplace.config);
        commandSourceStack.method_9226(() -> class_2561.method_43470((String)String.format("Removed custom name for %s.", name)), true);
        NameReplaceCommand.sendPlayerInfoUpdate(commandSourceStack.method_9211().method_3760());
        return 1;
    }

    private static int clearAll(class_2168 commandSourceStack) {
        NameReplace.config.replacements.clear();
        NameReplace.configIO.save(NameReplace.config);
        commandSourceStack.method_9226(() -> class_2561.method_43470((String)"Cleared all replaced names."), true);
        NameReplaceCommand.sendPlayerInfoUpdate(commandSourceStack.method_9211().method_3760());
        return 1;
    }

    private static void sendPlayerInfoUpdate(class_3324 playerList) {
        for (class_3222 player : playerList.method_14571()) {
            Platform.INSTANCE.refreshPlayerDisplayName((class_1657)player);
        }
        playerList.method_14581((class_2596)new class_2703(EnumSet.of(class_2703.class_5893.field_29139), (Collection)playerList.method_14571()));
    }
}

