/*
 * Decompiled with CFR 0.152.
 */
package io.github.fifthtundrag.namereplace.config;

import com.google.gson.reflect.TypeToken;
import io.github.fifthtundrag.namereplace.NameReplace;
import io.github.fifthtundrag.namereplace.config.Config;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public record ConfigIO(Path configFilePath) {
    public void save(Config config) {
        try {
            Path parentFolder = this.configFilePath.getParent();
            if (parentFolder != null) {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
            }
        }
        catch (IOException exception) {
            NameReplace.LOGGER.error("Encountered exception while checking if config folder exists: ", (Throwable)exception);
            return;
        }
        try (FileWriter writer = new FileWriter(this.configFilePath.toFile());){
            NameReplace.GSON.toJson((Object)config, (Appendable)writer);
            NameReplace.LOGGER.info("Wrote a new NameReplace config file.");
        }
        catch (IOException exception) {
            NameReplace.LOGGER.error("Encountered exception while writing config file: ", (Throwable)exception);
        }
    }

    public Config load() {
        Config config = new Config();
        if (this.configFilePath.toFile().exists()) {
            try (FileReader reader = new FileReader(this.configFilePath.toFile());){
                Type type = new TypeToken<Config>(this){}.getType();
                config = (Config)NameReplace.GSON.fromJson((Reader)reader, type);
            }
            catch (IOException e) {
                NameReplace.LOGGER.error("Encountered exception while loading config file: ", (Throwable)e);
            }
        }
        return config;
    }
}

