/*
 * Decompiled with CFR 0.152.
 */
package io.github.fifthtundrag.namereplace;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.fifthtundrag.namereplace.NameReplace;
import io.github.fifthtundrag.namereplace.util.Platform;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;

public class NameReplaceCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"namereplace").requires(commandSourceStack -> commandSourceStack.hasPermission(NameReplace.config.commandPermissionLevel))).executes(commandContext -> {
            ((CommandSourceStack)commandContext.getSource()).sendSuccess(() -> Component.literal((String)NameReplace.config.replacements.toString()), false);
            return 1;
        })).then(Commands.literal((String)"add").then(Commands.argument((String)"old_name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"new_name", (ArgumentType)StringArgumentType.string()).executes(commandContext -> NameReplaceCommand.addName((CommandSourceStack)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"old_name"), StringArgumentType.getString((CommandContext)commandContext, (String)"new_name"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(commandContext -> NameReplaceCommand.removeName((CommandSourceStack)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(Commands.literal((String)"clear").executes(commandContext -> NameReplaceCommand.clearAll((CommandSourceStack)commandContext.getSource()))));
    }

    private static int addName(CommandSourceStack commandSourceStack, String oldName, String newName) {
        NameReplace.config.replacements.put(oldName, newName);
        NameReplace.configIO.save(NameReplace.config);
        commandSourceStack.sendSuccess(() -> Component.literal((String)String.format("Set name for %s to \"%s\".", oldName, newName)), true);
        NameReplaceCommand.sendPlayerInfoUpdate(commandSourceStack.getServer().getPlayerList());
        return 1;
    }

    private static int removeName(CommandSourceStack commandSourceStack, String name) {
        NameReplace.config.replacements.remove(name);
        NameReplace.configIO.save(NameReplace.config);
        commandSourceStack.sendSuccess(() -> Component.literal((String)String.format("Removed custom name for %s.", name)), true);
        NameReplaceCommand.sendPlayerInfoUpdate(commandSourceStack.getServer().getPlayerList());
        return 1;
    }

    private static int clearAll(CommandSourceStack commandSourceStack) {
        NameReplace.config.replacements.clear();
        NameReplace.configIO.save(NameReplace.config);
        commandSourceStack.sendSuccess(() -> Component.literal((String)"Cleared all replaced names."), true);
        NameReplaceCommand.sendPlayerInfoUpdate(commandSourceStack.getServer().getPlayerList());
        return 1;
    }

    private static void sendPlayerInfoUpdate(PlayerList playerList) {
        for (ServerPlayer player : playerList.getPlayers()) {
            Platform.INSTANCE.refreshPlayerDisplayName((Player)player);
        }
        playerList.broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME), (Collection)playerList.getPlayers()));
    }
}

