/*
 * Decompiled with CFR 0.152.
 */
package io.github.fifthtundrag.namereplace.mixin;

import io.github.fifthtundrag.namereplace.NameReplace;
import io.github.fifthtundrag.namereplace.mixin.PlayerInvoker;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ClientboundPlayerInfoUpdatePacket.Entry.class})
public class ClientboundPlayerInfoUpdatePacketEntryMixin {
    @Redirect(method={"<init>(Lnet/minecraft/server/level/ServerPlayer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getTabListDisplayName()Lnet/minecraft/network/chat/Component;"))
    private static Component redirectDisplayName(ServerPlayer player) {
        String realPlayerName = player.getGameProfile().getName();
        if (NameReplace.config.replacements.containsKey(realPlayerName)) {
            String newName = NameReplace.config.replacements.get(realPlayerName);
            MutableComponent mutableComponent = PlayerTeam.formatNameForTeam((Team)player.getTeam(), (Component)Component.literal((String)newName));
            return ((PlayerInvoker)player).callDecorateDisplayNameComponent(mutableComponent);
        }
        return player.getTabListDisplayName();
    }
}

