/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import net.foxyas.changedaddon.entity.advanced.AvaliEntity;
import net.foxyas.changedaddon.entity.advanced.LatexSnepEntity;
import net.foxyas.changedaddon.entity.advanced.LuminaraFlowerBeastEntity;
import net.foxyas.changedaddon.entity.defaults.AbstractLuminarcticLeopard;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CustomInteractionInstance
extends AbstractAbilityInstance {
    public CustomInteractionInstance(AbstractAbility<?> ability, IAbstractChangedEntity entity) {
        super(ability, entity);
    }

    public boolean canUse() {
        return true;
    }

    public AbstractAbility.UseType getUseType() {
        return AbstractAbility.UseType.INSTANT;
    }

    public boolean canKeepUsing() {
        return true;
    }

    public void startUsing() {
        ChangedEntity changedEntity = this.entity.getChangedEntity();
        if (changedEntity instanceof LatexSnepEntity) {
            LatexSnepEntity latexSnepEntity = (LatexSnepEntity)changedEntity;
            latexSnepEntity.WantLoaf = !latexSnepEntity.WantLoaf;
        } else {
            changedEntity = this.entity.getChangedEntity();
            if (changedEntity instanceof AbstractLuminarcticLeopard) {
                AbstractLuminarcticLeopard lumi = (AbstractLuminarcticLeopard)changedEntity;
                if (this.entity.isCrouching()) {
                    switch (lumi.getGlowStage()) {
                        case 0: {
                            lumi.setGlowStage(1);
                            break;
                        }
                        case 1: {
                            lumi.setGlowStage(2);
                            break;
                        }
                        case 2: {
                            lumi.setGlowStage(0);
                        }
                    }
                } else {
                    lumi.setActivatedAbility(!lumi.isActivatedAbility());
                }
            } else {
                changedEntity = this.entity.getChangedEntity();
                if (changedEntity instanceof AvaliEntity) {
                    AvaliEntity avaliEntity = (AvaliEntity)changedEntity;
                    float scale = avaliEntity.getDimensionScale();
                    if (scale <= AvaliEntity.SizeScaling.NORMAL.getScale()) {
                        avaliEntity.setDimensionScale(AvaliEntity.SizeScaling.TALL.getScale());
                    } else if (scale < AvaliEntity.SizeScaling.VERY_TALL.getScale() && scale >= AvaliEntity.SizeScaling.TALL.getScale()) {
                        avaliEntity.setDimensionScale(AvaliEntity.SizeScaling.VERY_TALL.getScale());
                    } else {
                        avaliEntity.setDimensionScale(AvaliEntity.SizeScaling.NORMAL.getScale());
                    }
                } else {
                    changedEntity = this.entity.getChangedEntity();
                    if (changedEntity instanceof LuminaraFlowerBeastEntity) {
                        LuminaraFlowerBeastEntity luminaraFlowerBeast = (LuminaraFlowerBeastEntity)changedEntity;
                        if (!luminaraFlowerBeast.isHyperAwakened()) {
                            return;
                        }
                        luminaraFlowerBeast.spawnParticles = !luminaraFlowerBeast.spawnParticles;
                        this.entity.displayClientMessage((Component)new TranslatableComponent("changed_addon.ability.custom_interaction.have_interaction.luminara_beast.action", new Object[]{luminaraFlowerBeast.spawnParticles}), true);
                    }
                }
            }
        }
    }

    public void tick() {
    }

    public void stopUsing() {
    }

    public void onSelected() {
        Component text = this.ability.getSelectedDisplayText(this.entity);
        LivingEntity livingEntity = this.entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (text != null) {
                player.m_5661_(text, true);
            }
        }
    }
}

