/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DashAbility
extends SimpleAbility {
    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.dash");
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> description = new ArrayList<Component>(super.getAbilityDescription(entity));
        description.add((Component)new TranslatableComponent("changed_addon.ability.dash.desc"));
        return description;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        return entity.getEntity().m_20096_();
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        return AbstractAbility.UseType.CHARGE_TIME;
    }

    public int getChargeTime(IAbstractChangedEntity entity) {
        return 2;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return 20;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        super.startUsing(entity);
        LivingEntity livingEntity = entity.getEntity();
        double speed = 1.5;
        Vec3 motion = livingEntity.m_20252_(1.0f).m_82542_(speed, speed * 0.75, speed);
        livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(motion));
        DashAbility.playEffects(livingEntity, motion);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DashAbility.exhaustPlayer(player, 0.5f);
        }
    }

    private static void playEffects(LivingEntity player, Vec3 motion) {
        if (!player.f_19853_.m_5776_()) {
            if (player.m_20096_()) {
                player.f_19853_.m_5594_(null, player.m_142538_(), ChangedSounds.BOW2, player.m_5720_(), 2.5f, 1.0f);
            } else {
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12473_, player.m_5720_(), 2.5f, 0.0f);
            }
            Level level = player.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ParticlesUtil.sendParticles((Level)serverLevel, (ParticleOptions)ParticleTypes.f_123759_, player.m_146892_(), (float)motion.m_7096_(), (float)motion.m_7098_(), (float)motion.m_7094_(), 0, 1.0f);
            }
        }
    }

    private static void exhaustPlayer(Player player, float exhaustion) {
        if (!player.m_7500_()) {
            player.m_36399_(exhaustion);
        }
    }
}

