/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import com.mojang.math.Vector3f;
import net.foxyas.changedaddon.client.model.animations.parameters.DodgeAnimationParameters;
import net.foxyas.changedaddon.init.ChangedAddonAnimationEvents;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.animation.AnimationEvent;
import net.ltxprogrammer.changed.entity.animation.AnimationParameters;
import net.ltxprogrammer.changed.init.ChangedAnimationEvents;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.jetbrains.annotations.Nullable;

public class DodgeAbilityInstance
extends AbstractAbilityInstance {
    private final int defaultRegenCooldown = 20;
    public boolean ultraInstinct = false;
    public DodgeType dodgeType = DodgeType.WEAVE;
    private int dodgeAmount = 4;
    private int maxDodgeAmount = 4;
    private boolean dodgeActive = false;
    private int dodgeRegenCooldown = 20;

    public DodgeAbilityInstance(AbstractAbility<?> ability, IAbstractChangedEntity entity) {
        super(ability, entity);
    }

    public DodgeAbilityInstance(AbstractAbility<?> ability, IAbstractChangedEntity entity, int maxDodge) {
        this(ability, entity);
        this.maxDodgeAmount = maxDodge;
        this.dodgeAmount = maxDodge;
    }

    private void dodgeAwayFromAttacker(Entity dodger, Entity attacker) {
        Vec3 motion = attacker.m_20182_().m_82546_(dodger.m_20182_()).m_82490_(-0.25);
        if (dodger instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)dodger;
            serverPlayer.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(serverPlayer.m_142049_(), serverPlayer.m_20184_()));
        } else {
            dodger.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    private void applyDodgeAwayParticlesTrails(LivingEntity dodger, LivingEntity attacker) {
        Vec3 motion = attacker.m_146892_().m_82546_(dodger.m_146892_()).m_82490_(-0.25);
        Vec3 dodgerPos = dodger.m_20182_().m_82520_(0.0, 0.5, 0.0);
        Level level = dodger.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int steps = 3;
            int lines = 5;
            float spread = 1.0f;
            for (int l = 0; l < lines; ++l) {
                Vec3 lateralOffset = new Vec3((double)dodger.m_21187_().nextFloat(-spread, spread), (double)dodger.m_21187_().nextFloat(-spread, spread), (double)dodger.m_21187_().nextFloat(-spread, spread));
                if (l == 0) {
                    lateralOffset = Vec3.f_82478_;
                }
                for (int s = 0; s <= steps; ++s) {
                    Vec3 particlePos = dodgerPos.m_82549_(lateralOffset);
                    serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 0, motion.f_82479_, motion.f_82480_, motion.f_82481_, 1.0);
                }
            }
        }
    }

    public static boolean isSpectator(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_5833_();
    }

    public DodgeAbilityInstance withDodgeType(DodgeType dodgeType) {
        this.dodgeType = dodgeType;
        return this;
    }

    public boolean isDodgeActive() {
        return this.dodgeActive || this.getController().getHoldTicks() > 0;
    }

    public void setDodgeActivate(boolean active) {
        this.dodgeActive = active;
    }

    public int getDodgeAmount() {
        return this.dodgeAmount;
    }

    public void setDodgeAmount(int amount) {
        this.dodgeAmount = Math.min(amount, this.maxDodgeAmount);
    }

    public void addDodgeAmount() {
        if (this.dodgeAmount < this.maxDodgeAmount) {
            ++this.dodgeAmount;
        }
    }

    public void subDodgeAmount() {
        if (this.dodgeAmount > 0) {
            --this.dodgeAmount;
        }
    }

    public DodgeType getDodgeType() {
        return this.dodgeType;
    }

    public void executeDodgeEffects(LevelAccessor levelAccessor, @Nullable Entity attacker, LivingEntity dodger, @Nullable LivingAttackEvent event, boolean causeExhaustion) {
        if (!this.ultraInstinct) {
            this.subDodgeAmount();
        }
        if (dodger instanceof Player) {
            Player player = (Player)dodger;
            if (!this.ultraInstinct) {
                player.m_5661_((Component)new TranslatableComponent("changed_addon.ability.dodge.dodge_amount_left", new Object[]{Float.valueOf(this.getDodgeStaminaRatio())}), false);
            } else {
                player.m_5661_((Component)new TranslatableComponent("changed_addon.ability.dodge.ultra_instinct"), true);
            }
            if (causeExhaustion && !this.ultraInstinct) {
                player.m_36399_(8.0f);
            }
        }
        if (this.getDodgeType() == DodgeType.WEAVE) {
            dodger.f_19802_ = 60;
            dodger.f_20916_ = dodger.f_20917_ = 60;
            dodger.f_19864_ = false;
        } else if (this.getDodgeType() == DodgeType.TELEPORT) {
            dodger.f_19864_ = false;
        }
        if (event != null) {
            event.setCanceled(true);
        }
        if (this.getDodgeType() == DodgeType.WEAVE) {
            this.executeDodgeParticles(levelAccessor, dodger, attacker);
            this.executeDodgeAnimations(levelAccessor, dodger);
        }
    }

    public void executeDodgeParticles(LevelAccessor levelAccessor, LivingEntity dodger, Entity attacker) {
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            this.applyDodgeAwayParticlesTrails(dodger, attackerLiving);
        }
    }

    public void executeDodgeAnimations(LevelAccessor levelAccessor, LivingEntity dodger) {
        ChangedSounds.broadcastSound((Entity)dodger, (SoundEvent)ChangedSounds.BOW2, (float)2.5f, (float)1.0f);
        if (this.getDodgeType() == DodgeType.WEAVE) {
            int randomValue = levelAccessor.m_5822_().nextInt(6);
            switch (randomValue) {
                case 0: {
                    ChangedAnimationEvents.broadcastEntityAnimation((LivingEntity)dodger, (AnimationEvent)((AnimationEvent)ChangedAddonAnimationEvents.DODGE_LEFT.get()), (AnimationParameters)DodgeAnimationParameters.INSTANCE);
                    break;
                }
                case 1: {
                    ChangedAnimationEvents.broadcastEntityAnimation((LivingEntity)dodger, (AnimationEvent)((AnimationEvent)ChangedAddonAnimationEvents.DODGE_RIGHT.get()), (AnimationParameters)DodgeAnimationParameters.INSTANCE);
                    break;
                }
                case 2: {
                    ChangedAnimationEvents.broadcastEntityAnimation((LivingEntity)dodger, (AnimationEvent)((AnimationEvent)ChangedAddonAnimationEvents.DODGE_WEAVE_LEFT.get()), (AnimationParameters)DodgeAnimationParameters.INSTANCE);
                    break;
                }
                case 3: {
                    ChangedAnimationEvents.broadcastEntityAnimation((LivingEntity)dodger, (AnimationEvent)((AnimationEvent)ChangedAddonAnimationEvents.DODGE_WEAVE_RIGHT.get()), (AnimationParameters)DodgeAnimationParameters.INSTANCE);
                    break;
                }
                case 4: {
                    ChangedAnimationEvents.broadcastEntityAnimation((LivingEntity)dodger, (AnimationEvent)((AnimationEvent)ChangedAddonAnimationEvents.DODGE_DOWN_LEFT.get()), (AnimationParameters)DodgeAnimationParameters.INSTANCE);
                    break;
                }
                case 5: {
                    ChangedAnimationEvents.broadcastEntityAnimation((LivingEntity)dodger, (AnimationEvent)((AnimationEvent)ChangedAddonAnimationEvents.DODGE_DOWN_RIGHT.get()), (AnimationParameters)DodgeAnimationParameters.INSTANCE);
                }
            }
        }
    }

    public void executeDodgeEffects(LevelAccessor levelAccessor, @Nullable Entity attacker, LivingEntity dodger, @Nullable LivingAttackEvent event) {
        this.executeDodgeEffects(levelAccessor, attacker, dodger, event, true);
    }

    public void executeDodgeHandle(LevelAccessor levelAccessor, Entity attacker, LivingEntity dodger, LivingAttackEvent event, boolean causeExhaustion) {
        Vec3 attackerPos = attacker.m_20182_();
        Vec3 lookDirection = attacker.m_20154_().m_82541_();
        double distanceBehind = 3.0;
        Vec3 dodgePosBehind = attackerPos.m_82546_(lookDirection.m_82490_(3.0));
        double distance = attacker.m_20270_((Entity)dodger);
        if (this.ultraInstinct) {
            this.dodgeAwayFromAttacker((Entity)dodger, attacker);
            if (event != null) {
                event.setCanceled(true);
            }
            return;
        }
        if (this.getDodgeType() == DodgeType.TELEPORT) {
            if (event != null) {
                event.setCanceled(true);
            }
            if (distance > 2.0) {
                double maxDistance = 16.0;
                double dx = (dodger.m_21187_().nextDouble() - 0.5) * 2.0 * maxDistance;
                double dz = (dodger.m_21187_().nextDouble() - 0.5) * 2.0 * maxDistance;
                double dy = dodger.m_21187_().nextInt(16) - 8;
                BlockPos targetPos = new BlockPos(dodger.m_20185_() + dx, dodger.m_20186_() + dy, dodger.m_20189_() + dz);
                if (dodger.m_20984_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), true)) {
                    levelAccessor.m_5594_(null, dodger.m_142538_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (levelAccessor instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)levelAccessor;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, dodger.m_20185_(), dodger.m_20186_() + 0.5, dodger.m_20189_(), 20, 0.5, 1.0, 0.5, 0.1);
                    }
                }
            } else if (dodger.m_20984_(dodgePosBehind.f_82479_, dodgePosBehind.f_82480_, dodgePosBehind.f_82481_, true)) {
                levelAccessor.m_5594_(null, dodger.m_142538_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (levelAccessor instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)levelAccessor;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, dodger.m_20185_(), dodger.m_20186_() + 0.5, dodger.m_20189_(), 20, 0.5, 1.0, 0.5, 0.1);
                }
            }
        } else {
            this.dodgeAwayFromAttacker((Entity)dodger, attacker);
            if (event != null) {
                event.setCanceled(true);
            }
        }
    }

    public void executeDodgeHandle(LivingEntity dodger, Entity attacker) {
        this.executeDodgeHandle((LevelAccessor)dodger.m_183503_(), attacker, dodger, null, true);
    }

    public void executeDodgeEffects(LivingEntity dodger, Entity attacker) {
        this.executeDodgeEffects((LevelAccessor)dodger.m_183503_(), attacker, dodger, null);
    }

    private void spawnDodgeParticles(ServerLevel level, Entity entity, float middle, float xV, float yV, float zV, int count, float speed) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20185_(), entity.m_20186_() + (double)middle, entity.m_20189_(), count, (double)xV, (double)yV, (double)zV, (double)speed);
    }

    public int getMaxDodgeAmount() {
        return this.maxDodgeAmount;
    }

    public void setMaxDodgeAmount(int max) {
        this.maxDodgeAmount = max;
        this.dodgeAmount = Math.min(this.dodgeAmount, max);
    }

    public float getDodgeStaminaRatio() {
        return (float)this.dodgeAmount / (float)this.maxDodgeAmount * 100.0f;
    }

    public void setUltraInstinct(boolean ultraInstinct) {
        LivingEntity livingEntity;
        if (ultraInstinct && (livingEntity = this.entity.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_5661_((Component)new TranslatableComponent("changed_addon.ability.dodge.ultra_instinct.activated"), false);
        }
        this.ultraInstinct = ultraInstinct;
    }

    public boolean canUse() {
        if (this.ultraInstinct) {
            return true;
        }
        return this.dodgeAmount > 0 && !DodgeAbilityInstance.isSpectator((Entity)this.entity.getEntity());
    }

    public boolean canKeepUsing() {
        if (this.ultraInstinct) {
            return true;
        }
        return this.dodgeAmount > 0 && !DodgeAbilityInstance.isSpectator((Entity)this.entity.getEntity());
    }

    public void startUsing() {
        LivingEntity livingEntity = this.entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.getController().getHoldTicks() == 0 && !player.m_183503_().m_5776_() && !this.ultraInstinct) {
                player.m_5661_((Component)new TranslatableComponent("changed_addon.ability.dodge.dodge_amount", new Object[]{Float.valueOf(this.getDodgeStaminaRatio())}), true);
            }
        }
    }

    public void tick() {
        Player player;
        LivingEntity livingEntity = this.entity.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_183503_().m_5776_() && !this.ultraInstinct) {
            player.m_5661_((Component)new TranslatableComponent("changed_addon.ability.dodge.dodge_amount", new Object[]{Float.valueOf(this.getDodgeStaminaRatio())}), true);
        }
        this.setDodgeActivate(this.canUse());
    }

    public void stopUsing() {
        this.setDodgeActivate(false);
    }

    public void tickIdle() {
        boolean nonHurtFrame;
        super.tickIdle();
        if (this.ultraInstinct) {
            this.setDodgeActivate(true);
        }
        boolean bl = nonHurtFrame = this.entity.getEntity().f_20916_ <= 10 && this.entity.getEntity().f_19802_ <= 10;
        if (nonHurtFrame && !this.isDodgeActive() && this.dodgeAmount < this.maxDodgeAmount) {
            if (this.dodgeRegenCooldown <= 0) {
                Player player;
                this.addDodgeAmount();
                this.dodgeRegenCooldown = 5;
                LivingEntity livingEntity = this.entity.getEntity();
                if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_183503_().m_5776_()) {
                    if (!this.ultraInstinct) {
                        player.m_5661_((Component)new TranslatableComponent("changed_addon.ability.dodge.dodge_amount", new Object[]{Float.valueOf(this.getDodgeStaminaRatio())}), true);
                    } else {
                        player.m_5661_((Component)new TranslatableComponent("changed_addon.ability.dodge.ultra_instinct"), true);
                    }
                }
            } else {
                --this.dodgeRegenCooldown;
            }
        }
    }

    public void readData(CompoundTag tag) {
        super.readData(tag);
        if (tag.m_128441_("DodgeAmount")) {
            this.dodgeAmount = tag.m_128451_("DodgeAmount");
        }
        if (tag.m_128441_("MaxDodgeAmount")) {
            this.maxDodgeAmount = tag.m_128451_("MaxDodgeAmount");
        }
        if (tag.m_128441_("DodgeRegenCooldown")) {
            this.dodgeRegenCooldown = tag.m_128451_("DodgeRegenCooldown");
        }
        if (tag.m_128441_("DodgeActivate")) {
            this.dodgeActive = tag.m_128471_("DodgeActivate");
        }
        if (tag.m_128441_("ultraInstinct")) {
            this.ultraInstinct = tag.m_128471_("ultraInstinct");
        }
    }

    public void saveData(CompoundTag tag) {
        super.saveData(tag);
        tag.m_128405_("DodgeAmount", this.dodgeAmount);
        tag.m_128405_("MaxDodgeAmount", this.maxDodgeAmount);
        tag.m_128405_("DodgeRegenCooldown", this.dodgeRegenCooldown);
        tag.m_128379_("DodgeActivate", this.dodgeActive);
        tag.m_128379_("ultraInstinct", this.ultraInstinct);
    }

    public static enum DodgeType {
        TELEPORT,
        WEAVE;

    }
}

