/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ThunderPathAbility
extends AbstractAbility<Instance> {
    public ThunderPathAbility() {
        super(Instance::new);
    }

    public static boolean Spectator(Entity entity) {
        if (entity instanceof Player) {
            Player player1 = (Player)entity;
            return player1.m_5833_();
        }
        return true;
    }

    private static boolean isHandEmpty(Entity entity, InteractionHand hand) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21120_(hand).m_41720_() == Blocks.f_50016_.m_5456_();
    }

    private static InteractionHand getSwingHand(Entity entity) {
        return ThunderPathAbility.isHandEmpty(entity, InteractionHand.MAIN_HAND) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.thunder_path");
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        return new ResourceLocation("changed_addon:textures/screens/thunderbolt.png");
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        return AbstractAbility.UseType.HOLD;
    }

    public int getChargeTime(IAbstractChangedEntity entity) {
        TransfurVariant Variant = entity.getChangedEntity().getSelfVariant();
        if (Variant == ChangedAddonTransfurVariants.EXPERIMENT_009_BOSS.get()) {
            return 15;
        }
        return 20;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        TransfurVariant Variant = entity.getChangedEntity().getSelfVariant();
        if (Variant == ChangedAddonTransfurVariants.EXPERIMENT_009_BOSS.get()) {
            return 30;
        }
        return 45;
    }

    public float ReachAmount(IAbstractChangedEntity entity) {
        TransfurVariant Variant = entity.getChangedEntity().getSelfVariant();
        if (Variant == ChangedAddonTransfurVariants.EXPERIMENT_009_BOSS.get()) {
            return 8.0f;
        }
        return 5.0f;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        super.startUsing(entity);
    }

    public static class Instance
    extends AbstractAbilityInstance {
        private final IAbstractChangedEntity owner;
        public int MaxThunderIndex = 10;
        public Vec3 startPos = Vec3.f_82478_;
        private int thunderIndex = 1;

        public Instance(AbstractAbility<?> ability, IAbstractChangedEntity entity) {
            super(ability, entity);
            this.owner = entity;
        }

        public static boolean Spectator(Entity entity) {
            if (entity instanceof Player) {
                Player player1 = (Player)entity;
                return player1.m_5833_();
            }
            return true;
        }

        public void saveData(CompoundTag tag) {
            super.saveData(tag);
            tag.m_128405_("MaxThunderReach", this.MaxThunderIndex);
            tag.m_128405_("ThunderPhase", this.thunderIndex);
        }

        public void readData(CompoundTag tag) {
            super.readData(tag);
            if (tag.m_128441_("ThunderPhase")) {
                this.thunderIndex = tag.m_128451_("ThunderPhase");
            }
            if (tag.m_128441_("MaxThunderReach")) {
                this.MaxThunderIndex = tag.m_128451_("MaxThunderReach");
            }
        }

        public boolean canUse() {
            this.MaxThunderIndex = (int)this.ReachAmount(this.entity);
            Player player = (Player)this.entity.getEntity();
            TransfurVariant Variant = this.entity.getChangedEntity().getSelfVariant();
            return player.m_36324_().m_38702_() >= 10 && (Variant == ChangedAddonTransfurVariants.EXPERIMENT_009.get() || Variant == ChangedAddonTransfurVariants.EXPERIMENT_009_BOSS.get()) && !Instance.Spectator((Entity)this.entity.getEntity());
        }

        public AbstractAbility.UseType getUseType() {
            return AbstractAbility.UseType.HOLD;
        }

        public float ReachAmount(IAbstractChangedEntity entity) {
            TransfurVariant Variant = entity.getChangedEntity().getSelfVariant();
            if (Variant == ChangedAddonTransfurVariants.EXPERIMENT_009_BOSS.get()) {
                return 15.0f;
            }
            return 10.0f;
        }

        public int MaxAmount(IAbstractChangedEntity entity) {
            TransfurVariant Variant = entity.getChangedEntity().getSelfVariant();
            if (Variant == ChangedAddonTransfurVariants.EXPERIMENT_009_BOSS.get()) {
                return 8;
            }
            return 5;
        }

        public boolean canKeepUsing() {
            return this.thunderIndex < this.MaxThunderIndex;
        }

        public void startUsing() {
            this.startPos = this.owner.getEntity().m_20182_();
        }

        public void tick() {
            LivingEntity livingEntity;
            block7: {
                block6: {
                    livingEntity = this.owner.getEntity();
                    if (!(livingEntity instanceof Player)) break block6;
                    Player player = (Player)livingEntity;
                    livingEntity = this.owner.getLevel();
                    if (livingEntity instanceof ServerLevel) break block7;
                }
                return;
            }
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            Instance abilityInstance = this;
            int ticks = abilityInstance.getController().getHoldTicks();
            Vec3 forward = this.owner.getEntity().m_20154_().m_82490_((double)this.ReachAmount(this.owner));
            Vec3 forwardCap = this.owner.getEntity().m_20154_().m_82490_(2.0);
            if (ticks % 4 == 0 && this.thunderIndex < this.MaxThunderIndex) {
                Vec3 currentPos = this.startPos.m_82549_(forwardCap).m_82549_(forward.m_82490_((double)this.thunderIndex / (double)this.MaxThunderIndex));
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
                if (bolt != null) {
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)new BlockPos(currentPos)));
                    bolt.m_20874_(false);
                    serverLevel.m_7967_((Entity)bolt);
                }
                ++this.thunderIndex;
            }
            if (this.thunderIndex >= this.MaxThunderIndex) {
                this.thunderIndex = 0;
                abilityInstance.getController().deactivateAbility();
                abilityInstance.getController().applyCoolDown();
            }
        }

        public void stopUsing() {
            if (this.thunderIndex > 0) {
                this.thunderIndex = 0;
                this.getController().applyCoolDown();
            }
        }

        public void tickIdle() {
            super.tickIdle();
            if (this.getController().isCoolingDown()) {
                this.thunderIndex = 0;
            }
        }
    }
}

