/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.Random;
import net.foxyas.changedaddon.init.ChangedAddonAbilities;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedRegistry;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TurnFeralSnepAbilityInstance
extends AbstractAbilityInstance {
    private static final String OLD_TRANSFUR_VARIANT = "OldVariant";
    public TransfurVariant<?> OldVariant = null;

    public TurnFeralSnepAbilityInstance(AbstractAbility<?> ability, IAbstractChangedEntity entity) {
        super(ability, entity);
    }

    public static String getOldTransfurVariant() {
        return OLD_TRANSFUR_VARIANT;
    }

    public boolean canUse() {
        return true;
    }

    public boolean canKeepUsing() {
        return true;
    }

    public void onSelected() {
        super.onSelected();
        LivingEntity livingEntity = this.entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            TransfurVariantInstance Instance2 = ProcessTransfur.getPlayerTransfurVariant((Player)player);
            if (this.OldVariant == null && Instance2 != null) {
                if (Instance2.getParent() != ChangedAddonTransfurVariants.LATEX_SNEP_FERAL_FORM.get() && Instance2.getParent() != ChangedAddonTransfurVariants.LATEX_SNEP.get()) {
                    this.setOldVariant(this.entity.getSelfVariant());
                }
            } else if (Instance2 != null) {
                Component text = this.ability.getSelectedDisplayText(this.entity);
                if (Instance2.getParent() == ChangedAddonTransfurVariants.LATEX_SNEP_FERAL_FORM.get() && text != null) {
                    player.m_5661_(text, true);
                }
            }
        }
    }

    public void saveData(CompoundTag tag) {
        super.saveData(tag);
        if (this.OldVariant != null && this.OldVariant.getRegistryName() != null) {
            tag.m_128359_(OLD_TRANSFUR_VARIANT, this.OldVariant.getRegistryName().toString());
        }
    }

    public void readData(CompoundTag tag) {
        super.readData(tag);
        if (tag.m_128441_(OLD_TRANSFUR_VARIANT)) {
            ResourceLocation form;
            try {
                form = new ResourceLocation(tag.m_128461_(OLD_TRANSFUR_VARIANT));
            }
            catch (Exception e) {
                form = new ResourceLocation("");
            }
            if (TransfurVariant.getPublicTransfurVariants().map(ForgeRegistryEntry::getRegistryName).anyMatch(arg_0 -> ((ResourceLocation)form).equals(arg_0))) {
                this.OldVariant = (TransfurVariant)ChangedRegistry.TRANSFUR_VARIANT.get().getValue(form);
            }
        }
    }

    public void setOldVariant(TransfurVariant<?> oldVariant) {
        this.OldVariant = oldVariant;
    }

    public void startUsing() {
        TransfurVariant<?> targetVariant;
        Player player;
        TransfurVariantInstance variantInstance;
        LivingEntity livingEntity = this.entity.getEntity();
        if (livingEntity instanceof Player && (variantInstance = ProcessTransfur.setPlayerTransfurVariant((Player)(player = (Player)livingEntity), targetVariant = this.determineNextVariant(this.entity.getTransfurVariant()), (TransfurContext)TransfurContext.hazard((TransfurCause)TransfurCause.GRAB_REPLICATE), (float)1.0f)) != null) {
            variantInstance.ifHasAbility((AbstractAbility)ChangedAddonAbilities.TURN_FERAL_SNEP.get(), abilityInstance -> abilityInstance.setOldVariant(this.entity.getTransfurVariant()));
            this.entity.getEntity().m_183503_().m_6269_(null, (Entity)this.entity.getEntity(), ChangedSounds.POISON, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private TransfurVariant<?> determineNextVariant(TransfurVariant<?> currentVariant) {
        if (currentVariant == ChangedAddonTransfurVariants.LATEX_SNEP_FERAL_FORM.get() || currentVariant == ChangedAddonTransfurVariants.LATEX_SNEP.get()) {
            return this.OldVariant != null ? this.OldVariant : ChangedAddonTransfurVariants.Gendered.ORGANIC_SNOW_LEOPARD.getRandomVariant(new Random());
        }
        return (TransfurVariant)ChangedAddonTransfurVariants.LATEX_SNEP_FERAL_FORM.get();
    }

    public void tick() {
    }

    public void stopUsing() {
    }
}

