/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

public class PatEntityTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = ChangedAddonMod.resourceLoc("pat_entity_trigger");

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject jsonObject, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityPredicate.Composite p_66249_, @NotNull DeserializationContext p_66250_) {
        String name;
        ItemPredicate headSlot = jsonObject.has("head") ? ItemPredicate.m_45051_((JsonElement)jsonObject.get("head")) : ItemPredicate.f_45028_;
        ItemPredicate chestSlot = jsonObject.has("chest") ? ItemPredicate.m_45051_((JsonElement)jsonObject.get("chest")) : ItemPredicate.f_45028_;
        ItemPredicate legsSlot = jsonObject.has("legs") ? ItemPredicate.m_45051_((JsonElement)jsonObject.get("legs")) : ItemPredicate.f_45028_;
        ItemPredicate feetSlot = jsonObject.has("feets") ? ItemPredicate.m_45051_((JsonElement)jsonObject.get("feets")) : ItemPredicate.f_45028_;
        EntityTypePredicate entityType = jsonObject.has("entity_type") ? EntityTypePredicate.m_37643_((JsonElement)jsonObject.get("entity_type")) : EntityTypePredicate.f_37636_;
        JsonElement elem = jsonObject.get("name");
        String string = name = elem != null && elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isString() ? elem.getAsString() : "";
        if (!name.isEmpty()) {
            return new TriggerInstance(p_66249_, name, headSlot, chestSlot, legsSlot, feetSlot, entityType);
        }
        return new TriggerInstance(p_66249_, headSlot, chestSlot, legsSlot, feetSlot, entityType);
    }

    public void Trigger(ServerPlayer player, Entity toPatTarget) {
        this.m_66234_(player, instance -> instance.matches(player, toPatTarget));
    }

    public void Trigger(ServerPlayer player, Entity toPatTarget, String name) {
        this.m_66234_(player, instance -> instance.matches(player, toPatTarget, name));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate headSlot;
        private final ItemPredicate chestSlot;
        private final ItemPredicate legsSlot;
        private final ItemPredicate feetSlot;
        private final EntityTypePredicate entityType;
        private final String name;

        public TriggerInstance(EntityPredicate.Composite playerPredicate, String name, ItemPredicate headSlot, ItemPredicate chestSlot, ItemPredicate legsSlot, ItemPredicate feetSlot, EntityTypePredicate entityType) {
            super(ID, playerPredicate);
            this.name = name;
            this.headSlot = headSlot;
            this.chestSlot = chestSlot;
            this.legsSlot = legsSlot;
            this.feetSlot = feetSlot;
            this.entityType = entityType;
        }

        public TriggerInstance(EntityPredicate.Composite playerPredicate, ItemPredicate headSlot, ItemPredicate chestSlot, ItemPredicate legsSlot, ItemPredicate feetSlot, EntityTypePredicate entityType) {
            super(ID, playerPredicate);
            this.name = null;
            this.headSlot = headSlot;
            this.chestSlot = chestSlot;
            this.legsSlot = legsSlot;
            this.feetSlot = feetSlot;
            this.entityType = entityType;
        }

        public boolean matches(ServerPlayer player, Entity toPatTarget) {
            boolean wearingCorrectArmor;
            boolean bl = wearingCorrectArmor = this.headSlot.m_45049_(player.m_6844_(EquipmentSlot.HEAD)) && this.chestSlot.m_45049_(player.m_6844_(EquipmentSlot.CHEST)) && this.legsSlot.m_45049_(player.m_6844_(EquipmentSlot.LEGS)) && this.feetSlot.m_45049_(player.m_6844_(EquipmentSlot.FEET));
            if (toPatTarget == null) {
                return wearingCorrectArmor && this.name == null;
            }
            boolean correctEntityType = this.entityType.m_7484_(toPatTarget.m_6095_());
            return wearingCorrectArmor && correctEntityType && this.name == null;
        }

        public boolean matches(ServerPlayer player, Entity toPatTarget, String name) {
            boolean wearingCorrectArmor;
            boolean bl = wearingCorrectArmor = this.headSlot.m_45049_(player.m_6844_(EquipmentSlot.HEAD)) && this.chestSlot.m_45049_(player.m_6844_(EquipmentSlot.CHEST)) && this.legsSlot.m_45049_(player.m_6844_(EquipmentSlot.LEGS)) && this.feetSlot.m_45049_(player.m_6844_(EquipmentSlot.FEET));
            if (toPatTarget == null) {
                return name.equals(this.name) && wearingCorrectArmor;
            }
            boolean correctEntityType = this.entityType.m_7484_(toPatTarget.m_6095_());
            return name.equals(this.name) && wearingCorrectArmor && correctEntityType;
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            if (this.headSlot != null) {
                jsonObject.add("head", this.headSlot.m_45048_());
            }
            if (this.chestSlot != null) {
                jsonObject.add("chest", this.chestSlot.m_45048_());
            }
            if (this.legsSlot != null) {
                jsonObject.add("legs", this.legsSlot.m_45048_());
            }
            if (this.feetSlot != null) {
                jsonObject.add("feets", this.feetSlot.m_45048_());
            }
            if (this.entityType != null) {
                jsonObject.add("entity_type", this.entityType.m_5908_());
            }
            if (this.name != null && !this.name.isEmpty()) {
                jsonObject.addProperty("name", this.name);
            }
            return jsonObject;
        }
    }
}

