/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.foxyas.changedaddon.entity.defaults.AbstractLuminarcticLeopard;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.block.AbstractLatexIceBlock;
import net.ltxprogrammer.changed.block.TransfurCrystalBlock;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedMaterials;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractLuminarCrystal {
    public static void spawnParticleOnFace(ServerLevel level, BlockPos pos, Direction direction, int count, float particleSpeed) {
        SimpleParticleType p_144961_ = ParticleTypes.f_123810_;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        int i = direction.m_122429_();
        int j = direction.m_122430_();
        int k = direction.m_122431_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)i * 0.55);
        double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)j * 0.55);
        double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)k * 0.55);
        double d3 = i == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        double d4 = j == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        double d5 = k == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        ParticlesUtil.sendParticles((Level)level, (ParticleOptions)p_144961_, d0, d1, d2, 0.05, 0.05, 0.05, count, particleSpeed);
    }

    public static void spawnEndRodParticleOnFace(ServerLevel level, BlockPos pos, Direction direction, int count, float particleSpeed) {
        SimpleParticleType p_144961_ = ParticleTypes.f_123810_;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        int i = direction.m_122429_();
        int j = direction.m_122430_();
        int k = direction.m_122431_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)i * 0.55);
        double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)j * 0.55);
        double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)k * 0.55);
        double d3 = i == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        double d4 = j == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        double d5 = k == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        ParticlesUtil.sendParticles((Level)level, (ParticleOptions)p_144961_, d0, d1, d2, d3, d4, d5, count, particleSpeed);
    }

    public static void spawnSnowParticleOnFace(ServerLevel level, BlockPos pos, Direction direction, int count, float particleSpeed) {
        SimpleParticleType p_144961_ = ParticleTypes.f_175821_;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        int i = direction.m_122429_();
        int j = direction.m_122430_();
        int k = direction.m_122431_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)i * 0.55);
        double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)j * 0.55);
        double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-0.5, (double)0.5) : (double)k * 0.55);
        double d3 = i == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        double d4 = j == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        double d5 = k == 0 ? Mth.m_14064_((Random)level.f_46441_, (double)-1.0, (double)1.0) : 0.0;
        ParticlesUtil.sendParticles((Level)level, (ParticleOptions)p_144961_, d0, d1, d2, 0.2, 0.2, 0.2, count, particleSpeed);
    }

    public static abstract class CrystalSmall
    extends TransfurCrystalBlock
    implements SimpleWaterloggedBlock {
        public static final BooleanProperty HEARTED = BooleanProperty.m_61465_((String)"hearted");
        public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
        protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0);
        protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0);
        protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        protected static final VoxelShape WEST_AABB = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
        protected static final VoxelShape UP_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        protected static final VoxelShape DOWN_AABB = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

        public CrystalSmall() {
            super(ChangedAddonItems.LUMINAR_CRYSTAL_SHARD, BlockBehaviour.Properties.m_60939_((Material)ChangedMaterials.LATEX_CRYSTAL).m_60918_(SoundType.f_154655_).m_60955_().m_60988_().m_60977_().m_60913_(1.7f, 2.5f).m_60982_((blockState, blockGetter, blockPos) -> true).m_60991_((blockState, blockGetter, blockPos) -> true).m_60955_());
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HEARTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @NotNull
        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH -> NORTH_AABB;
                case Direction.SOUTH -> SOUTH_AABB;
                case Direction.EAST -> EAST_AABB;
                case Direction.WEST -> WEST_AABB;
                case Direction.UP -> UP_AABB;
                case Direction.DOWN -> DOWN_AABB;
            };
        }

        @NotNull
        public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            return Shapes.m_83040_();
        }

        public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
            return 0;
        }

        public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
            return 4;
        }

        public boolean m_5946_(@NotNull BlockState thisState, @NotNull Fluid fluid) {
            if (fluid instanceof LavaFluid || fluid instanceof WaterFluid) {
                return (Boolean)thisState.m_61143_((Property)HEARTED) == false;
            }
            return super.m_5946_(thisState, fluid);
        }

        protected void m_7926_(StateDefinition.Builder<net.minecraft.world.level.block.Block, BlockState> builder) {
            builder.m_61104_(new Property[]{HEARTED});
            builder.m_61104_(new Property[]{FACING});
            builder.m_61104_(new Property[]{WATERLOGGED});
        }

        @NotNull
        public FluidState m_5888_(BlockState state) {
            return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
        }

        public void m_7455_(@NotNull BlockState thisState, @NotNull ServerLevel serverLevel, @NotNull BlockPos pos, @NotNull Random random) {
            super.m_7455_(thisState, serverLevel, pos, random);
            if (random.nextFloat() >= 0.99f) {
                for (Direction direction : Direction.values()) {
                    AbstractLuminarCrystal.spawnParticleOnFace(serverLevel, pos, direction, 2, 0.01f);
                }
            }
        }

        @NotNull
        public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
            }
            return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
        }

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            if (!(entity instanceof AbstractLuminarcticLeopard)) {
                super.m_7892_(state, level, pos, entity);
                if (entity instanceof LivingEntity) {
                    Stream<TransfurVariant> variantStream;
                    Player player;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    MobEffectInstance EffectInstance = new MobEffectInstance(MobEffects.f_19615_, 400, 1, false, true, true);
                    if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
                        return;
                    }
                    if (!livingEntity.m_7301_(EffectInstance) || livingEntity instanceof AbstractLuminarcticLeopard) {
                        return;
                    }
                    if (livingEntity instanceof Player && ProcessTransfur.getPlayerTransfurVariant((Player)(player = (Player)livingEntity)) != null && (variantStream = Stream.of((TransfurVariant)ChangedAddonTransfurVariants.LUMINARCTIC_LEOPARD_MALE.get(), (TransfurVariant)ChangedAddonTransfurVariants.LUMINARCTIC_LEOPARD_FEMALE.get())).anyMatch(variant -> variant.is(ProcessTransfur.getPlayerTransfurVariant((Player)player).getParent()))) {
                        return;
                    }
                    if (!livingEntity.m_21023_(MobEffects.f_19615_)) {
                        livingEntity.m_7292_(EffectInstance);
                    }
                    livingEntity.m_146917_(livingEntity.m_146888_() + 5);
                }
            }
        }

        public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
            return true;
        }

        @NotNull
        public VoxelShape m_5909_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            return Shapes.m_83040_();
        }

        @NotNull
        public List<ItemStack> m_7381_(BlockState blockState, LootContext.Builder lootBuilder) {
            ResourceLocation resourcelocation = this.m_60589_();
            if (resourcelocation == BuiltInLootTables.f_78712_) {
                return Collections.emptyList();
            }
            LootContext lootcontext = lootBuilder.m_78972_(LootContextParams.f_81461_, (Object)blockState).m_78975_(LootContextParamSets.f_81421_);
            ServerLevel serverlevel = lootcontext.m_78952_();
            LootTable loottable = serverlevel.m_142572_().m_129898_().m_79217_(resourcelocation);
            return loottable.m_79129_(lootcontext);
        }

        protected boolean m_6266_(BlockState blockState, BlockGetter level, BlockPos blockPos) {
            return blockState.m_60734_() == ChangedAddonBlocks.LUMINAR_CRYSTAL_BLOCK.get();
        }

        @Nullable
        public BlockState m_5573_(BlockPlaceContext p_152019_) {
            Level levelaccessor = p_152019_.m_43725_();
            BlockPos blockpos = p_152019_.m_8083_();
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)p_152019_.m_43719_());
        }

        public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
            Direction oppositeDirection = ((Direction)blockState.m_61143_((Property)FACING)).m_122424_();
            BlockState blockStateOn = level.m_8055_(blockPos.m_142300_(oppositeDirection));
            if (!CrystalSmall.m_49936_((BlockGetter)level, (BlockPos)blockPos.m_142300_(oppositeDirection))) {
                return false;
            }
            return blockStateOn.m_60734_() == ChangedAddonBlocks.LUMINAR_CRYSTAL_BLOCK.get();
        }

        @Nullable
        public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
            if (entity instanceof AbstractLuminarcticLeopard) {
                AbstractLuminarcticLeopard abstractLuminarcticLeopard = (AbstractLuminarcticLeopard)entity;
                return BlockPathTypes.WALKABLE;
            }
            return BlockPathTypes.DANGER_OTHER;
        }

        @NotNull
        public BlockState m_6843_(BlockState state, Rotation rot) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
        }

        @NotNull
        public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
            return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
        }

        public void m_7100_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Random random) {
            super.m_7100_(state, level, pos, random);
        }

        @NotNull
        public PushReaction m_5537_(@NotNull BlockState p_60584_) {
            return super.m_5537_(p_60584_);
        }

        public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }

        public void m_6786_(@NotNull LevelAccessor p_49860_, @NotNull BlockPos p_49861_, @NotNull BlockState p_49862_) {
            super.m_6786_(p_49860_, p_49861_, p_49862_);
        }

        public void m_6810_(@NotNull BlockState oldState, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
            if (!level.f_46443_ && !oldState.m_60713_(newState.m_60734_())) {
                ServerLevel serverLevel;
                ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
                if (serverLevel == null) {
                    return;
                }
                LivingEntity closestEntity = level.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(8.0)).stream().filter(entity -> {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        return !player.m_5833_() && !player.m_7500_();
                    }
                    return !(entity instanceof AbstractLuminarcticLeopard);
                }).min(Comparator.comparingDouble(entity -> entity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))).orElse(null);
                List nearbyLeopards = level.m_45976_(AbstractLuminarcticLeopard.class, new AABB(pos).m_82400_(10.0));
                if (!nearbyLeopards.isEmpty()) {
                    if (closestEntity != null) {
                        for (AbstractLuminarcticLeopard leopard : nearbyLeopards) {
                            if (!leopard.m_6779_(closestEntity) || !leopard.m_142582_((Entity)closestEntity)) continue;
                            leopard.m_6710_(closestEntity);
                            level.m_5594_(null, pos, SoundEvents.f_11850_, SoundSource.MASTER, 1.0f, 0.0f);
                        }
                    }
                } else {
                    EntityType leopardType = level.f_46441_.nextBoolean() ? (EntityType)ChangedAddonEntities.LUMINARCTIC_LEOPARD_FEMALE.get() : (EntityType)ChangedAddonEntities.LUMINARCTIC_LEOPARD_MALE.get();
                    AbstractLuminarcticLeopard newLeopard = (AbstractLuminarcticLeopard)leopardType.m_20615_((Level)serverLevel);
                    if (newLeopard != null) {
                        if (((Boolean)oldState.m_61143_((Property)HEARTED)).booleanValue()) {
                            newLeopard.setBoss(true);
                        }
                        BlockPos spawnPos = pos;
                        Vec3 spawnVec = new Vec3((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                        newLeopard.m_6034_(spawnVec.f_82479_, spawnVec.f_82480_, spawnVec.f_82481_);
                        newLeopard.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
                        if (closestEntity != null) {
                            newLeopard.m_6710_(closestEntity);
                            Vec3 targetPos = closestEntity.m_20182_().m_82549_(closestEntity.m_20252_(1.0f).m_82490_(-1.5));
                            spawnPos = new BlockPos(targetPos);
                            if (level.m_8055_(spawnPos).m_60795_() && level.m_8055_(spawnPos.m_7494_()).m_60795_()) {
                                spawnPos = new BlockPos(spawnPos.m_123341_(), level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnPos.m_123341_(), spawnPos.m_123343_()), spawnPos.m_123343_());
                                newLeopard.m_6034_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                                level.m_7967_((Entity)newLeopard);
                            }
                        }
                        level.m_7967_((Entity)newLeopard);
                        newLeopard.m_5496_(SoundEvents.f_11850_, 1.0f, 0.0f);
                    }
                }
            }
            super.m_6810_(oldState, level, pos, newState, isMoving);
        }
    }

    public static abstract class Block
    extends AbstractLatexIceBlock {
        public static final int MAX_AGE = 3;
        public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
        public static final BooleanProperty DEFROST = BooleanProperty.m_61465_((String)"defrost");
        private static final int NEIGHBORS_TO_AGE = 4;
        private static final int NEIGHBORS_TO_MELT = 2;

        public Block() {
            super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76316_, (MaterialColor)MaterialColor.f_76406_).m_60911_(0.98f).m_60918_(SoundType.f_154654_).m_60913_(2.0f, 8.0f).m_60982_((blockState, blockGetter, blockPos) -> true).m_60991_((blockState, blockGetter, blockPos) -> true).m_60955_().m_60977_());
            this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)DEFROST, (Comparable)Boolean.valueOf(false)));
        }

        public boolean m_6104_(@NotNull BlockState blockState, BlockState blockState1, @NotNull Direction direction) {
            return blockState1.m_60713_((net.minecraft.world.level.block.Block)this) || super.m_6104_(blockState, blockState1, direction);
        }

        @NotNull
        public VoxelShape m_5909_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
            return Shapes.m_83040_();
        }

        public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
            return 4;
        }

        public void m_141947_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Entity entity) {
            super.m_141947_(level, blockPos, blockState, entity);
            this.triggerCrystal(blockState, level, blockPos, entity);
        }

        protected void m_7926_(StateDefinition.Builder<net.minecraft.world.level.block.Block, BlockState> builder) {
            builder.m_61104_(new Property[]{AGE, DEFROST});
        }

        public boolean canSustainPlant(@NotNull BlockState state, @NotNull BlockGetter world, BlockPos pos, @NotNull Direction facing, IPlantable plantable) {
            BlockState plant = plantable.getPlant(world, pos.m_142300_(facing));
            if (plant.m_60734_() instanceof CrystalSmall) {
                return true;
            }
            return super.canSustainPlant(state, world, pos, facing, plantable);
        }

        public void m_7458_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Random random) {
            if (((Boolean)state.m_61143_((Property)DEFROST)).booleanValue()) {
                if ((Integer)state.m_61143_((Property)AGE) < 3) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)));
                } else {
                    level.m_46953_(pos, false, null);
                }
                level.m_186460_(pos, (net.minecraft.world.level.block.Block)this, 70);
            } else {
                BlockPos above = pos.m_7494_();
                if (level.m_8055_(above).m_60713_(Blocks.f_50016_)) {
                    level.m_7731_(above, ((net.minecraft.world.level.block.Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_SMALL.get()).m_49966_(), 3);
                    level.m_5594_(null, pos, ChangedSounds.ICE2, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }

        public void m_6240_(@NotNull Level p_49827_, @NotNull Player p_49828_, @NotNull BlockPos p_49829_, @NotNull BlockState p_49830_, @Nullable BlockEntity p_49831_, @NotNull ItemStack p_49832_) {
            super.m_6240_(p_49827_, p_49828_, p_49829_, p_49830_, p_49831_, p_49832_);
        }

        public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
            if (!player.m_7500_() && !player.m_5833_()) {
                List lumiList = level.m_45976_(AbstractLuminarcticLeopard.class, new AABB(pos).m_82400_(10.0));
                for (AbstractLuminarcticLeopard boss : lumiList) {
                    if (!boss.m_6779_((LivingEntity)player) || !boss.m_142582_((Entity)player)) continue;
                    if (player.m_183503_() instanceof ServerLevel) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, false, false));
                    }
                    boss.m_6710_((LivingEntity)player);
                }
            }
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }

        @NotNull
        public List<ItemStack> m_7381_(BlockState blockState, LootContext.Builder lootBuilder) {
            ResourceLocation resourcelocation = this.m_60589_();
            if (resourcelocation == BuiltInLootTables.f_78712_) {
                return Collections.emptyList();
            }
            LootContext lootcontext = lootBuilder.m_78972_(LootContextParams.f_81461_, (Object)blockState).m_78975_(LootContextParamSets.f_81421_);
            ServerLevel serverlevel = lootcontext.m_78952_();
            LootTable loottable = serverlevel.m_142572_().m_129898_().m_79217_(resourcelocation);
            return loottable.m_79129_(lootcontext);
        }

        public void m_7455_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Random random) {
            if (((Boolean)state.m_61143_((Property)DEFROST)).booleanValue()) {
                if (random.nextFloat() >= 0.99f) {
                    for (Direction direction : Direction.values()) {
                        AbstractLuminarCrystal.spawnParticleOnFace(level, pos, direction, 1, 0.0f);
                    }
                }
                level.m_186460_(pos, (net.minecraft.world.level.block.Block)this, 70);
            } else {
                for (Direction direction : Direction.values()) {
                    BlockPos relative;
                    BlockState relativeState;
                    if (direction == Direction.UP || !(random.nextFloat() >= 0.8f) || (relativeState = level.m_8055_(relative = pos.m_142300_(direction))).m_60734_() instanceof CrystalSmall || !relativeState.m_60795_() && (!relativeState.m_60819_().m_164512_((Fluid)Fluids.f_76193_) || !relativeState.m_60767_().m_76336_() || relativeState.m_60819_().m_76152_() instanceof LavaFluid)) continue;
                    BlockState smallCrystalStage = ((net.minecraft.world.level.block.Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_SMALL.get()).m_49966_();
                    smallCrystalStage = (BlockState)smallCrystalStage.m_61124_((Property)CrystalSmall.FACING, (Comparable)direction);
                    smallCrystalStage = (BlockState)smallCrystalStage.m_61124_((Property)CrystalSmall.WATERLOGGED, (Comparable)Boolean.valueOf(relativeState.m_60819_().m_164512_((Fluid)Fluids.f_76193_)));
                    level.m_7731_(relative, smallCrystalStage, 3);
                }
            }
        }

        public void m_7100_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Random random) {
            super.m_7100_(state, level, pos, random);
        }

        private void triggerCrystal(BlockState blockState, Level level, BlockPos position, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                if (!(entity instanceof ChangedEntity) && !le.m_21224_()) {
                    Player player;
                    if (entity instanceof Player && (ProcessTransfur.isPlayerTransfurred((Player)(player = (Player)entity)) || player.m_7500_())) {
                        return;
                    }
                    level.m_186460_(position, (net.minecraft.world.level.block.Block)this, 20);
                }
            }
        }
    }
}

