/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.Map;
import java.util.function.Supplier;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.ltxprogrammer.changed.block.AbstractLatexIceBlock;
import net.ltxprogrammer.changed.block.TransfurCrystalBlock;
import net.ltxprogrammer.changed.block.WolfCrystal;
import net.ltxprogrammer.changed.block.WolfCrystalBlock;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.init.ChangedBlocks;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.ltxprogrammer.changed.init.ChangedMaterials;
import net.ltxprogrammer.changed.init.ChangedTransfurVariants;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class AbstractWolfCrystalExtender {

    public static abstract class AbstractWolfCrystalSmall
    extends TransfurCrystalBlock {
        public AbstractWolfCrystalSmall(Supplier<? extends Item> fragment) {
            super((Supplier)ChangedTransfurVariants.CRYSTAL_WOLF, fragment, BlockBehaviour.Properties.m_60939_((Material)ChangedMaterials.LATEX_CRYSTAL).m_60918_(SoundType.f_154655_).m_60955_().m_60988_().m_60913_(1.7f, 0.2f).m_60993_());
        }

        public AbstractWolfCrystalSmall() {
            super((Supplier)ChangedTransfurVariants.CRYSTAL_WOLF, (Supplier)ChangedItems.WOLF_CRYSTAL_FRAGMENT, BlockBehaviour.Properties.m_60939_((Material)ChangedMaterials.LATEX_CRYSTAL).m_60918_(SoundType.f_154655_).m_60955_().m_60988_().m_60913_(1.7f, 0.2f).m_60993_());
        }

        @NotNull
        public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
            return Shapes.m_83040_();
        }
    }

    public static abstract class AbstractWolfCrystalBlock
    extends AbstractLatexIceBlock {
        public AbstractWolfCrystalBlock() {
            super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76316_, (MaterialColor)MaterialColor.f_76364_).m_60911_(0.98f).m_60918_(SoundType.f_154654_).m_60913_(2.0f, 2.0f).m_60993_());
        }

        public boolean canSustainPlant(@NotNull BlockState state, @NotNull BlockGetter world, BlockPos pos, @NotNull Direction facing, IPlantable plantable) {
            BlockState plant = plantable.getPlant(world, pos.m_142300_(facing));
            return plant.m_60734_() instanceof WolfCrystal;
        }

        public void m_141947_(@NotNull Level level, @NotNull BlockPos position, @NotNull BlockState blockState, @NotNull Entity entity) {
            this.triggerCrystal(blockState, level, position, entity);
            super.m_141947_(level, position, blockState, entity);
        }

        private void triggerCrystal(BlockState blockState, Level level, BlockPos position, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                if (!(entity instanceof ChangedEntity) && !le.m_21224_()) {
                    Player player;
                    if (entity instanceof Player && (ProcessTransfur.isPlayerTransfurred((Player)(player = (Player)entity)) || player.m_7500_())) {
                        return;
                    }
                    level.m_186460_(position, (Block)this, 20);
                }
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class TransformBlockSystem {
        @SubscribeEvent
        public static void colorTheCrystal(PlayerInteractEvent.RightClickBlock event) {
            Map<Item, Block> dyeToBlockMap;
            Block newBlock;
            Level level = event.getWorld();
            BlockPos pos = event.getPos();
            ItemStack itemStack = event.getItemStack();
            BlockState currentState = level.m_8055_(pos);
            Block block = currentState.m_60734_();
            if ((block instanceof WolfCrystalBlock || block instanceof AbstractWolfCrystalBlock) && (newBlock = (dyeToBlockMap = Map.of(Items.f_42538_, (Block)ChangedAddonBlocks.BLUE_WOLF_CRYSTAL_BLOCK.get(), Items.f_42535_, (Block)ChangedAddonBlocks.WHITE_WOLF_CRYSTAL_BLOCK.get(), Items.f_42536_, (Block)ChangedAddonBlocks.ORANGE_WOLF_CRYSTAL_BLOCK.get(), Items.f_42539_, (Block)ChangedAddonBlocks.YELLOW_WOLF_CRYSTAL_BLOCK.get(), Items.f_42497_, (Block)ChangedBlocks.WOLF_CRYSTAL_BLOCK.get())).get(itemStack.m_41720_())) != null && !newBlock.m_49966_().equals(currentState)) {
                level.m_46597_(pos, newBlock.m_49966_());
                TransformBlockSystem.playDyeUseSound(level, pos);
                event.getPlayer().m_6674_(event.getHand());
                if (!event.getPlayer().m_7500_()) {
                    itemStack.m_41774_(1);
                }
                TransformBlockSystem.grantAdvancement(event.getPlayer(), "changed_addon:crystal_dyer");
            }
        }

        private static void playDyeUseSound(Level level, BlockPos pos) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }

        private static void grantAdvancement(Player player, String advancementId) {
            if (player instanceof ServerPlayer) {
                AdvancementProgress progress;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation(advancementId));
                if (advancement != null && !(progress = serverPlayer.m_8960_().m_135996_(advancement)).m_8193_()) {
                    for (String criterion : progress.m_8219_()) {
                        serverPlayer.m_8960_().m_135988_(advancement, criterion);
                    }
                }
            }
        }
    }
}

