/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Stream;
import net.foxyas.changedaddon.block.AbstractPlushyBlock;
import net.foxyas.changedaddon.block.entity.DarkLatexWolfPlushyBlockEntity;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonCriteriaTriggers;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.util.DynamicClipContext;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedTransfurVariants;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.Util;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DarkLatexWolfPlushyBlock
extends AbstractPlushyBlock {
    public DarkLatexWolfPlushyBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60918_(SoundType.f_56745_).m_60913_(0.5f, 5.0f).m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.DARK_LATEX_WOLF_PLUSH.get()), renderType -> renderType == RenderType.m_110457_());
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new DarkLatexWolfPlushyBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return super.m_142354_(pLevel, pState, pBlockEntityType);
    }

    @Mod.EventBusSubscriber
    public static class EventHandle {
        public static final ClipContext.ShapeGetter IGNORE_BED = (state, b, pos, context) -> {
            if (state.m_60734_() instanceof BedBlock) {
                return Shapes.m_83040_();
            }
            return ClipContext.Block.COLLIDER.m_7544_(state, b, pos, context);
        };

        public static TransfurVariant<?> getTransfurVariant(Level world) {
            ArrayList<TransfurVariant> list = new ArrayList<TransfurVariant>();
            list.add((TransfurVariant)ChangedTransfurVariants.DARK_LATEX_WOLF_MALE.get());
            list.add((TransfurVariant)ChangedTransfurVariants.DARK_LATEX_WOLF_FEMALE.get());
            list.add((TransfurVariant)ChangedAddonTransfurVariants.PURO_KIND_MALE.get());
            list.add((TransfurVariant)ChangedAddonTransfurVariants.PURO_KIND_FEMALE.get());
            return (TransfurVariant)Util.m_143804_(list, (Random)world.m_5822_());
        }

        @SubscribeEvent
        public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
            if (event.getPlayer().m_183503_().f_46443_) {
                return;
            }
            Player player = event.getPlayer();
            Level world = player.m_183503_();
            Random random = player.m_21187_();
            BlockPos playerBlockPos = player.m_142538_();
            Stream<BlockPos> posStream = FoxyasUtils.betweenClosedStreamSphere(playerBlockPos, 3, 2);
            Vec3 position = player.m_146892_();
            float intensity = 1.0f + (float)player.m_150109_().f_35974_.stream().filter(itemStack -> itemStack.m_150930_((Item)ChangedAddonItems.DARK_LATEX_WOLF_PLUSH.get())).count() / 100.0f;
            for (BlockPos plushyPos : posStream.filter(pos -> world.m_8055_(pos).m_60713_((Block)ChangedAddonBlocks.DARK_LATEX_WOLF_PLUSH.get())).toList()) {
                double distance;
                float luck;
                float value;
                float randomValue;
                boolean canSeePlayer = EventHandle.canPlushySeePlayer((LivingEntity)player, Vec3.m_82512_((Vec3i)plushyPos), 360.0);
                if (!canSeePlayer || event.updateWorld() || ProcessTransfur.isPlayerTransfurred((Player)player) || !((randomValue = random.nextFloat()) <= (value = (float)((double)(0.25f + (luck = player.m_36336_() / 100.0f)) / ((distance = position.m_82554_(Vec3.m_82512_((Vec3i)plushyPos))) * (double)intensity))))) continue;
                ProcessTransfur.transfur((LivingEntity)player, (Level)world, EventHandle.getTransfurVariant(world), (boolean)false, (TransfurContext)TransfurContext.hazard((TransfurCause)TransfurCause.FACE_HAZARD));
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ChangedAddonCriteriaTriggers.SLEEP_NEXT_A_PLUSHY_TRIGGER.trigger(serverPlayer, ProcessTransfur.getPlayerTransfurVariant((Player)serverPlayer), "dark_latex_plushy", true);
                break;
            }
        }

        public static boolean canPlushySeePlayer(LivingEntity targetEntity, Vec3 plushyPos, double fovDegrees) {
            double requiredDot;
            Vec3 directionToTarget;
            Level level = targetEntity.f_19853_;
            Vec3 from = targetEntity.m_20299_(1.0f);
            Vec3 lookVec = targetEntity.m_20154_().m_82541_();
            double dot = lookVec.m_82526_(directionToTarget = plushyPos.m_82546_(from).m_82541_());
            if (dot < (requiredDot = Math.cos(Math.toRadians(fovDegrees / 2.0)))) {
                return false;
            }
            BlockHitResult result = level.m_45547_((ClipContext)new DynamicClipContext(from, plushyPos, IGNORE_BED, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)targetEntity)));
            return result.m_6662_() == HitResult.Type.MISS || result.m_82450_().m_82557_(plushyPos) < 1.0;
        }
    }
}

