/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.List;
import java.util.Random;
import net.foxyas.changedaddon.entity.advanced.LuminaraFlowerBeastEntity;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonMobEffects;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.ltxprogrammer.changed.block.AbstractLatexBlock;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LuminaraBloomFlowerBlock
extends FlowerBlock
implements BonemealableBlock {
    public LuminaraBloomFlowerBlock() {
        super(ChangedAddonMobEffects.UNTRANSFUR, 60, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60991_((state, blockGetter, blockPos) -> true).m_60982_((state, blockGetter, blockPos) -> true).m_60910_().m_60988_().m_60966_().m_60918_(SoundType.f_56740_));
    }

    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.LUMINARA_BLOOM.get()), renderType -> renderType == RenderType.m_110463_());
    }

    public int m_7753_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return 3;
    }

    public void m_6807_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        pLevel.m_186460_(pPos, (Block)this, 10);
    }

    public void m_7458_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull Random pRandom) {
        super.m_7458_(pState, pLevel, pPos, pRandom);
        LuminaraBloomFlowerBlock.tryToPacifyNearbyEntities(pLevel, pPos, 64.0);
        pLevel.m_186460_(pPos, (Block)this, 10);
    }

    public static void tryToPacifyNearbyEntities(@NotNull ServerLevel pLevel, BlockPos pPos, double range) {
        List nearChangedBeasts = pLevel.m_6443_(LivingEntity.class, new AABB(pPos, pPos).m_82400_(range), entity -> FoxyasUtils.canEntitySeePosIgnoreGlass(entity, Vec3.m_82512_((Vec3i)pPos), 90.0));
        for (LivingEntity livingEntity : nearChangedBeasts) {
            Player player;
            TransfurVariantInstance instance;
            if (livingEntity instanceof ChangedEntity) {
                ChangedEntity changedEntity = (ChangedEntity)livingEntity;
                if (changedEntity.m_6095_().m_204039_(ChangedAddonTags.EntityTypes.PACIFY_IMMUNE) || changedEntity instanceof LuminaraFlowerBeastEntity || !changedEntity.m_6095_().m_204039_(ChangedTags.EntityTypes.LATEX) || changedEntity.m_21023_((MobEffect)ChangedAddonMobEffects.PACIFIED.get())) continue;
                changedEntity.m_7292_(new MobEffectInstance((MobEffect)ChangedAddonMobEffects.PACIFIED.get(), 1200, 0, true, false, true));
                continue;
            }
            if (!(livingEntity instanceof Player) || (instance = ProcessTransfur.getPlayerTransfurVariant((Player)(player = (Player)livingEntity))) == null || instance.getChangedEntity().m_6095_().m_204039_(ChangedAddonTags.EntityTypes.PACIFY_IMMUNE) || instance.getChangedEntity() instanceof LuminaraFlowerBeastEntity || !instance.getParent().getEntityType().m_204039_(ChangedTags.EntityTypes.LATEX) || player.m_21023_((MobEffect)ChangedAddonMobEffects.PACIFIED.get())) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)ChangedAddonMobEffects.PACIFIED.get(), 1200, 0, true, false, true));
        }
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        BlockState below = pLevel.m_8055_(pPos.m_7495_());
        if (below.m_60734_() instanceof AbstractLatexBlock) {
            return true;
        }
        return super.m_7898_(pState, pLevel, pPos);
    }

    public void m_7100_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Random random) {
        if ((double)random.nextFloat() >= 0.25) {
            return;
        }
        Vec3 offset = state.m_60824_((BlockGetter)level, pos);
        float x = (float)offset.f_82479_ + (float)pos.m_123341_() + 0.5f + random.nextFloat(-0.3f, 0.3f);
        float y = (float)offset.f_82480_ + (float)pos.m_123342_() + 0.5625f;
        float z = (float)offset.f_82481_ + (float)pos.m_123343_() + 0.5f + random.nextFloat(-0.3f, 0.3f);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123786_, (double)x, (double)y, (double)z, 0.0, 0.01, 0.0);
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            if (random.nextFloat() >= 0.5f) {
                return;
            }
            clientLevel.m_104677_(pos, SoundEvents.f_144243_, SoundSource.BLOCKS, 1.0f, random.nextFloat(), true);
        }
    }

    protected boolean m_6266_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        if (pState.m_60734_() instanceof AbstractLatexBlock) {
            return true;
        }
        return super.m_6266_(pState, pLevel, pPos);
    }

    public boolean m_7370_(@NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull BlockState blockState, boolean pIsClient) {
        return BlockPos.m_121921_((AABB)new AABB(blockPos, blockPos).m_82377_(3.0, 1.0, 3.0)).anyMatch(pos -> {
            BlockState normal = blockGetter.m_8055_(pos);
            BlockState below = blockGetter.m_8055_(pos.m_7495_());
            return normal.m_60795_() && (below.m_60734_() instanceof AbstractLatexBlock || below.m_204336_(BlockTags.f_144274_) || below.m_60713_(Blocks.f_50093_));
        });
    }

    public boolean m_5491_(@NotNull Level level, @NotNull Random random, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return true;
    }

    public void m_7719_(@NotNull ServerLevel serverLevel, @NotNull Random random, @NotNull BlockPos pos, @NotNull BlockState state) {
        int tries = 16;
        for (int i = 0; i < tries; ++i) {
            BlockState below;
            BlockPos targetPos = pos.m_142082_(random.nextInt(7) - 3, random.nextInt(3) - 1, random.nextInt(7) - 3);
            if (!serverLevel.m_46859_(targetPos) || !((below = serverLevel.m_8055_(targetPos.m_7495_())).m_60734_() instanceof AbstractLatexBlock) && !below.m_204336_(BlockTags.f_144274_) && !below.m_60713_(Blocks.f_50093_)) continue;
            serverLevel.m_7731_(targetPos, state, 3);
        }
    }
}

