/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.HashMap;
import java.util.Map;
import net.foxyas.changedaddon.block.interfaces.RenderLayerProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultifaceBlock
extends Block
implements RenderLayerProvider {
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();

    public MultifaceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE_CACHE.computeIfAbsent(state, s -> {
            VoxelShape res = Shapes.m_83040_();
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                res = Shapes.m_83148_((VoxelShape)res, (VoxelShape)UP_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                res = Shapes.m_83148_((VoxelShape)res, (VoxelShape)WEST_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                res = Shapes.m_83148_((VoxelShape)res, (VoxelShape)EAST_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                res = Shapes.m_83148_((VoxelShape)res, (VoxelShape)NORTH_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                res = Shapes.m_83148_((VoxelShape)res, (VoxelShape)SOUTH_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                res = Shapes.m_83148_((VoxelShape)res, (VoxelShape)DOWN_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            return res;
        });
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        boolean empty = true;
        for (Direction dir : Direction.values()) {
            BooleanProperty prop = (BooleanProperty)PipeBlock.f_55154_.get(dir);
            if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            BlockPos rel = currentPos.m_142300_(dir);
            if (!this.canAttachTo(level, rel, level.m_8055_(rel), dir.m_122424_())) {
                state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false));
                if (!(level instanceof Level)) continue;
                Level l = (Level)level;
                Block.m_49840_((Level)l, (BlockPos)currentPos, (ItemStack)new ItemStack((ItemLike)this));
                continue;
            }
            empty = false;
        }
        return empty ? Blocks.f_50016_.m_49966_() : state;
    }

    protected boolean canAttachTo(LevelAccessor level, BlockPos attachToPos, BlockState attachTo, Direction attachToFace) {
        return Block.m_49918_((VoxelShape)attachTo.m_60808_((BlockGetter)level, attachToPos), (Direction)attachToFace);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(context.m_8083_());
        Direction dir = context.m_43719_();
        BooleanProperty prop = (BooleanProperty)PipeBlock.f_55154_.get(dir.m_122424_());
        if (state.m_60713_((Block)this)) {
            if (((Boolean)state.m_61143_((Property)prop)).booleanValue()) {
                return null;
            }
            BlockPos rel = context.m_8083_().m_142300_(dir.m_122424_());
            if (this.canAttachTo((LevelAccessor)level, rel, level.m_8055_(rel), dir)) {
                state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        BlockPos rel = context.m_8083_().m_142300_(dir.m_122424_());
        if (!this.canAttachTo((LevelAccessor)level, rel, level.m_8055_(rel), dir)) {
            return null;
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext context) {
        if (super.m_6864_(state, context)) {
            return true;
        }
        if (!context.m_43722_().m_150930_(this.m_5456_())) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(context.m_43719_().m_122424_())) == false;
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        for (BooleanProperty prop : PipeBlock.f_55154_.values()) {
            if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{UP, NORTH, EAST, SOUTH, WEST, DOWN}));
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation pRotate) {
        return switch (pRotate) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            default -> state;
        };
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> state;
        };
    }
}

