/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block.advanced;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.init.ChangedEntities;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.init.ChangedTransfurVariants;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PawsScanner
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = LeverBlock.f_54622_;
    protected static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)0.75, (double)14.0), (VoxelShape)Block.m_49796_((double)2.5, (double)0.75, (double)7.7, (double)13.5, (double)1.0, (double)12.95));
    protected static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)0.75, (double)13.0), (VoxelShape)Block.m_49796_((double)2.5, (double)0.75, (double)3.05, (double)13.5, (double)1.0, (double)8.3));
    protected static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)13.0, (double)0.75, (double)15.0), (VoxelShape)Block.m_49796_((double)3.05, (double)0.75, (double)2.5, (double)8.3, (double)1.0, (double)13.5));
    protected static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)14.0, (double)0.75, (double)15.0), (VoxelShape)Block.m_49796_((double)7.7, (double)0.75, (double)2.5, (double)12.95, (double)1.0, (double)13.5));
    protected static final VoxelShape PAWS_SCANNER_SHAPE_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.5, (double)0.75, (double)7.7, (double)13.5, (double)1.0, (double)12.95), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape PAWS_SCANNER_SHAPE_SOUTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.5, (double)0.75, (double)3.05, (double)13.5, (double)1.0, (double)8.3), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape PAWS_SCANNER_SHAPE_EAST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.05, (double)0.75, (double)2.5, (double)8.3, (double)1.0, (double)13.5), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape PAWS_SCANNER_SHAPE_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.7, (double)0.75, (double)2.5, (double)12.95, (double)1.0, (double)13.5), (VoxelShape[])new VoxelShape[0]);

    public PawsScanner() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 3.0f).m_60988_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    protected static VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = switch (direction) {
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            case Direction.EAST -> 1;
            default -> 0;
        };
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(16.0 - maxZ), (double)minY, (double)minX, (double)(16.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.HAND_SCANNER.get()), renderType -> renderType == RenderType.m_110463_());
    }

    @NotNull
    protected ImmutableMap<BlockState, VoxelShape> m_152458_(@NotNull Function<BlockState, VoxelShape> p_152459_) {
        return super.m_152458_(p_152459_);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED, FACING});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    public VoxelShape getShapeOfPawsScanner(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> PAWS_SCANNER_SHAPE_SOUTH;
            case Direction.WEST -> PAWS_SCANNER_SHAPE_WEST;
            case Direction.EAST -> PAWS_SCANNER_SHAPE_EAST;
            default -> PAWS_SCANNER_SHAPE_NORTH;
        };
    }

    @NotNull
    public VoxelShape m_5909_(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public void m_6807_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 5);
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if ((entity instanceof ChangedEntity || entity instanceof Player) && !level.f_46443_ && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && this.shouldActivate(state, level, pos, entity)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            this.updateRedstoneSignal(level, pos);
            ChangedSounds.broadcastSound((MinecraftServer)Objects.requireNonNull(level.m_142572_()), (SoundEvent)ChangedSounds.CHIME2, (BlockPos)pos, (float)1.0f, (float)1.0f);
            level.m_186460_(pos, (Block)this, 10);
        }
    }

    public void updateRedstoneSignal(Level level, BlockPos pos) {
        level.m_46672_(pos, (Block)this);
        for (Direction direction : Direction.values()) {
            level.m_46672_(pos.m_142300_(direction), (Block)this);
        }
    }

    public void m_7458_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull Random random) {
        boolean hasEntity = this.shouldActivate(state, (Level)level, pos);
        boolean isPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (hasEntity && !isPowered) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            this.updateRedstoneSignal((Level)level, pos);
            ChangedSounds.broadcastSound((MinecraftServer)level.m_142572_(), (SoundEvent)ChangedSounds.CHIME2, (BlockPos)pos, (float)1.0f, (float)1.0f);
        } else if (!hasEntity && isPowered) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            this.updateRedstoneSignal((Level)level, pos);
            ChangedSounds.broadcastSound((MinecraftServer)level.m_142572_(), (SoundEvent)ChangedSounds.KEY, (BlockPos)pos, (float)0.6f, (float)1.0f);
        }
        if (hasEntity) {
            level.m_186460_(pos, (Block)this, 10);
        }
    }

    private boolean shouldActivate(BlockState state, Level level, BlockPos pos) {
        VoxelShape shape = this.getShapeOfPawsScanner(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        AABB aabb = shape.m_83215_().m_82383_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.0, 0.25, 0.0));
        List list = level.m_6443_(LivingEntity.class, aabb, living -> {
            Player player;
            ChangedEntity changedEntity;
            return living instanceof ChangedEntity && (changedEntity = (ChangedEntity)living).m_6095_() != ChangedEntities.LATEX_HUMAN.get() || living instanceof Player && !(player = (Player)living).m_5833_() && ProcessTransfur.getPlayerTransfurVariant((Player)player) != null && !ProcessTransfur.getPlayerTransfurVariant((Player)player).is((Supplier)ChangedTransfurVariants.LATEX_HUMAN);
        });
        return list.stream().anyMatch(living -> living.m_6844_(EquipmentSlot.FEET).m_41619_());
    }

    private boolean shouldActivate(BlockState state, Level level, BlockPos pos, Entity stepEntity) {
        VoxelShape shape = this.getShapeOfPawsScanner(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        AABB aabb = shape.m_83215_().m_82383_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(0.0, 0.25, 0.0));
        List list = level.m_6443_(LivingEntity.class, aabb, living -> {
            Player player;
            ChangedEntity changedEntity;
            return living instanceof ChangedEntity && (changedEntity = (ChangedEntity)living).m_6095_() != ChangedEntities.LATEX_HUMAN.get() || living instanceof Player && !(player = (Player)living).m_5833_() && ProcessTransfur.getPlayerTransfurVariant((Player)player) != null && !ProcessTransfur.getPlayerTransfurVariant((Player)player).is((Supplier)ChangedTransfurVariants.LATEX_HUMAN);
        });
        return list.stream().anyMatch(living -> living.m_6844_(EquipmentSlot.FEET).m_41619_());
    }

    private void debugSpawnParticlesInShape(Level level, AABB box, BlockPos pos) {
        double step = 0.2;
        for (double x = box.f_82288_; x <= box.f_82291_; x += step) {
            for (double y = box.f_82289_; y <= box.f_82292_; y += step) {
                for (double z = box.f_82290_; z <= box.f_82293_; z += step) {
                    level.m_6493_((ParticleOptions)ParticleTypes.f_123748_, true, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        return level.m_8055_(belowPos).m_60783_((BlockGetter)level, belowPos, Direction.UP);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public static enum LockType implements StringRepresentable
    {
        HUMAN,
        TRANSFURRED;


        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

