/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block.advanced;

import java.util.List;
import net.foxyas.changedaddon.init.ChangedAddonBlockEntities;
import net.ltxprogrammer.changed.block.KeypadBlock;
import net.ltxprogrammer.changed.block.entity.KeypadBlockEntity;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimedKeypadBlockEntity
extends KeypadBlockEntity {
    private int timer = 0;
    private boolean canTick = false;
    private int ticks = 0;

    public TimedKeypadBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    @NotNull
    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ChangedAddonBlockEntities.TIMED_KEYPAD_BLOCK_ENTITY.get();
    }

    public void setCanTick(boolean canTick) {
        this.canTick = canTick;
    }

    public boolean canTick() {
        return this.canTick;
    }

    public void addTimer(int timer) {
        this.timer = Math.max(0, Math.min(this.timer + timer, 1000));
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = Math.max(0, Math.min(timer, 1000));
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("timer", this.timer);
        tag.m_128379_("canTick", this.canTick);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("timer")) {
            this.timer = tag.m_128451_("timer");
        }
        if (tag.m_128441_("canTick")) {
            this.canTick = tag.m_128471_("canTick");
        }
    }

    private void playSound(SoundEvent event, float volume, float pitch) {
        if (this.f_58857_.m_142572_() != null) {
            ChangedSounds.broadcastSound((MinecraftServer)this.f_58857_.m_142572_(), (SoundEvent)event, (BlockPos)this.f_58858_, (float)volume, (float)pitch);
        }
    }

    public void playUnlockSuccess() {
        this.playSound(ChangedSounds.CHIME2, 1.0f, 1.0f);
    }

    public void playUnlockFail() {
        this.playSound(ChangedSounds.BUZZER1, 1.0f, 1.0f);
    }

    public void playLock() {
        this.playSound(ChangedSounds.KEY, 1.0f, 1.0f);
    }

    public void playTimerAdjust(boolean isPositive) {
        this.playSound(ChangedSounds.KEY, 1.0f, isPositive ? 1.0f : 0.75f);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @NotNull
    public CompoundTag getUpdatePacketTag() {
        return this.m_5995_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void tick(@NotNull Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        if (!this.canTick) {
            return;
        }
        if (!((Boolean)this.m_58900_().m_61143_((Property)KeypadBlock.POWERED)).booleanValue()) {
            return;
        }
        ++this.ticks;
        if (this.ticks % 10 == 0) {
            if (this.timer > 0) {
                --this.timer;
            } else {
                this.timer = 0;
                this.lockKeypad(level, pos, this.m_58900_());
                this.playLock();
                this.canTick = false;
            }
        }
        if (this.ticks >= 4096) {
            this.ticks = 0;
        }
    }

    public void lockKeypad(Level level, BlockPos blockPos, BlockState state) {
        level.m_46597_(blockPos, (BlockState)this.m_58900_().m_61124_((Property)KeypadBlock.POWERED, (Comparable)Boolean.FALSE));
        level.m_46672_(blockPos, state.m_60734_());
        level.m_46672_(blockPos.m_142300_(((Direction)state.m_61143_((Property)KeypadBlock.FACING)).m_122424_()), state.m_60734_());
    }

    public void useCode(List<Byte> attemptedCode) {
        super.useCode(attemptedCode);
        if (this.f_58857_ != null && this.code != null && this.getTimer() > 0) {
            this.setCanTick(true);
        }
    }
}

