/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block.entity;

import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.init.ChangedAddonBlockEntities;
import net.foxyas.changedaddon.world.inventory.GeneratorGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class GeneratorBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final EnergyStorage energyStorage = new EnergyStorage(50000, 5000, 5000, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                GeneratorBlockEntity.this.m_6596_();
                GeneratorBlockEntity.this.f_58857_.m_7260_(GeneratorBlockEntity.this.f_58858_, GeneratorBlockEntity.this.f_58857_.m_8055_(GeneratorBlockEntity.this.f_58858_), GeneratorBlockEntity.this.f_58857_.m_8055_(GeneratorBlockEntity.this.f_58858_), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                GeneratorBlockEntity.this.m_6596_();
                GeneratorBlockEntity.this.f_58857_.m_7260_(GeneratorBlockEntity.this.f_58858_, GeneratorBlockEntity.this.f_58857_.m_8055_(GeneratorBlockEntity.this.f_58858_), GeneratorBlockEntity.this.f_58857_.m_8055_(GeneratorBlockEntity.this.f_58858_), 2);
            }
            return retval;
        }
    };
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)0, (Object)ItemStack.f_41583_);

    public GeneratorBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ChangedAddonBlockEntities.GENERATOR.get(), position, state);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        if (!this.m_59631_(compound)) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
        Tag tag = compound.m_128423_("energyStorage");
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT((Tag)intTag);
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        }
        compound.m_128365_("energyStorage", this.energyStorage.serializeNBT());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component m_6820_() {
        return new TextComponent("generator");
    }

    public int m_6893_() {
        return 64;
    }

    @NotNull
    public AbstractContainerMenu m_6555_(int id, @NotNull Inventory inventory) {
        return new GeneratorGuiMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    @NotNull
    public Component m_5446_() {
        return new TextComponent("Generator");
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(@NotNull NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        return true;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[facing.ordinal()].cast();
        }
        if (!this.f_58859_ && capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

