/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.foxyas.changedaddon.configuration.ChangedAddonClientConfiguration;
import net.foxyas.changedaddon.entity.interfaces.IDynamicPawColor;
import net.foxyas.changedaddon.init.ChangedAddonKeyMappings;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.process.features.PatFeatureHandle;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PatOverlay {
    public static final ResourceLocation TEXTURE = new ResourceLocation("changed_addon:textures/screens/paw_normal.png");

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGameOverlayEvent.Pre event) {
        if (!((Boolean)ChangedAddonClientConfiguration.PAT_OVERLAY.get()).booleanValue()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Entity lookedEntity;
            int w = event.getWindow().m_85445_();
            int h = event.getWindow().m_85446_();
            double posX = (Double)ChangedAddonClientConfiguration.PAT_OVERLAY_X.get();
            double posY = (double)h - (Double)ChangedAddonClientConfiguration.PAT_OVERLAY_Y.get();
            float floatPosX = (float)posX;
            float floatPosY = (float)posY;
            LocalPlayer entity = Minecraft.m_91087_().f_91074_;
            if (entity != null && !entity.m_5833_() && (entity.m_21205_().m_41619_() || entity.m_21206_().m_41619_()) && (lookedEntity = PlayerUtil.getEntityLookingAt((Entity)entity, entity.getReachDistance())) != null && PatOverlay.isPatableEntity((Player)entity, lookedEntity) && PatOverlay.isEntityInPassiveStage(lookedEntity) && PatOverlay.isKeySet() && !PatOverlay.getPatInfo((Entity)entity).getString().isEmpty() && !lookedEntity.m_20145_() && PatFeatureHandle.canPlayerPat((Player)entity)) {
                if (!((Boolean)ChangedAddonClientConfiguration.PAW_STYLE_PAT_OVERLAY.get()).booleanValue()) {
                    GuiComponent.m_93215_((PoseStack)event.getMatrixStack(), (Font)Minecraft.m_91087_().f_91062_, (Component)PatOverlay.getPatInfo(lookedEntity), (int)((int)floatPosX), (int)((int)floatPosY), (int)-1);
                } else {
                    TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)entity);
                    Minecraft mc = Minecraft.m_91087_();
                    PoseStack poseStack = event.getMatrixStack();
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                    int x = (int)posX;
                    int y = (int)posY;
                    int largura = 19;
                    int altura = 19;
                    float troubleShotXValue = floatPosX + 9.0f;
                    float troubleShotYValue = floatPosY + 20.0f;
                    if (instance != null) {
                        ChangedEntity changedEntity = instance.getChangedEntity();
                        if (changedEntity instanceof IDynamicPawColor) {
                            IDynamicPawColor iDynamicPawColor = (IDynamicPawColor)changedEntity;
                            Color pawColor = iDynamicPawColor.getPawBeansColor();
                            RenderSystem.m_157429_((float)((float)pawColor.getRed() / 255.0f), (float)((float)pawColor.getGreen() / 255.0f), (float)((float)pawColor.getBlue() / 255.0f), (float)((float)pawColor.getAlpha() / 255.0f));
                            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)largura, (int)altura, (int)largura, (int)altura);
                            GuiComponent.m_93208_((PoseStack)event.getMatrixStack(), (Font)mc.f_91062_, (String)PatOverlay.getSimplePatInfo(), (int)((int)troubleShotXValue), (int)((int)troubleShotYValue), (int)pawColor.getRGB());
                        } else {
                            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)largura, (int)altura, (int)largura, (int)altura);
                            GuiComponent.m_93208_((PoseStack)event.getMatrixStack(), (Font)mc.f_91062_, (String)PatOverlay.getSimplePatInfo(), (int)((int)troubleShotXValue), (int)((int)troubleShotYValue), (int)Color3.getColor((String)"#ffabab").toInt());
                        }
                    } else {
                        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)largura, (int)altura, (int)largura, (int)altura);
                        GuiComponent.m_93208_((PoseStack)event.getMatrixStack(), (Font)mc.f_91062_, (String)PatOverlay.getSimplePatInfo(), (int)((int)troubleShotXValue), (int)((int)troubleShotYValue), (int)Color3.getColor((String)"#ffabab").toInt());
                    }
                }
            }
        }
    }

    private static boolean isEntityInPassiveStage(Entity lookedEntity) {
        if (lookedEntity instanceof ChangedEntity) {
            ChangedEntity changedEntity = (ChangedEntity)lookedEntity;
            return changedEntity.m_5448_() == null;
        }
        if (lookedEntity instanceof Mob) {
            Mob mob = (Mob)lookedEntity;
            return mob.m_5448_() == null;
        }
        return lookedEntity instanceof Player;
    }

    private static boolean isPatableEntity(Player player, Entity patEntity) {
        boolean isPatableByTag = patEntity.m_6095_().m_204039_(ChangedAddonTags.EntityTypes.PATABLE);
        if (!PatOverlay.isLineOfSightClear(player, patEntity)) {
            return false;
        }
        if (patEntity instanceof Player) {
            boolean isPlayerTransfur;
            Player patPlayer = (Player)patEntity;
            boolean isPatPlayerTransfur = ProcessTransfur.getPlayerTransfurVariant((Player)patPlayer) != null;
            boolean bl = isPlayerTransfur = ProcessTransfur.getPlayerTransfurVariant((Player)player) != null;
            if (isPatPlayerTransfur) {
                return true;
            }
            if (isPlayerTransfur) {
                return true;
            }
        } else if (patEntity instanceof ChangedEntity) {
            return true;
        }
        return isPatableByTag;
    }

    private static boolean isLineOfSightClear(Player player, Entity entity) {
        Vec3 entityEyePos;
        Vec3 playerEyePos;
        Level level = player.m_183503_();
        BlockHitResult result = level.m_45547_(new ClipContext(playerEyePos = player.m_20299_(1.0f), entityEyePos = entity.m_142469_().m_82399_(), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
        return result.m_6662_() == HitResult.Type.MISS;
    }

    public static boolean isKeySet() {
        String key = ChangedAddonKeyMappings.PAT_KEY.m_90863_().getString();
        return !key.isEmpty();
    }

    private static TranslatableComponent getPatInfo(Entity lookedEntity) {
        String key = ChangedAddonKeyMappings.PAT_KEY.m_90863_().getString();
        if (lookedEntity instanceof LivingEntity) {
            TranslatableComponent patMessage = new TranslatableComponent("changed_addon.info.is_patable", new Object[]{key.isEmpty() ? "Not Key Set" : key, lookedEntity.m_5446_().getString()});
            patMessage.m_130938_(style -> style.m_178520_(Color3.getColor((String)"#FFFFFF").toInt()).m_131155_(Boolean.valueOf(true)));
            return patMessage;
        }
        return new TranslatableComponent("");
    }

    private static String getSimplePatInfo() {
        return ChangedAddonKeyMappings.PAT_KEY.m_90863_().getString();
    }

    private static TextComponent PatInfo2(Entity lookedEntity) {
        if (lookedEntity instanceof LivingEntity) {
            TextComponent patMessage = lookedEntity.m_8077_() ? new TextComponent(lookedEntity.m_7770_().getString()) : new TextComponent(lookedEntity.m_5446_().getString());
            patMessage.m_130938_(style -> style.m_178520_(Color3.getColor((String)"#FFFFFF").toInt()).m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(true)));
            return patMessage;
        }
        return new TextComponent("");
    }
}

