/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.entity.advanced.DazedLatexEntity;
import net.ltxprogrammer.changed.client.renderer.animate.AnimatorPresets;
import net.ltxprogrammer.changed.client.renderer.animate.HumanoidAnimator;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModelInterface;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class LatexDazedModel
extends AdvancedHumanoidModel<DazedLatexEntity>
implements AdvancedHumanoidModelInterface<DazedLatexEntity, LatexDazedModel> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ChangedAddonMod.resourceLoc("dazed_latex"), "main");
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart Head;
    private final ModelPart Torso;
    private final ModelPart Tail;
    private final ModelPart Puddle;
    private final ModelPart Middle;
    private final ModelPart Top;
    private final HumanoidAnimator<DazedLatexEntity, LatexDazedModel> animator;

    public LatexDazedModel(ModelPart root) {
        super(root);
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.Head = root.m_171324_("Head");
        this.Torso = root.m_171324_("Torso");
        this.Tail = this.Torso.m_171324_("Tail");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftArm = root.m_171324_("LeftArm");
        this.Puddle = root.m_171324_("Puddle");
        ModelPart PuddleRoot = this.Puddle.m_171324_("Root");
        this.Middle = PuddleRoot.m_171324_("Middle");
        this.Top = this.Middle.m_171324_("Top");
        ModelPart tailPrimary = this.Tail.m_171324_("TailPrimary");
        ModelPart tailSecondary = tailPrimary.m_171324_("TailSecondary");
        ModelPart tailTertiary = tailSecondary.m_171324_("TailTertiary");
        ModelPart leftLowerLeg = this.LeftLeg.m_171324_("LeftLowerLeg");
        ModelPart leftFoot = leftLowerLeg.m_171324_("LeftFoot");
        ModelPart rightLowerLeg = this.RightLeg.m_171324_("RightLowerLeg");
        ModelPart rightFoot = rightLowerLeg.m_171324_("RightFoot");
        this.animator = HumanoidAnimator.of((AdvancedHumanoidModel)this).hipOffset(-1.5f).addPreset(AnimatorPresets.wolfLike((ModelPart)this.Head, (ModelPart)this.Head.m_171324_("LeftEar"), (ModelPart)this.Head.m_171324_("RightEar"), (ModelPart)this.Torso, (ModelPart)this.LeftArm, (ModelPart)this.RightArm, (ModelPart)this.Tail, List.of(tailPrimary, tailSecondary, tailTertiary, tailTertiary.m_171324_("TailQuaternary")), (ModelPart)this.LeftLeg, (ModelPart)leftLowerLeg, (ModelPart)leftFoot, (ModelPart)leftFoot.m_171324_("LeftPad"), (ModelPart)this.RightLeg, (ModelPart)rightLowerLeg, (ModelPart)rightFoot, (ModelPart)rightFoot.m_171324_("RightPad")));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(15, 32).m_171488_(-2.0f, -3.0f, -6.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 22).m_171488_(-1.5f, -1.0f, -5.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition Snout_r1 = Head.m_171599_("Snout_r1", CubeListBuilder.m_171558_().m_171514_(24, 2).m_171488_(-1.0f, -29.625f, -0.95f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)26.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-7.5f, (float)0.0f));
        PartDefinition RightEarPivot = RightEar.m_171599_("RightEarPivot", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.9f, -1.2f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(0, 16).m_171488_(-0.9f, -1.6f, -0.4f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.04f)).m_171514_(32, 22).m_171488_(-0.9f, -2.3f, -1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(24, 0).m_171488_(0.1f, -3.1f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)0.5f, (float)-1.25f, (float)0.0f, (float)-0.1309f, (float)0.5236f, (float)-0.3491f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)-7.5f, (float)0.0f));
        PartDefinition LeftEarPivot = LeftEar.m_171599_("LeftEarPivot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.1f, -1.2f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(0, 20).m_171488_(-1.1f, -1.6f, -0.4f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.04f)).m_171514_(32, 24).m_171488_(-1.1f, -2.3f, -1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(0, 32).m_171488_(-1.1f, -3.1f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)-0.5f, (float)-1.25f, (float)0.0f, (float)-0.1309f, (float)-0.5236f, (float)0.3491f));
        PartDefinition Hair = Head.m_171599_("Hair", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)).m_171514_(24, 8).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.5f, (float)0.0f));
        PartDefinition TailPrimary = Tail.m_171599_("TailPrimary", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Base_r1 = TailPrimary.m_171599_("Base_r1", CubeListBuilder.m_171558_().m_171514_(23, 87).m_171488_(-2.0f, 0.75f, -1.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition TailSecondary = TailPrimary.m_171599_("TailSecondary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.25f, (float)4.5f));
        PartDefinition Base_r2 = TailSecondary.m_171599_("Base_r2", CubeListBuilder.m_171558_().m_171514_(1, 82).m_171488_(-2.5f, -0.45f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition TailTertiary = TailSecondary.m_171599_("TailTertiary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.75f, (float)4.5f));
        PartDefinition Base_r3 = TailTertiary.m_171599_("Base_r3", CubeListBuilder.m_171558_().m_171514_(0, 68).m_171488_(-2.5f, 4.55f, -3.3f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.25f, (float)-4.5f, (float)1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition TailQuaternary = TailTertiary.m_171599_("TailQuaternary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)7.5f));
        PartDefinition Base_r4 = TailQuaternary.m_171599_("Base_r4", CubeListBuilder.m_171558_().m_171514_(21, 68).m_171488_(-2.0f, 5.5f, -3.8f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.15f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-5.5f, (float)1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(16, 40).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)1.5f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)1.5f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)10.5f, (float)0.0f));
        PartDefinition RightThigh_r1 = RightLeg.m_171599_("RightThigh_r1", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightLowerLeg = RightLeg.m_171599_("RightLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.375f, (float)-3.45f));
        PartDefinition RightCalf_r1 = RightLowerLeg.m_171599_("RightCalf_r1", CubeListBuilder.m_171558_().m_171514_(48, 40).m_171488_(-1.99f, -0.125f, -2.9f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLowerLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.8f, (float)7.175f));
        PartDefinition RightArch_r1 = RightFoot.m_171599_("RightArch_r1", CubeListBuilder.m_171558_().m_171514_(56, 11).m_171488_(-2.0f, -8.45f, -0.725f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.005f)), PartPose.m_171423_((float)0.0f, (float)7.075f, (float)-4.975f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightPad = RightFoot.m_171599_("RightPad", CubeListBuilder.m_171558_().m_171514_(52, 32).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.325f, (float)-4.425f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)10.5f, (float)0.0f));
        PartDefinition LeftThigh_r1 = LeftLeg.m_171599_("LeftThigh_r1", CubeListBuilder.m_171558_().m_171514_(32, 44).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLowerLeg = LeftLeg.m_171599_("LeftLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.375f, (float)-3.45f));
        PartDefinition LeftCalf_r1 = LeftLowerLeg.m_171599_("LeftCalf_r1", CubeListBuilder.m_171558_().m_171514_(48, 22).m_171488_(-2.01f, -0.125f, -2.9f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLowerLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.8f, (float)7.175f));
        PartDefinition LeftArch_r1 = LeftFoot.m_171599_("LeftArch_r1", CubeListBuilder.m_171558_().m_171514_(13, 57).m_171488_(-2.0f, -8.45f, -0.725f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.005f)), PartPose.m_171423_((float)0.0f, (float)7.075f, (float)-4.975f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftPad = LeftFoot.m_171599_("LeftPad", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.325f, (float)-4.425f));
        PartDefinition Puddle = partdefinition.m_171599_("Puddle", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)25.5f, (float)0.0f));
        PartDefinition Root = Puddle.m_171599_("Root", CubeListBuilder.m_171558_().m_171514_(42, 71).m_171488_(-5.0f, -4.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition Middle = Root.m_171599_("Middle", CubeListBuilder.m_171558_().m_171514_(42, 85).m_171488_(-4.0f, -5.5f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Top = Middle.m_171599_("Top", CubeListBuilder.m_171558_().m_171514_(66, 85).m_171488_(-2.0f, -7.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)96, (int)96);
    }

    public boolean isPartNotPuddle(ModelPart part) {
        if (this.Puddle.f_104207_) {
            return this.Puddle.m_171331_().anyMatch(part::equals);
        }
        return this.Puddle.m_171331_().noneMatch(part::equals);
    }

    public void prepareMobModel(DazedLatexEntity entity, float p_102862, float p_102863, float p_102864_) {
        if (entity.isMorphed()) {
            this.RightArm.f_104207_ = false;
            this.LeftArm.f_104207_ = false;
            this.Head.m_171331_().forEach(part -> {
                part.f_104207_ = false;
            });
            this.Torso.m_171331_().forEach(part -> {
                part.f_104207_ = false;
            });
            this.RightLeg.f_104207_ = false;
            this.LeftLeg.f_104207_ = false;
            this.Puddle.f_104207_ = true;
        } else {
            this.RightArm.f_104207_ = true;
            this.LeftArm.f_104207_ = true;
            this.Head.f_104207_ = true;
            this.Torso.f_104207_ = true;
            this.RightLeg.f_104207_ = true;
            this.LeftLeg.f_104207_ = true;
            this.Puddle.f_104207_ = false;
        }
        this.prepareMobModel(this.animator, entity, p_102862, p_102863, p_102864_);
    }

    public void setAllLimbsVisible(DazedLatexEntity entity, boolean visible) {
        super.setAllLimbsVisible((ChangedEntity)entity, visible);
        if (visible) {
            this.RightArm.f_104207_ = !entity.isMorphed();
            this.LeftArm.f_104207_ = !entity.isMorphed();
            this.Head.m_171331_().forEach(part -> {
                part.f_104207_ = !entity.isMorphed();
            });
            this.Torso.m_171331_().forEach(part -> {
                part.f_104207_ = !entity.isMorphed();
            });
            this.RightLeg.f_104207_ = !entity.isMorphed();
            this.LeftLeg.f_104207_ = !entity.isMorphed();
            this.Puddle.f_104207_ = entity.isMorphed();
        }
    }

    public void setupHand(DazedLatexEntity entity) {
        this.animator.setupHand();
    }

    public void setupAnim(@NotNull DazedLatexEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animator.setupAnim((ChangedEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.isMorphed()) {
            this.Top.f_104201_ = this.Middle.f_104201_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        }
        super.setupAnim((ChangedEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @NotNull
    public ModelPart m_102851_(HumanoidArm p_102852) {
        return p_102852 == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.Head;
    }

    public ModelPart getTorso() {
        return this.Torso;
    }

    public ModelPart getLeg(HumanoidArm humanoidArm) {
        return humanoidArm == HumanoidArm.LEFT ? this.LeftLeg : this.RightLeg;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Puddle.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public HumanoidAnimator<DazedLatexEntity, LatexDazedModel> getAnimator(DazedLatexEntity entity) {
        return this.animator;
    }
}

