/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.model.armors;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.client.model.animations.ChangedAddonAnimationsPresets;
import net.foxyas.changedaddon.entity.advanced.LuminaraFlowerBeastEntity;
import net.ltxprogrammer.changed.client.renderer.animate.HumanoidAnimator;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.ArmorModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.ArmorModelSet;
import net.ltxprogrammer.changed.client.renderer.model.armor.LatexHumanoidArmorModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArmorLuminaraFlowerBeastModel<T extends ChangedEntity>
extends LatexHumanoidArmorModel<T, ArmorLuminaraFlowerBeastModel<T>> {
    public static final ArmorModelSet<ChangedEntity, ArmorLuminaraFlowerBeastModel<ChangedEntity>> MODEL_SET = ArmorModelSet.of((ResourceLocation)ChangedAddonMod.resourceLoc("armor_luminara_flower_beast"), ArmorLuminaraFlowerBeastModel::createArmorLayer, ArmorLuminaraFlowerBeastModel::new);
    private final ModelPart Head;
    private final ModelPart Torso;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Tail;
    private final ModelPart RightWing;
    private final ModelPart LeftWing;
    private final HumanoidAnimator<T, ArmorLuminaraFlowerBeastModel<T>> animator;
    public boolean shouldHaveBigWings = false;

    public ArmorLuminaraFlowerBeastModel(ModelPart modelPart, ArmorModel model) {
        super(modelPart, model);
        this.Head = modelPart.m_171324_("Head");
        this.Torso = modelPart.m_171324_("Torso");
        this.LeftLeg = modelPart.m_171324_("LeftLeg");
        this.RightLeg = modelPart.m_171324_("RightLeg");
        this.LeftArm = modelPart.m_171324_("LeftArm");
        this.RightArm = modelPart.m_171324_("RightArm");
        this.Tail = this.Torso.m_171324_("Tail");
        this.RightWing = this.Torso.m_171324_("RightWing");
        this.LeftWing = this.Torso.m_171324_("LeftWing");
        ModelPart tailPrimary = this.Tail.m_171324_("TailPrimary");
        ModelPart tailSecondary = tailPrimary.m_171324_("TailSecondary");
        ModelPart leftLowerLeg = this.LeftLeg.m_171324_("LeftLowerLeg");
        ModelPart leftFoot = leftLowerLeg.m_171324_("LeftFoot");
        ModelPart rightLowerLeg = this.RightLeg.m_171324_("RightLowerLeg");
        ModelPart rightFoot = rightLowerLeg.m_171324_("RightFoot");
        ModelPart leftWingRoot = this.LeftWing.m_171324_("leftWingRoot");
        ModelPart rightWingRoot = this.RightWing.m_171324_("rightWingRoot");
        this.animator = HumanoidAnimator.of((AdvancedHumanoidModel)this).hipOffset(-1.5f).addPreset(ChangedAddonAnimationsPresets.bigWingedDragonLike(this.Head, this.Torso, this.LeftArm, this.RightArm, this.Tail, List.of(tailPrimary, tailSecondary), this.LeftLeg, leftLowerLeg, leftFoot, leftFoot.m_171324_("LeftPad"), this.RightLeg, rightLowerLeg, rightFoot, rightFoot.m_171324_("RightPad"), leftWingRoot, leftWingRoot.m_171324_("leftSecondaries"), leftWingRoot.m_171324_("leftSecondaries").m_171324_("leftTertiaries"), rightWingRoot, rightWingRoot.m_171324_("rightSecondaries"), rightWingRoot.m_171324_("rightSecondaries").m_171324_("rightTertiaries")));
    }

    public static LayerDefinition createArmorLayer(ArmorModel layer) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        ArmorLuminaraFlowerBeastModel.addUnifiedLegs((PartDefinition)partdefinition, (ArmorModel)layer);
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, layer.dualDeformation), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition RightWing = Torso.m_171599_("RightWing", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-2.0f, (float)5.0f, (float)2.0f, (float)0.0f, (float)0.48f, (float)0.0f));
        PartDefinition rightWingRoot = RightWing.m_171599_("rightWingRoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        rightWingRoot.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(25, 23).m_171488_(-12.775f, -19.75f, 1.2f, 5.0f, 2.0f, 1.0f, layer.deformation.m_171469_(-0.5f)), PartPose.m_171423_((float)2.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition rightSecondaries = rightWingRoot.m_171599_("rightSecondaries", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-7.3f, (float)-7.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition rightTertiaries = rightSecondaries.m_171599_("rightTertiaries", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9599f));
        PartDefinition LeftWing = Torso.m_171599_("LeftWing", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)2.0f, (float)5.0f, (float)2.0f, (float)0.0f, (float)-0.48f, (float)0.0f));
        PartDefinition leftWingRoot = LeftWing.m_171599_("leftWingRoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        leftWingRoot.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(25, 23).m_171480_().m_171488_(7.775f, -19.75f, 1.2f, 5.0f, 2.0f, 1.0f, layer.deformation.m_171469_(-0.5f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition leftSecondaries = leftWingRoot.m_171599_("leftSecondaries", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)7.3f, (float)-7.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition leftTertiaries = leftSecondaries.m_171599_("leftTertiaries", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9599f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition TailPrimary = Tail.m_171599_("TailPrimary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        TailPrimary.m_171599_("Base_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, layer.altDeformation.m_171469_(-0.3f)), PartPose.m_171423_((float)0.0f, (float)0.4206f, (float)2.5285f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition TailSecondary = TailPrimary.m_171599_("TailSecondary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)3.5f));
        TailSecondary.m_171599_("Base_r2", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 6.0f, layer.altDeformation.m_171469_(-0.1f)), PartPose.m_171423_((float)0.0f, (float)1.2072f, (float)2.7389f, (float)2.7489f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, layer.dualDeformation), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, layer.dualDeformation), PartPose.m_171419_((float)-5.0f, (float)1.5f, (float)0.0f));
        partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, layer.dualDeformation).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)1.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void prepareVisibility(EquipmentSlot armorSlot, ItemStack item) {
        super.prepareVisibility(armorSlot, item);
        if (armorSlot == EquipmentSlot.LEGS) {
            ArmorLuminaraFlowerBeastModel.prepareUnifiedLegsForArmor((ItemStack)item, (ModelPart)this.LeftLeg, (ModelPart)this.RightLeg, (ModelPart)this.Tail);
        }
    }

    public void unprepareVisibility(EquipmentSlot armorSlot, ItemStack item) {
        super.unprepareVisibility(armorSlot, item);
        if (armorSlot == EquipmentSlot.LEGS) {
            ArmorLuminaraFlowerBeastModel.prepareUnifiedLegsForArmor((ItemStack)item, (ModelPart)this.LeftLeg, (ModelPart)this.RightLeg, (ModelPart)this.Tail);
        }
    }

    public void renderForSlot(T entity, RenderLayerParent<? super T, ?> parent, ItemStack stack, EquipmentSlot slot, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.scaleForSlot(parent, slot, poseStack);
        if (entity instanceof LuminaraFlowerBeastEntity) {
            LuminaraFlowerBeastEntity luminaraFlowerBeastEntity = (LuminaraFlowerBeastEntity)entity;
            this.Tail.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.LeftWing.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.RightWing.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.shouldHaveBigWings = luminaraFlowerBeastEntity.isHyperAwakened();
        }
        switch (slot) {
            case HEAD: {
                this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case CHEST: {
                if (!this.shouldHaveBigWings) {
                    this.Torso.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                } else {
                    this.setWingsVisibility(false);
                    this.Torso.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    this.setWingsVisibility(true);
                    this.renderBigWings(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                }
                this.LeftArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.RightArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case LEGS: {
                this.Torso.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.LeftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.RightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case FEET: {
                this.LeftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.RightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.m_85849_();
    }

    private void renderBigWings(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        poseStack.m_85836_();
        this.LeftWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
        poseStack.m_85836_();
        this.RightWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void setWingsVisibility(boolean wingsVisibility) {
        this.LeftWing.f_104207_ = wingsVisibility;
        this.RightWing.f_104207_ = wingsVisibility;
    }

    public boolean shouldPartTransfur(ModelPart part) {
        if (this.hiddenPartsByDefault().contains(part)) {
            return false;
        }
        return super.shouldPartTransfur(part);
    }

    public List<ModelPart> hiddenPartsByDefault() {
        return List.of(this.Tail, this.RightWing, this.LeftWing);
    }

    public void prepareMobModel(@NotNull T entity, float p_102862_, float p_102863_, float partialTicks) {
        super.prepareMobModel(entity, p_102862_, p_102863_, partialTicks);
        if (entity instanceof LuminaraFlowerBeastEntity) {
            LuminaraFlowerBeastEntity luminaraFlowerBeastEntity = (LuminaraFlowerBeastEntity)entity;
            this.LeftWing.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.RightWing.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.Tail.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.shouldHaveBigWings = luminaraFlowerBeastEntity.isHyperAwakened();
        }
    }

    public void prepareMobModel(HumanoidAnimator<T, ? extends EntityModel<T>> animator, T entity, float p_102862_, float p_102863_, float partialTicks) {
        super.prepareMobModel(animator, entity, p_102862_, p_102863_, partialTicks);
        if (entity instanceof LuminaraFlowerBeastEntity) {
            LuminaraFlowerBeastEntity luminaraFlowerBeastEntity = (LuminaraFlowerBeastEntity)entity;
            this.LeftWing.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.RightWing.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.Tail.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
            this.shouldHaveBigWings = luminaraFlowerBeastEntity.isHyperAwakened();
        }
    }

    public void setAllLimbsVisible(T entity, boolean visible) {
        super.setAllLimbsVisible(entity, visible);
        if (entity instanceof LuminaraFlowerBeastEntity) {
            LuminaraFlowerBeastEntity luminaraFlowerBeastEntity = (LuminaraFlowerBeastEntity)entity;
            this.LeftWing.f_104207_ = visible && luminaraFlowerBeastEntity.isAwakened();
            this.RightWing.f_104207_ = visible && luminaraFlowerBeastEntity.isAwakened();
            this.Tail.f_104207_ = luminaraFlowerBeastEntity.isAwakened();
        }
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity instanceof LuminaraFlowerBeastEntity) {
            LuminaraFlowerBeastEntity luminaraFlowerBeastEntity = (LuminaraFlowerBeastEntity)entity;
            this.LeftWing.f_104207_ &= luminaraFlowerBeastEntity.isAwakened();
            this.RightWing.f_104207_ &= luminaraFlowerBeastEntity.isAwakened();
            this.Tail.f_104207_ &= luminaraFlowerBeastEntity.isAwakened();
            this.shouldHaveBigWings = luminaraFlowerBeastEntity.isHyperAwakened();
        }
    }

    public HumanoidAnimator<T, ArmorLuminaraFlowerBeastModel<T>> getAnimator(T entity) {
        return this.animator;
    }

    @NotNull
    public ModelPart m_102851_(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public ModelPart getLeg(HumanoidArm leg) {
        return leg == HumanoidArm.LEFT ? this.LeftLeg : this.RightLeg;
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.Head;
    }

    public ModelPart getTorso() {
        return this.Torso;
    }
}

