/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.blockEntitys;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.foxyas.changedaddon.block.entity.InformantBlockEntity;
import net.foxyas.changedaddon.client.renderer.renderTypes.ChangedAddonRenderTypes;
import net.foxyas.changedaddon.mixins.client.renderer.LivingEntityRendererAccessor;
import net.ltxprogrammer.changed.client.renderer.AdvancedHumanoidRenderer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class InformantBlockEntityRenderer
implements BlockEntityRenderer<InformantBlockEntity> {
    private static final Map<TransfurVariant<?>, ChangedEntity> entityCache = new HashMap();

    public InformantBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    @ApiStatus.Internal
    public static ChangedEntity getDisplayEntity(TransfurVariant<?> tf) {
        if (tf == null) {
            return null;
        }
        return entityCache.computeIfAbsent(tf, var -> {
            assert (Minecraft.m_91087_().f_91073_ != null);
            ChangedEntity e = (ChangedEntity)tf.getEntityType().m_20615_((Level)Minecraft.m_91087_().f_91073_);
            if (e == null) {
                return null;
            }
            e.m_21557_(true);
            e.canUpdate(false);
            e.f_20885_ = 0.0f;
            e.f_20886_ = 0.0f;
            return e;
        });
    }

    public void render(@NotNull InformantBlockEntity informantBlockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, int overlay) {
        LivingEntityRendererAccessor livingEntityRendererAccessor;
        List<RenderLayer<LivingEntity, EntityModel<LivingEntity>>> layers;
        Level level = informantBlockEntity.m_58904_();
        if (level == null) {
            return;
        }
        TransfurVariant<?> tfVariant = informantBlockEntity.getDisplayTf();
        ChangedEntity entity = InformantBlockEntityRenderer.getDisplayEntity(tfVariant);
        if (entity == null) {
            return;
        }
        EntityRenderer entityRenderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        if (!(entityRenderer instanceof AdvancedHumanoidRenderer)) {
            return;
        }
        AdvancedHumanoidRenderer renderer = (AdvancedHumanoidRenderer)entityRenderer;
        assert (Minecraft.m_91087_().f_91074_ != null);
        entity.f_19797_ = Minecraft.m_91087_().f_91074_.f_19797_;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.75, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        float speed = 1.25f;
        float rotation = ((float)Minecraft.m_91087_().f_91074_.f_19797_ * speed + partialTick) % 360.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        AdvancedHumanoidModel model = (AdvancedHumanoidModel)renderer.m_7200_();
        ResourceLocation texture = renderer.m_5478_((Entity)entity);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(ChangedAddonRenderTypes.hologramCull(texture, true));
        float ageInTicks = (float)entity.f_19797_ + partialTick;
        model.m_6839_((LivingEntity)entity, 0.0f, 0.0f, partialTick);
        model.setupAnim(entity, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        model.m_7695_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (renderer instanceof LivingEntityRendererAccessor && (layers = (livingEntityRendererAccessor = (LivingEntityRendererAccessor)renderer).getLayers()) != null && !layers.isEmpty()) {
            layers.forEach(renderlayer -> renderlayer.m_6494_(poseStack, bufferSource, 0xF000F0, (Entity)entity, 0.0f, 0.0f, partialTick, ageInTicks, 0.0f, 0.0f));
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(@NotNull InformantBlockEntity p_112306_) {
        return true;
    }

    public boolean shouldRender(@NotNull InformantBlockEntity informantBlockEntity, @NotNull Vec3 vec3) {
        return informantBlockEntity.getDisplayTf() != null && super.m_142756_((BlockEntity)informantBlockEntity, vec3);
    }
}

