/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.util.ModelUtils;
import net.ltxprogrammer.changed.client.renderer.layers.FirstPersonLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ParticlesTrailsLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
extends RenderLayer<T, M>
implements FirstPersonLayer<T> {
    private static final Vector3f DEFAULT_OFFSET = new Vector3f(0.0f, -0.1f, 0.0f);
    private static final Vector3f WORLD_OFFSET = new Vector3f(0.0f, 0.85f, 0.0f);
    private static final Vec3 ENTITY_ROTATION = new Vec3(180.0, 0.0, 0.0);
    private final ParticleOptions[] particles;
    private float spawnProbability = 0.025f;
    private PoseStack poseStack = new PoseStack();

    public ParticlesTrailsLayer(RenderLayerParent<T, M> parent, ParticleOptions ... particle) {
        super(parent);
        this.particles = particle;
    }

    public ParticlesTrailsLayer(RenderLayerParent<T, M> parent, float spawnProbability, ParticleOptions ... particle) {
        super(parent);
        this.particles = particle;
        this.spawnProbability = spawnProbability;
    }

    public float getSpawnProbability() {
        return this.spawnProbability;
    }

    public void setSpawnProbability(float spawnProbability) {
        this.spawnProbability = spawnProbability;
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AdvancedHumanoidModel model = (AdvancedHumanoidModel)this.m_117386_();
        List<ModelPart> parts = this.getRelevantParts(model);
        ModelPart selectedPart = this.getRandomPart(parts, entity.m_21187_());
        Vec3 worldPos = this.getWorldPositionFromPart(entity, model, selectedPart);
        if (entity.m_21187_().nextFloat() <= this.spawnProbability && !Minecraft.m_91087_().m_91104_()) {
            this.spawnParticle(entity, selectedPart == model.m_5585_(), worldPos);
        }
    }

    private List<ModelPart> getRelevantParts(AdvancedHumanoidModel<?> model) {
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>(List.of(model.m_5585_(), model.getTorso()));
        parts.addAll(ModelUtils.getTailFromModelIfAny(model));
        parts.addAll(List.of(model.m_102851_(HumanoidArm.RIGHT), model.m_102851_(HumanoidArm.LEFT), model.getLeg(HumanoidArm.RIGHT), model.getLeg(HumanoidArm.LEFT)));
        return parts;
    }

    private ModelPart getRandomPart(List<ModelPart> parts, Random random) {
        return parts.get(random.nextInt(parts.size()));
    }

    private Vec3 getWorldPositionFromPart(T entity, AdvancedHumanoidModel<?> model, ModelPart part) {
        if (part == model.m_5585_()) {
            return FoxyasUtils.getRelativePositionEyes(entity, new Vec3(0.0, 0.0, (double)0.1f));
        }
        if (ModelUtils.getTailFromModelIfAny(model).contains(part)) {
            Vector3f offset = DEFAULT_OFFSET.m_122281_();
            offset.m_122272_(0.0f, 0.0f, 0.5f);
            return ModelUtils.getWorldSpaceFromModelPart(part, offset, WORLD_OFFSET, entity, Vec3.f_82478_, ENTITY_ROTATION, this.poseStack, false);
        }
        return ModelUtils.getWorldSpaceFromModelPart(part, DEFAULT_OFFSET, WORLD_OFFSET, entity, Vec3.f_82478_, ENTITY_ROTATION, this.poseStack, false);
    }

    private void spawnParticle(T entity, boolean isHead, Vec3 pos) {
        for (ParticleOptions particle : this.particles) {
            double dx = entity.m_21187_().nextDouble(isHead ? -0.5 : -0.25, isHead ? 0.5 : 0.25);
            double dy = entity.m_21187_().nextDouble(isHead ? -0.5 : -0.25, isHead ? 0.5 : 0.25);
            double dz = entity.m_21187_().nextDouble(isHead ? -0.5 : -0.25, isHead ? 0.5 : 0.25);
            entity.m_183503_().m_7106_(particle, pos.m_7096_() + dx, pos.m_7098_() + dy, pos.m_7094_() + dz, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public RenderType renderType() {
        return RenderType.m_110457_();
    }

    public void renderFirstPersonOnFace(PoseStack stack, MultiBufferSource bufferSource, int packedLight, T entity, Camera camera) {
        super.renderFirstPersonOnFace(stack, bufferSource, packedLight, entity, camera);
    }

    public void renderFirstPersonOnArms(PoseStack stack, MultiBufferSource bufferSource, int packedLight, T entity, HumanoidArm arm, PartPose armPose, PoseStack stackCorrector, float partialTick) {
        super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public void setPoseStack(PoseStack poseStack) {
        this.poseStack = poseStack;
    }
}

