/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers.features;

import com.mojang.blaze3d.vertex.PoseStack;
import net.foxyas.changedaddon.client.renderer.layers.features.RenderMode;
import net.foxyas.changedaddon.client.renderer.renderTypes.ChangedAddonRenderTypes;
import net.foxyas.changedaddon.init.ChangedAddonAbilities;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SonarOutlineLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final RenderLayerParent<T, M> parent;

    public SonarOutlineLayer(RenderLayerParent<T, M> parent) {
        super(parent);
        this.parent = parent;
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CustomSonarRenderable custom;
        if (SonarClientState.ticksToRenderEntities <= 0) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Entity camera = minecraft.f_91075_;
        if (camera == null || camera.m_20280_(livingEntity) > (double)SonarClientState.maxDistSqr) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (instance == null) {
            return;
        }
        if (!instance.hasAbility((AbstractAbility)ChangedAddonAbilities.SONAR.get())) {
            return;
        }
        float alpha = SonarClientState.getAlpha(partialTicks);
        if (alpha <= 0.01f) {
            return;
        }
        if (livingEntity instanceof CustomSonarRenderable && (custom = (CustomSonarRenderable)livingEntity).handleSonarRender(this, poseStack, buffer, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, alpha)) {
            return;
        }
        ChangedEntity changedEntity = instance.getChangedEntity();
        if (changedEntity instanceof CustomSonarRenderable && (custom = (CustomSonarRenderable)changedEntity).handleSonarRenderForCamera(this, (LivingEntity)livingEntity, poseStack, buffer, packedLight, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, alpha)) {
            return;
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (SonarClientState.renderMode == RenderMode.ECHO_LOCATION) {
            r = 1.0f;
            g = 1.0f;
            b = 0.2f;
        }
        RenderType outline = ChangedAddonRenderTypes.outlineWithTranslucencyCull(this.m_117347_((Entity)livingEntity));
        this.m_117386_().m_7695_(poseStack, buffer.m_6299_(outline), packedLight, OverlayTexture.f_118083_, r, g, b, alpha);
    }

    public static class SonarClientState {
        private static int ticksToRenderEntities = 0;
        private static int fadeInDuration = 10;
        private static int fadeOutDuration = 10;
        private static float maxDistSqr;
        private static RenderMode renderMode;
        private static int lastTicks;

        public static void setTicksToRenderEntities(int ticks, int iLastTicks, int fadeIn, int fadeOut, float maxDist, RenderMode mode) {
            ticksToRenderEntities = ticks;
            fadeInDuration = fadeIn;
            fadeOutDuration = fadeOut;
            maxDistSqr = maxDist * maxDist;
            renderMode = mode;
            lastTicks = iLastTicks;
        }

        public static void tick() {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
            if (instance == null) {
                ticksToRenderEntities = 0;
                return;
            }
            if (!instance.hasAbility((AbstractAbility)ChangedAddonAbilities.SONAR.get())) {
                ticksToRenderEntities = 0;
                return;
            }
            if (ticksToRenderEntities > 0) {
                --ticksToRenderEntities;
            }
        }

        public static float getAlpha(float partialTicks) {
            if (lastTicks <= 0) {
                return 0.0f;
            }
            int ticks = ticksToRenderEntities;
            if (ticks >= lastTicks - fadeInDuration) {
                float elapsed = (float)(lastTicks - ticks) + partialTicks;
                return Mth.m_14036_((float)(elapsed / (float)fadeInDuration), (float)0.0f, (float)1.0f);
            }
            if (ticks <= fadeOutDuration) {
                float remaining = (float)ticks - partialTicks;
                return Mth.m_14036_((float)(remaining / (float)fadeOutDuration), (float)0.0f, (float)1.0f);
            }
            return 1.0f;
        }

        public static boolean isActive() {
            return ticksToRenderEntities > 0;
        }

        public static RenderMode getRenderMode() {
            return renderMode;
        }

        public static float getMaxDistSqr() {
            return maxDistSqr;
        }

        public static void resetData() {
            ticksToRenderEntities = 0;
            fadeInDuration = 0;
            fadeOutDuration = 0;
            maxDistSqr = 0.0f;
            renderMode = RenderMode.SONAR;
            lastTicks = 0;
        }

        static {
            renderMode = RenderMode.SONAR;
            lastTicks = 0;
        }
    }

    public static interface CustomSonarRenderable {
        public boolean handleSonarRender(@NotNull SonarOutlineLayer<?, ?> var1, @NotNull PoseStack var2, @NotNull MultiBufferSource var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

        public boolean handleSonarRenderForCamera(@NotNull SonarOutlineLayer<?, ?> var1, @NotNull LivingEntity var2, @NotNull PoseStack var3, @NotNull MultiBufferSource var4, int var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);
    }
}

