/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.datagen;

import java.util.function.Function;
import net.foxyas.changedaddon.block.advanced.TimedKeypad;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.ltxprogrammer.changed.block.AbstractLatexBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateProvider
extends net.minecraftforge.client.model.generators.BlockStateProvider {
    private final Property<?>[] IGNORE_LATEX = new Property[]{AbstractLatexBlock.COVERED};

    public BlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "changed_addon", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.horizontalBlock(ChangedAddonBlocks.ADVANCED_CATALYZER, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.ADVANCED_UNIFUSER, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.CATALYZER, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.UNIFUSER, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.BLUE_WOLF_CRYSTAL_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.BLUE_WOLF_CRYSTAL_SMALL, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.CONTAINMENT_CONTAINER, new Property[]{BlockStateProperties.f_61362_});
        this.horizontalBlock(ChangedAddonBlocks.DARK_LATEX_PUDDLE, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.PAINITE_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.DEEPSLATE_PAINITE_ORE, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.DORMANT_DARK_LATEX, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.DORMANT_WHITE_LATEX, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.FOXTA_CAN, new Property[]{BlockStateProperties.f_61362_});
        this.simpleBlock(ChangedAddonBlocks.GENERATOR, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.GOO_CORE, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.INFORMANT_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.IRIDIUM_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.IRIDIUM_ORE, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.LATEX_INSULATOR, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.LITIX_CAMONIA_FLUID, new Property[]{BlockStateProperties.f_61422_});
        this.simpleBlock(ChangedAddonBlocks.LUMINARA_BLOOM, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.ORANGE_WOLF_CRYSTAL_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.ORANGE_WOLF_CRYSTAL_SMALL, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.REINFORCED_CROSS_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.REINFORCED_WALL, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.REINFORCED_WALL_CAUTION, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.REINFORCED_WALL_SILVER_STRIPED, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.REINFORCED_WALL_SILVER_TILED, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.SNEPSI_CAN, new Property[]{BlockStateProperties.f_61362_});
        this.simpleBlock(ChangedAddonBlocks.WALL_WHITE_CRACKED, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.WHITE_WOLF_CRYSTAL_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.WHITE_WOLF_CRYSTAL_SMALL, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.WOLF_PLUSH, new Property[0]);
        this.horizontalBlock(ChangedAddonBlocks.DARK_LATEX_WOLF_PLUSH, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.YELLOW_WOLF_CRYSTAL_BLOCK, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.YELLOW_WOLF_CRYSTAL_SMALL, new Property[0]);
        this.simpleBlock(ChangedAddonBlocks.POTTED_LUMINARA_BLOOM, new Property[0]);
        this.timedKeypad();
        this.pillarBlockWithVariants(ChangedAddonBlocks.WOLF_CRYSTAL_PILLAR, 2, 0);
        this.createMultiface(ChangedAddonBlocks.COVER_BLOCK, false);
        this.createMultiface(ChangedAddonBlocks.DARK_LATEX_COVER_BLOCK, false);
        this.createMultiface(ChangedAddonBlocks.WHITE_LATEX_COVER_BLOCK, false);
    }

    private Property<?>[] makeIgnore(Property<?> ... ignore) {
        Property<?>[] ignore1;
        if (ignore == null || ignore.length == 0) {
            ignore1 = this.IGNORE_LATEX;
        } else {
            ignore1 = new Property[ignore.length + 1];
            System.arraycopy(ignore, 0, ignore1, 0, ignore.length);
            ignore1[ignore1.length - 1] = AbstractLatexBlock.COVERED;
        }
        return ignore1;
    }

    private void timedKeypad() {
        ResourceLocation loc = this.blockLoc(ChangedAddonBlocks.TIMED_KEYPAD.getId());
        ModelFile.ExistingModelFile file = this.models().getExistingFile(loc);
        ModelFile.ExistingModelFile locked = this.models().getExistingFile(this.withSuffix(loc, "_locked"));
        this.getVariantBuilder((Block)ChangedAddonBlocks.TIMED_KEYPAD.get()).forAllStatesExcept(arg_0 -> BlockStateProvider.lambda$timedKeypad$0((ModelFile)file, (ModelFile)locked, arg_0), this.IGNORE_LATEX);
    }

    private ResourceLocation blockLoc(ResourceLocation loc) {
        return new ResourceLocation(loc.m_135827_(), "block/" + loc.m_135815_());
    }

    private ResourceLocation withSuffix(ResourceLocation loc, String suffix) {
        return new ResourceLocation(loc.m_135827_(), loc.m_135815_() + suffix);
    }

    private void simpleBlock(RegistryObject<? extends Block> block, Property<?> ... ignore) {
        ConfiguredModel[] model = new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.blockLoc(block.getId())))};
        ignore = this.makeIgnore(ignore);
        this.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> model, ignore);
    }

    private void horizontalBlock(RegistryObject<? extends HorizontalDirectionalBlock> block, Property<?> ... ignore) {
        ResourceLocation loc = this.blockLoc(block.getId());
        Block bl = (Block)block.get();
        ModelFile.ExistingModelFile file = this.models().getExistingFile(loc);
        ignore = this.makeIgnore(ignore);
        this.getVariantBuilder(bl).forAllStatesExcept(arg_0 -> BlockStateProvider.lambda$horizontalBlock$2((ModelFile)file, arg_0), ignore);
    }

    private void simpleWithVariants(RegistryObject<? extends Block> block, int variants, int itemModelIndex) {
        Block b = (Block)block.get();
        ResourceLocation loc = this.withSuffix(this.blockLoc(block.getId()), "/variant");
        ModelFile[] models = new ModelFile[variants];
        for (int i = 0; i < variants; ++i) {
            models[i] = this.models().getExistingFile(this.withSuffix(loc, "_" + i));
        }
        ConfiguredModel[] confModels = this.configure(models, ConfiguredModel::new);
        this.simpleBlock(b, confModels);
        this.simpleBlockItem(b, models[itemModelIndex]);
    }

    private void pillarBlockWithVariants(RegistryObject<? extends RotatedPillarBlock> pillar, int variants, int itemModelIndex) {
        RotatedPillarBlock block = (RotatedPillarBlock)pillar.get();
        ResourceLocation loc = this.withSuffix(this.blockLoc(pillar.getId()), "/variant");
        ModelFile[] models = new ModelFile[variants];
        for (int i = 0; i < variants; ++i) {
            models[i] = this.models().getExistingFile(this.withSuffix(loc, "_" + i));
        }
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Y -> this.configure(models, ConfiguredModel::new);
            case Direction.Axis.Z -> this.configure(models, model -> new ConfiguredModel(model, 90, 0, false));
            case Direction.Axis.X -> this.configure(models, model -> new ConfiguredModel(model, 90, 90, false));
        }, new Property[]{AbstractLatexBlock.COVERED});
        this.simpleBlockItem((Block)block, models[itemModelIndex]);
    }

    private ConfiguredModel[] configure(ModelFile[] models, Function<ModelFile, ConfiguredModel> config) {
        ConfiguredModel[] out = new ConfiguredModel[models.length];
        for (int i = 0; i < models.length; ++i) {
            out[i] = config.apply(models[i]);
        }
        return out;
    }

    private void createMultiface(RegistryObject<? extends Block> block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
        ResourceLocation loc = this.blockLoc(block.getId());
        BlockState state = ((Block)block.get()).m_49966_();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(loc);
        for (Direction dir : Direction.values()) {
            BooleanProperty prop = (BooleanProperty)PipeBlock.f_55154_.get(dir);
            if (!state.m_61138_((Property)prop)) continue;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(BlockStateProvider.getXRotation(dir)).rotationY(BlockStateProvider.getYRotation(dir)).addModel()).condition((Property)prop, (Comparable[])new Boolean[]{true});
        }
        ((ItemModelBuilder)this.itemModels().getBuilder(((Block)block.get()).m_5456_().getRegistryName().m_135815_())).parent((ModelFile)model);
    }

    private void createMultiface(RegistryObject<? extends Block> block, boolean generatedItem) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block.get());
        ResourceLocation loc = this.blockLoc(block.getId());
        BlockState state = ((Block)block.get()).m_49966_();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(loc);
        for (Direction dir : Direction.values()) {
            BooleanProperty prop = (BooleanProperty)PipeBlock.f_55154_.get(dir);
            if (!state.m_61138_((Property)prop)) continue;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(BlockStateProvider.getXRotation(dir)).rotationY(BlockStateProvider.getYRotation(dir)).addModel()).condition((Property)prop, (Comparable[])new Boolean[]{true});
        }
        if (generatedItem) {
            ((ItemModelBuilder)this.itemModels().getBuilder(((Block)block.get()).m_5456_().getRegistryName().m_135815_())).parent((ModelFile)model);
        }
    }

    private static int getXRotation(Direction dir) {
        return switch (dir) {
            case Direction.DOWN -> -90;
            case Direction.UP -> 90;
            default -> 0;
        };
    }

    private static int getYRotation(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> 180;
            case Direction.EAST -> 270;
            case Direction.WEST -> 90;
            default -> 0;
        };
    }

    private static /* synthetic */ ConfiguredModel[] lambda$horizontalBlock$2(ModelFile file, BlockState state) {
        return ConfiguredModel.builder().modelFile(file).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$timedKeypad$0(ModelFile file, ModelFile locked, BlockState state) {
        return new ConfiguredModel[]{new ConfiguredModel((Boolean)state.m_61143_((Property)TimedKeypad.POWERED) != false ? file : locked, 0, (int)((((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 270.0f) % 360.0f), false)};
    }
}

