/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.effect.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class ThunderSparkOption
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ThunderSparkOption> DESERIALIZER = new ParticleOptions.Deserializer<ThunderSparkOption>(){

        @NotNull
        public ThunderSparkOption fromNetwork(@NotNull ParticleType<ThunderSparkOption> type, FriendlyByteBuf buffer) {
            int energyCharge = buffer.readInt();
            return new ThunderSparkOption(type, energyCharge);
        }

        @NotNull
        public ThunderSparkOption fromCommand(@NotNull ParticleType<ThunderSparkOption> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            if (!reader.canRead()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().create();
            }
            try {
                int energyCharge = reader.readInt();
                return new ThunderSparkOption(type, energyCharge);
            }
            catch (Exception e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)reader);
            }
        }
    };
    private final int EnergyCharge;
    private final ParticleType<ThunderSparkOption> Type;

    public ThunderSparkOption(ParticleType<ThunderSparkOption> type, int energyCharge) {
        this.Type = type;
        this.EnergyCharge = energyCharge;
    }

    public static Codec<ThunderSparkOption> codec(ParticleType<ThunderSparkOption> type) {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("energy").forGetter(option -> option.EnergyCharge)).apply((Applicative)builder, energy -> new ThunderSparkOption(type, (int)energy)));
    }

    public int getEnergyCharge() {
        return this.EnergyCharge;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return this.Type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.EnergyCharge);
    }

    @NotNull
    public String m_5942_() {
        return "thunder_spark_" + this.EnergyCharge;
    }
}

