/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.advanced;

import java.util.Objects;
import java.util.Set;
import net.foxyas.changedaddon.entity.defaults.AbstractBasicOrganicChangedEntity;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.variants.VariantExtraStats;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.network.PlayMessages;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvaliEntity
extends AbstractBasicOrganicChangedEntity
implements VariantExtraStats {
    private static final EntityDataAccessor<Integer> PRIMARY_COLOR = SynchedEntityData.m_135353_(AvaliEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SECONDARY_COLOR = SynchedEntityData.m_135353_(AvaliEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STRIPES_COLOR = SynchedEntityData.m_135353_(AvaliEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SIZE_SCALE = SynchedEntityData.m_135353_(AvaliEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> STYLE_OF_COLOR = SynchedEntityData.m_135353_(AvaliEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public final Set<String> StyleTypes = Set.of("male", "female");

    public AvaliEntity(PlayMessages.SpawnEntity ignoredPacket, Level world) {
        this((EntityType<? extends ChangedEntity>)((EntityType)ChangedAddonEntities.AVALI.get()), world);
    }

    public AvaliEntity(EntityType<? extends ChangedEntity> type, Level level) {
        super(type, level);
    }

    @Override
    protected void setAttributes(AttributeMap attributes) {
        Objects.requireNonNull(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(3.0);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(20.0);
        attributes.m_22146_(Attributes.f_22277_).m_22100_(40.0);
        attributes.m_22146_(Attributes.f_22279_).m_22100_((double)1.1f);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_((double)0.85f);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(3.0);
        attributes.m_22146_(Attributes.f_22284_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22285_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22278_).m_22100_(0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PRIMARY_COLOR, (Object)Color3.WHITE.toInt());
        this.f_19804_.m_135372_(SECONDARY_COLOR, (Object)Color3.WHITE.toInt());
        this.f_19804_.m_135372_(STRIPES_COLOR, (Object)Color3.WHITE.toInt());
        this.f_19804_.m_135372_(SIZE_SCALE, (Object)Float.valueOf(0.8f));
        this.f_19804_.m_135372_(STYLE_OF_COLOR, (Object)"male");
    }

    public Color3 getDripColor() {
        return Color3.WHITE;
    }

    @Override
    public VariantExtraStats.FlyType getFlyType() {
        return VariantExtraStats.FlyType.ONLY_FALL;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.saveColors(tag);
    }

    public float getDimensionScale() {
        return ((Float)this.f_19804_.m_135370_(SIZE_SCALE)).floatValue();
    }

    public void setDimensionScale(float scale) {
        this.f_19804_.m_135381_(SIZE_SCALE, (Object)Float.valueOf(scale));
    }

    public CompoundTag savePlayerVariantData() {
        CompoundTag tag = super.savePlayerVariantData();
        this.saveColors(tag);
        return tag;
    }

    public void readPlayerVariantData(CompoundTag tag) {
        super.readPlayerVariantData(tag);
        this.readColors(tag);
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getDimensionScale());
    }

    public void saveColors(CompoundTag originalTag) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("PrimaryColor", this.getPrimaryColor().toInt());
        tag.m_128405_("SecondaryColor", this.getSecondaryColor().toInt());
        tag.m_128405_("StripesColor", this.getStripesColor().toInt());
        tag.m_128359_("StyleOfColor", this.getStyleOfColor());
        originalTag.m_128365_("TransfurColorData", (Tag)tag);
        originalTag.m_128350_("size_scale", this.getDimensionScale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readColors(tag);
    }

    public void readColors(CompoundTag originalTag) {
        CompoundTag tag;
        if (originalTag.m_128441_("size_scale")) {
            this.setDimensionScale(originalTag.m_128457_("size_scale"));
        }
        if ((tag = originalTag.m_128469_("TransfurColorData")).m_128441_("PrimaryColor")) {
            this.setPrimaryColor(Color3.fromInt((int)tag.m_128451_("PrimaryColor")));
        }
        if (tag.m_128441_("SecondaryColor")) {
            this.setSecondaryColor(Color3.fromInt((int)tag.m_128451_("SecondaryColor")));
        }
        if (tag.m_128441_("StripesColor")) {
            this.setStripesColor(Color3.fromInt((int)tag.m_128451_("StripesColor")));
        }
        if (tag.m_128441_("StyleOfColor")) {
            this.setStyleOfColor(tag.m_128461_("StyleOfColor"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.getStyleOfColor().equals("male") && !this.getStyleOfColor().equals("female")) {
            this.setStyleOfColor("male");
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.setPrimaryColor(Color3.fromInt((int)this.f_19796_.nextInt(0, 0x7FFFFFFE)));
        this.setSecondaryColor(Color3.fromInt((int)this.f_19796_.nextInt(0, 0x7FFFFFFE)));
        this.setStripesColor(Color3.fromInt((int)this.f_19796_.nextInt(0, 0x7FFFFFFE)));
        this.setStyleOfColor(this.f_19796_.nextBoolean() ? "male" : "female");
        return super.m_6518_(world, difficulty, reason, data, tag);
    }

    public Color3 getColor(int layer) {
        return switch (layer) {
            case 1 -> this.getSecondaryColor();
            case 2 -> this.getStripesColor();
            default -> this.getPrimaryColor();
        };
    }

    public Color3 getPrimaryColor() {
        return Color3.fromInt((int)((Integer)this.f_19804_.m_135370_(PRIMARY_COLOR)));
    }

    public void setPrimaryColor(Color3 color) {
        this.f_19804_.m_135381_(PRIMARY_COLOR, (Object)color.toInt());
    }

    public void setColor(int layer, Color3 color3) {
        switch (layer) {
            case 1: {
                this.setSecondaryColor(color3);
                break;
            }
            case 2: {
                this.setStripesColor(color3);
                break;
            }
            default: {
                this.setPrimaryColor(color3);
            }
        }
    }

    public Color3 getSecondaryColor() {
        return Color3.fromInt((int)((Integer)this.f_19804_.m_135370_(SECONDARY_COLOR)));
    }

    public void setSecondaryColor(Color3 color) {
        this.f_19804_.m_135381_(SECONDARY_COLOR, (Object)color.toInt());
    }

    public Color3 getStripesColor() {
        return Color3.fromInt((int)((Integer)this.f_19804_.m_135370_(STRIPES_COLOR)));
    }

    public void setStripesColor(Color3 color) {
        this.f_19804_.m_135381_(STRIPES_COLOR, (Object)color.toInt());
    }

    public String getStyleOfColor() {
        return (String)this.f_19804_.m_135370_(STYLE_OF_COLOR);
    }

    public void setStyleOfColor(String style) {
        this.f_19804_.m_135381_(STYLE_OF_COLOR, (Object)style);
    }

    public static enum SizeScaling implements IExtensibleEnum
    {
        NORMAL(0.8f),
        TALL(0.9f),
        VERY_TALL(1.0f);

        private final float scale;

        private SizeScaling(float size) {
            this.scale = size;
        }

        public static SizeScaling create(String name, float scale) {
            throw new NotImplementedException("Not extended");
        }

        public float getScale() {
            return this.scale;
        }
    }
}

