/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.advanced;

import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonGameRules;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.HairStyle;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurMode;
import net.ltxprogrammer.changed.entity.UseItemMode;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class DazedLatexEntity
extends ChangedEntity {
    private static final EntityDataAccessor<Boolean> DATA_PUDDLE_MORPHED = SynchedEntityData.m_135353_(DazedLatexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_REPLICATION_TIMES = SynchedEntityData.m_135353_(DazedLatexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(new ResourceLocation("plains"));
    public static UseItemMode PuddleForm = UseItemMode.create((String)"PuddleForm", (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
    public boolean willTransfurTarget = false;
    public boolean wasMorphed = false;

    public DazedLatexEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<DazedLatexEntity>)((EntityType)ChangedAddonEntities.DAZED_LATEX.get()), world);
    }

    public DazedLatexEntity(EntityType<DazedLatexEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.setAttributes(this.m_21204_());
        this.m_21557_(false);
        this.m_21530_();
    }

    @SubscribeEvent
    public static void addLivingEntityToBiomes(BiomeLoadingEvent event) {
        if (SPAWN_BIOMES.contains(event.getName())) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)ChangedAddonEntities.DAZED_LATEX.get(), 125, 1, 4));
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ChangedAddonEntities.DAZED_LATEX.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DazedLatexEntity::canSpawnNear);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor p_33009_, BlockPos p_33010_, Random p_33011_) {
        if (p_33009_.m_45517_(LightLayer.SKY, p_33010_) > p_33011_.nextInt(32)) {
            return false;
        }
        if (p_33009_.m_45517_(LightLayer.BLOCK, p_33010_) > 5) {
            return false;
        }
        int i = p_33009_.m_6018_().m_46470_() ? p_33009_.m_46849_(p_33010_, 10) : p_33009_.m_46803_(p_33010_);
        return i <= p_33011_.nextInt(8);
    }

    private static boolean canSpawnNear(EntityType<DazedLatexEntity> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (!DazedLatexEntity.isDarkEnoughToSpawn(world, pos, random)) {
            return false;
        }
        if (!world.m_204166_(pos).m_203656_(Tags.Biomes.IS_PLAINS)) {
            return false;
        }
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        if (!blockBelow.m_60804_((BlockGetter)world, pos.m_7495_()) || !blockBelow.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP)) {
            return false;
        }
        AABB checkArea = new AABB(pos).m_82400_(32.0);
        return world.m_46847_(checkArea).anyMatch(state -> state.m_60713_((Block)ChangedAddonBlocks.GOO_CORE.get()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder.m_22268_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get(), 0.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PUDDLE_MORPHED, (Object)false);
        this.f_19804_.m_135372_(DATA_REPLICATION_TIMES, (Object)0);
    }

    public boolean isMorphed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PUDDLE_MORPHED);
    }

    public void setMorphed(boolean morphed) {
        this.f_19804_.m_135381_(DATA_PUDDLE_MORPHED, (Object)morphed);
    }

    public int getReplicationTimes() {
        return (Integer)this.f_19804_.m_135370_(DATA_REPLICATION_TIMES);
    }

    public void setReplicationTimes(int replicationTimes) {
        this.f_19804_.m_135381_(DATA_REPLICATION_TIMES, (Object)replicationTimes);
    }

    public void subReplicationTimes(int replicationTimes) {
        this.f_19804_.m_135381_(DATA_REPLICATION_TIMES, (Object)(this.getReplicationTimes() - replicationTimes));
    }

    public void addReplicationTimes(int replicationTimes) {
        this.f_19804_.m_135381_(DATA_REPLICATION_TIMES, (Object)(this.getReplicationTimes() + replicationTimes));
    }

    protected void setAttributes(AttributeMap attributes) {
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get()), 3.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22276_), 26.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22277_), 40.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22279_), 1.075f);
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()), 1.025f);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22281_), 3.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22284_), 0.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22285_), 0.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22278_), 0.0);
    }

    protected void setMorphedAttributes(AttributeMap attributes) {
        this.safeMulBaseValue(attributes.m_22146_((Attribute)ForgeMod.ATTACK_RANGE.get()), 0.5);
        this.safeMulBaseValue(attributes.m_22146_((Attribute)ForgeMod.REACH_DISTANCE.get()), 0.5);
    }

    protected void safeSetBaseValue(@Nullable AttributeInstance instance, double value) {
        if (instance != null) {
            instance.m_22100_(value);
        }
    }

    protected void safeMulBaseValue(@Nullable AttributeInstance instance, double value) {
        if (instance != null) {
            instance.m_22100_(instance.m_22115_() * value);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Morphed")) {
            this.setMorphed(tag.m_128471_("Morphed"));
        }
        if (tag.m_128441_("ReplicationTimes")) {
            this.setReplicationTimes(tag.m_128451_("ReplicationTimes"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Morphed", this.isMorphed());
        tag.m_128405_("ReplicationTimes", this.getReplicationTimes());
    }

    public float getEyeHeightMul() {
        if (this.isMorphed()) {
            return 0.4f;
        }
        return super.getEyeHeightMul();
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions core = super.m_6972_(pose);
        if (this.isMorphed()) {
            return EntityDimensions.m_20395_((float)(core.f_20377_ - 0.05f), (float)(core.f_20378_ - 1.25f));
        }
        return core;
    }

    public UseItemMode getItemUseMode() {
        if (this.isMorphed()) {
            return PuddleForm;
        }
        return super.getItemUseMode();
    }

    public boolean tryTransfurTarget(Entity entity) {
        return super.tryTransfurTarget(entity);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.isMorphed() && !this.wasMorphed) {
            this.setMorphedAttributes(this.m_21204_());
            this.wasMorphed = true;
            IAbstractChangedEntity.forEitherSafe((Entity)this.maybeGetUnderlying()).map(IAbstractChangedEntity::getTransfurVariantInstance).ifPresent(TransfurVariantInstance::refreshAttributes);
        } else if (!this.isMorphed() && this.wasMorphed) {
            this.setAttributes(this.m_21204_());
            this.wasMorphed = false;
            IAbstractChangedEntity.forEitherSafe((Entity)this.maybeGetUnderlying()).map(IAbstractChangedEntity::getTransfurVariantInstance).ifPresent(TransfurVariantInstance::refreshAttributes);
        }
    }

    public Color3 getHairColor(int i) {
        return Color3.getColor((String)"#E5E5E5");
    }

    public int m_146891_() {
        return 700;
    }

    public LatexType getLatexType() {
        return LatexType.NEUTRAL;
    }

    public TransfurMode getTransfurMode() {
        if (this.getReplicationTimes() > 0) {
            if (this.willTransfurTarget) {
                this.subReplicationTimes(1);
            }
            return TransfurMode.REPLICATION;
        }
        return TransfurMode.ABSORPTION;
    }

    public HairStyle getDefaultHairStyle() {
        HairStyle Hair = (HairStyle)HairStyle.BALD.get();
        Hair = this.f_19853_.f_46441_.nextInt(10) > 5 ? (HairStyle)HairStyle.SHORT_MESSY.get() : (HairStyle)HairStyle.BALD.get();
        return Hair;
    }

    @Nullable
    public List<HairStyle> getValidHairStyles() {
        return HairStyle.Collection.MALE.getStyles();
    }

    public Color3 getDripColor() {
        Color3 color = Color3.getColor((String)"#ffffff");
        color = this.f_19853_.f_46441_.nextInt(10) > 5 ? Color3.getColor((String)"#ffffff") : Color3.getColor((String)"#CFCFCF");
        return color;
    }

    public Color3 getTransfurColor(TransfurCause cause) {
        return Color3.getColor((String)"#CFCFCF");
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this){

            public boolean m_8036_() {
                Level world = DazedLatexEntity.this.f_19853_;
                return super.m_8036_() && world.m_46469_().m_46207_(ChangedAddonGameRules.DO_DAZED_LATEX_BURN);
            }
        });
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6049_() {
        return super.m_6049_();
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    @Mod.EventBusSubscriber(modid="changed_addon")
    public static class WhenTransfuredEntity {
        @SubscribeEvent
        public static void WhenDazedTransfur(ProcessTransfur.TransfurAttackEvent event) {
            LivingEntity target = event.target;
            IAbstractChangedEntity source = event.context.source;
            if (source == null) {
                return;
            }
            ChangedEntity changedEntity = source.getChangedEntity();
            if (changedEntity instanceof DazedLatexEntity) {
                DazedLatexEntity dazedLatexEntity = (DazedLatexEntity)changedEntity;
                dazedLatexEntity.willTransfurTarget = ProcessTransfur.willTransfur((LivingEntity)target, (float)((float)dazedLatexEntity.m_21133_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())));
            }
        }
    }
}

