/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.bosses;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.foxyas.changedaddon.abilities.DodgeAbilityInstance;
import net.foxyas.changedaddon.entity.customHandle.BossMusicTheme;
import net.foxyas.changedaddon.entity.customHandle.Exp9AttacksHandle;
import net.foxyas.changedaddon.entity.goals.exp9.InductionCoilGoal;
import net.foxyas.changedaddon.entity.goals.exp9.LightningComboAttackGoal;
import net.foxyas.changedaddon.entity.goals.exp9.StaticDischargeGoal;
import net.foxyas.changedaddon.entity.goals.exp9.SummonLightningGoal;
import net.foxyas.changedaddon.entity.goals.exp9.ThunderDiveGoal;
import net.foxyas.changedaddon.entity.goals.exp9.ThunderStrikeGoal;
import net.foxyas.changedaddon.entity.goals.generic.BreakBlocksAroundGoal;
import net.foxyas.changedaddon.entity.goals.generic.attacks.SimpleAntiFlyingAttack;
import net.foxyas.changedaddon.entity.interfaces.BossWithMusic;
import net.foxyas.changedaddon.entity.interfaces.CustomPatReaction;
import net.foxyas.changedaddon.event.TransfurEvents;
import net.foxyas.changedaddon.init.ChangedAddonAbilities;
import net.foxyas.changedaddon.init.ChangedAddonCriteriaTriggers;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonGameRules;
import net.foxyas.changedaddon.init.ChangedAddonParticleTypes;
import net.foxyas.changedaddon.util.ColorUtil;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.Emote;
import net.ltxprogrammer.changed.entity.EyeStyle;
import net.ltxprogrammer.changed.entity.HairStyle;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.entity.PowderSnowWalkable;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.TransfurMode;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedParticles;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Experiment009BossEntity
extends ChangedEntity
implements BossWithMusic,
CustomPatReaction,
PowderSnowWalkable {
    private static final EntityDataAccessor<Boolean> PHASE2 = SynchedEntityData.m_135353_(Experiment009BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PHASE3 = SynchedEntityData.m_135353_(Experiment009BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_6);
    private boolean shouldBleed;

    public Experiment009BossEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Experiment009BossEntity>)((EntityType)ChangedAddonEntities.EXPERIMENT_009_BOSS.get()), world);
    }

    public Experiment009BossEntity(EntityType<Experiment009BossEntity> type, Level world) {
        super(type, world);
        this.setAttributes(this.m_21204_());
        this.f_21364_ = 3000;
        this.m_21557_(false);
        this.m_21530_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder.m_22268_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get(), 0.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 425.0);
        builder = builder.m_22268_(Attributes.f_22284_, 12.5);
        builder = builder.m_22268_(Attributes.f_22281_, 15.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.3);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        return builder;
    }

    public EntityDamageSource getThunderDmg() {
        return new EntityDamageSource(DamageSource.f_19306_.m_19385_(), (Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE2, (Object)false);
        this.f_19804_.m_135372_(PHASE3, (Object)false);
    }

    protected void setAttributes(AttributeMap attributes) {
        Objects.requireNonNull(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(6.0);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(425.0);
        attributes.m_22146_(Attributes.f_22277_).m_22100_(64.0);
        attributes.m_22146_(Attributes.f_22279_).m_22100_(1.15);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(1.1);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(8.0);
        attributes.m_22146_(Attributes.f_22284_).m_22100_(12.5);
        attributes.m_22146_(Attributes.f_22285_).m_22100_(6.0);
        attributes.m_22146_(Attributes.f_22278_).m_22100_(0.25);
        attributes.m_22146_(Attributes.f_22282_).m_22100_(0.85);
    }

    @Override
    public boolean ShouldPlayMusic() {
        return this.m_6084_();
    }

    @Override
    @NotNull
    public BossMusicTheme BossMusicTheme() {
        return BossMusicTheme.EXP9;
    }

    public boolean m_7998_(@NotNull Entity EntityIn, boolean force) {
        if (EntityIn instanceof Boat || EntityIn instanceof Minecart) {
            return false;
        }
        return super.m_7998_(EntityIn, force);
    }

    public double m_142593_(LivingEntity target) {
        if (target.m_20188_() > this.m_20188_() + 1.0) {
            return super.m_142593_(target) * 1.5;
        }
        return super.m_142593_(target);
    }

    public Color3 getHairColor(int i) {
        return Color3.getColor((String)"#F1F1F1");
    }

    public int m_146891_() {
        return 1000;
    }

    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        return livingEntity instanceof Player || livingEntity instanceof ServerPlayer || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("changed:humanoids")));
    }

    public LatexType getLatexType() {
        return LatexType.NEUTRAL;
    }

    public TransfurMode getTransfurMode() {
        return TransfurMode.NONE;
    }

    public HairStyle getDefaultHairStyle() {
        return (HairStyle)HairStyle.BALD.get();
    }

    @Nullable
    public List<HairStyle> getValidHairStyles() {
        return HairStyle.Collection.MALE.getStyles();
    }

    public Color3 getDripColor() {
        return Color3.getColor((String)"#E2E2E2");
    }

    public Color3 getTransfurColor(TransfurCause cause) {
        Color3 firstColor = Color3.WHITE;
        Color3 secondColor = Color3.getColor((String)"#E9E9E9");
        return ColorUtil.lerpTFColor(firstColor, secondColor, this.getUnderlyingPlayer());
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(20, (Goal)new SimpleAntiFlyingAttack((Mob)this, (IntProvider)UniformInt.m_146622_((int)60, (int)100), 3.0f, 8.0f, 8.0f, 10));
        this.f_21345_.m_25352_(6, (Goal)new Exp9AttacksHandle.BurstAttack(this));
        this.f_21345_.m_25352_(10, (Goal)new Exp9AttacksHandle.ThunderStorm(this, (IntProvider)UniformInt.m_146622_((int)60, (int)100)));
        this.f_21345_.m_25352_(5, (Goal)new ThunderStrikeGoal((PathfinderMob)this, (IntProvider)UniformInt.m_146622_((int)80, (int)120), 1.5, 200));
        this.f_21345_.m_25352_(10, (Goal)new ThunderDiveGoal((PathfinderMob)this, (IntProvider)UniformInt.m_146622_((int)60, (int)100), 1.5, 6.0, 1.0, 0.5, 4.0f));
        this.f_21345_.m_25352_(5, (Goal)new SummonLightningGoal((PathfinderMob)this, (IntProvider)UniformInt.m_146622_((int)90, (int)150), (IntProvider)UniformInt.m_146622_((int)2, (int)4), (IntProvider)UniformInt.m_146622_((int)60, (int)100), (IntProvider)UniformInt.m_146622_((int)80, (int)100), (FloatProvider)ConstantFloat.m_146458_((float)10.0f)));
        this.f_21345_.m_25352_(5, (Goal)new StaticDischargeGoal((PathfinderMob)this, (IntProvider)UniformInt.m_146622_((int)75, (int)125), 4.0f, (IntProvider)UniformInt.m_146622_((int)30, (int)50), 8.0f, (FloatProvider)UniformFloat.m_146605_((float)8.0f, (float)12.0f)));
        this.f_21345_.m_25352_(1, (Goal)new InductionCoilGoal((PathfinderMob)this, (IntProvider)UniformInt.m_146622_((int)100, (int)150), 20.0f, (IntProvider)UniformInt.m_146622_((int)60, (int)80), (FloatProvider)UniformFloat.m_146605_((float)3.0f, (float)5.0f)));
        this.f_21345_.m_25352_(5, (Goal)new LightningComboAttackGoal((PathfinderMob)this, (IntProvider)UniformInt.m_146622_((int)150, (int)200), (IntProvider)UniformInt.m_146622_((int)3, (int)6), (IntProvider)UniformInt.m_146622_((int)20, (int)40), (FloatProvider)UniformFloat.m_146605_((float)6.0f, (float)8.0f)));
        this.f_21345_.m_25352_(10, (Goal)new BreakBlocksAroundGoal((Mob)this));
    }

    public void variantTick(Level level) {
        Player playerInControl;
        TransfurVariantInstance transfurVariantInstance;
        super.variantTick(level);
        if (this.getUnderlyingPlayer() != null && (transfurVariantInstance = ProcessTransfur.getPlayerTransfurVariant((Player)(playerInControl = this.getUnderlyingPlayer()))) != null) {
            DodgeAbilityInstance dodgeAbilityInstance;
            if (playerInControl.m_183503_().m_6106_().m_5470_().m_46207_(ChangedAddonGameRules.NEED_PERMISSION_FOR_BOSS_TRANSFUR) && !TransfurEvents.getPlayerVars((LivingEntity)playerInControl).Exp009TransfurAllowed) {
                ProcessTransfur.setPlayerTransfurVariant((Player)playerInControl, (TransfurVariant)((TransfurVariant)ChangedAddonTransfurVariants.EXPERIMENT_009.get()), (TransfurContext)TransfurContext.hazard((TransfurCause)TransfurCause.GRAB_ABSORB), (float)1.0f, (boolean)false);
            }
            if ((dodgeAbilityInstance = (DodgeAbilityInstance)transfurVariantInstance.getAbilityInstance((AbstractAbility)ChangedAddonAbilities.DODGE.get())) != null && dodgeAbilityInstance.getMaxDodgeAmount() < 10) {
                dodgeAbilityInstance.setMaxDodgeAmount(10);
                dodgeAbilityInstance.setDodgeAmount(10);
            }
        }
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return super.m_6049_();
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        EntityDamageSource entityDamageSource;
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19314_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source.m_19385_().equals("trident")) {
            Entity entity;
            if (this.m_183503_().f_46441_.nextFloat() <= 0.25f && (entity = source.m_7639_()) instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)new TranslatableComponent("changed_addon.entity_dialogues.exp9.reaction.range_attacks"), true);
            }
            return super.m_6469_(source, amount * 0.5f);
        }
        if (source == DamageSource.f_19321_) {
            return false;
        }
        if (source == DamageSource.f_19323_) {
            return false;
        }
        if (source == DamageSource.f_19320_) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        if (source == DamageSource.f_19310_) {
            Exp9AttacksHandle.TeleportAttack.Teleport(this, (LivingEntity)(this.m_5448_() == null ? this.m_183503_().m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 32.0, true) : this.m_5448_()));
            return false;
        }
        if (source.m_19360_()) {
            Entity entity;
            if (this.m_183503_().f_46441_.nextFloat() <= 0.25f && (entity = source.m_7639_()) instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)new TranslatableComponent("changed_addon.entity_dialogues.exp9.reaction.range_attacks"), true);
            }
            return super.m_6469_(source, amount * 0.5f);
        }
        if (source instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)source).m_19403_()) {
            return super.m_6469_(source, 0.0f);
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        this.getBasicPlayerInfo().setSize(1.0f);
        this.getBasicPlayerInfo().setEyeStyle(EyeStyle.TALL);
        return retval;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        float maxHealth = this.m_21233_();
        float currentHealth = this.m_21223_();
        float healthRatio = currentHealth / maxHealth;
        if (healthRatio <= 0.4f) {
            this.bossInfo.m_142711_(healthRatio / 0.4f);
            if (this.bossInfo.m_18863_() != BossEvent.BossBarOverlay.NOTCHED_10) {
                this.bossInfo.m_5648_(BossEvent.BossBarOverlay.NOTCHED_10);
            }
        } else {
            this.bossInfo.m_142711_(healthRatio);
            if (this.bossInfo.m_18863_() != BossEvent.BossBarOverlay.NOTCHED_6) {
                this.bossInfo.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
            }
        }
    }

    public boolean isPhase3() {
        return (Boolean)this.f_19804_.m_135370_(PHASE3);
    }

    public void setPhase3(boolean set) {
        this.f_19804_.m_135381_(PHASE3, (Object)set);
    }

    public boolean isPhase2() {
        return (Boolean)this.f_19804_.m_135370_(PHASE2);
    }

    public void setPhase2(boolean set) {
        this.f_19804_.m_135381_(PHASE2, (Object)set);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Phase2")) {
            this.setPhase2(tag.m_128471_("Phase2"));
        }
        if (tag.m_128441_("Phase3")) {
            this.setPhase3(tag.m_128471_("Phase3"));
        }
        if (tag.m_128441_("Bleeding")) {
            this.shouldBleed = tag.m_128471_("Bleeding");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Phase2", this.isPhase2());
        tag.m_128379_("Phase3", this.isPhase3());
        tag.m_128379_("Bleeding", this.shouldBleed);
    }

    public boolean isBleeding() {
        return this.shouldBleed;
    }

    protected void m_142540_(@NotNull MobEffectInstance mobEffectInstance, @Nullable Entity entity) {
        super.m_142540_(mobEffectInstance, entity);
        if (this.getUnderlyingPlayer() == null && mobEffectInstance.m_19544_() == MobEffects.f_19601_ && this.isBleeding()) {
            this.shouldBleed = false;
        }
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        EntityDamageSource entityDamageSource;
        if (damageSource instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)damageSource).m_7640_() != null) {
            this.m_5496_(SoundEvents.f_12313_, 1.0f, 1.0f);
            for (int theta = 0; theta < 360; theta += 25) {
                double angleTheta = Math.toRadians(theta);
                for (int phi = 0; phi <= 180; phi += 25) {
                    double anglePhi = Math.toRadians(phi);
                    double x = this.m_20185_() + Math.sin(anglePhi) * Math.cos(angleTheta) * 4.0;
                    double y = this.m_20186_() + Math.cos(anglePhi) * 4.0;
                    double z = this.m_20189_() + Math.sin(anglePhi) * Math.sin(angleTheta) * 4.0;
                    Vec3 pos = new Vec3(x, y, z);
                    ParticlesUtil.sendParticles(entityDamageSource.m_7640_().m_183503_(), (ParticleOptions)ParticleTypes.f_175830_, pos, 0.1f, 0.1f, 0.1f, 5, 0.025f);
                }
            }
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
        }
        super.m_6667_(damageSource);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.getUnderlyingPlayer() == null) {
            if (this.shouldBleed && this.computeHealthRatio() / 0.4f > 0.25f && this.f_19797_ % 4 == 0) {
                this.m_21153_(this.m_21223_() - 0.25f);
            }
            if ((double)this.m_21187_().nextFloat() < 1.0 - Math.min(0.95, (double)this.computeHealthRatio())) {
                if (this.isPhase2()) {
                    if (this.shouldBleed) {
                        ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ParticleTypes.f_175830_, this.m_146892_().m_82492_(0.0, (double)this.m_21187_().nextFloat(this.m_20192_()), 0.0), 0.3f, 0.25f, 0.3f, 15, 0.01f);
                        ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ChangedAddonParticleTypes.thunderSpark(1), this.m_146892_().m_82492_(0.0, (double)this.m_21187_().nextFloat(this.m_20192_()), 0.0), 0.3f, 0.25f, 0.3f, 15, 0.05f);
                    } else {
                        if ((double)this.m_21187_().nextFloat() > 0.95) {
                            ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ParticleTypes.f_175830_, this.m_146892_().m_82492_(0.0, (double)this.m_21187_().nextFloat(this.m_20192_()), 0.0), 0.3f, 0.25f, 0.3f, 10, 0.01f);
                        }
                        ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ChangedAddonParticleTypes.thunderSpark(1), this.m_146892_().m_82492_(0.0, (double)this.m_21187_().nextFloat(this.m_20192_()), 0.0), 0.25f, 0.25f, 0.25f, 10, 1.0f);
                    }
                } else {
                    ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ChangedAddonParticleTypes.thunderSpark(1), this.m_146892_().m_82492_(0.0, (double)this.m_21187_().nextFloat(this.m_20192_()), 0.0), 0.25f, 0.25f, 0.25f, 5, 1.0f);
                }
            }
            if (this.isPhase2()) {
                if (this.computeHealthRatio() <= 0.4f) {
                    this.removeStatModifiers();
                    this.applyStatModifierAllOutPhase();
                    this.shouldBleed = true;
                    this.setPhase3(true);
                } else {
                    this.applyStatModifier((LivingEntity)this, 1.5);
                }
            } else {
                this.removeStatModifiers();
            }
            this.updateSwimmingMovement();
            this.setSpeed(this);
            this.crawlingSystem(this.m_5448_());
        }
    }

    public void removeStatModifiers() {
        this.removeModifierUUID((LivingEntity)this, Attributes.f_22281_, "a06083b0-291d-4a72-85de-73bd93ffb736");
        this.removeModifierUUID((LivingEntity)this, Attributes.f_22284_, "a06083b0-291d-4a72-85de-73bd93ffb737");
        this.removeModifierUUID((LivingEntity)this, Attributes.f_22285_, "a06083b0-291d-4a72-85de-73bd93ffb738");
        this.removeModifierUUID((LivingEntity)this, Attributes.f_22278_, "a06083b0-291d-4a72-85de-73bd93ffb739");
    }

    public void removeStatModifiers(LivingEntity entity) {
        this.removeModifierUUID(entity, Attributes.f_22281_, "AttackMultiplier");
        this.removeModifierUUID(entity, Attributes.f_22284_, "ArmorMultiplier");
        this.removeModifierUUID(entity, Attributes.f_22285_, "ArmorToughnessMultiplier");
        this.removeModifierUUID(entity, Attributes.f_22278_, "KnockbackResistanceMultiplier");
    }

    private void removeModifier(LivingEntity entity, Attribute attribute, String modifierName) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            for (AttributeModifier modifier : instance.m_22122_()) {
                if (!modifier.m_22214_().equals(modifierName)) continue;
                instance.m_22130_(modifier);
                break;
            }
        }
    }

    private void removeModifierUUID(LivingEntity entity, Attribute attribute, String uuid) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            for (AttributeModifier modifier : instance.m_22122_()) {
                if (!modifier.m_22209_().equals(UUID.fromString(uuid))) continue;
                instance.m_22130_(modifier);
                break;
            }
        }
    }

    public void applyStatModifier(LivingEntity entity, double multiplier) {
        this.applyModifierIfAbsent(entity, Attributes.f_22281_, "a06083b0-291d-4a72-85de-73bd93ffb736", "AttackMultiplier", multiplier - 1.0);
        this.applyModifierIfAbsent(entity, Attributes.f_22284_, "a06083b0-291d-4a72-85de-73bd93ffb737", "ArmorMultiplier", multiplier - 1.0);
        this.applyModifierIfAbsent(entity, Attributes.f_22285_, "a06083b0-291d-4a72-85de-73bd93ffb738", "ArmorToughnessMultiplier", multiplier - 1.0);
        this.applyModifierIfAbsent(entity, Attributes.f_22278_, "a06083b0-291d-4a72-85de-73bd93ffb739", "KnockbackResistanceMultiplier", multiplier - 1.0);
    }

    public void applyStatModifierAllOutPhase() {
        this.applyModifierIfAbsent((LivingEntity)this, Attributes.f_22281_, "a06083b0-291d-4a72-85de-73bd93ffb736", "AttackMultiplier", 0.25);
        this.applyModifierIfAbsent((LivingEntity)this, Attributes.f_22284_, "a06083b0-291d-4a72-85de-73bd93ffb737", "ArmorMultiplier", 1.25);
        this.applyModifierIfAbsent((LivingEntity)this, Attributes.f_22285_, "a06083b0-291d-4a72-85de-73bd93ffb738", "ArmorToughnessMultiplier", 1.25);
        this.applyModifierIfAbsent((LivingEntity)this, Attributes.f_22278_, "a06083b0-291d-4a72-85de-73bd93ffb739", "KnockbackResistanceMultiplier", 0.5);
    }

    private void applyModifierIfAbsent(LivingEntity entity, Attribute attribute, String uuid, String name, double value) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance == null) {
            return;
        }
        UUID modifierUUID = UUID.fromString(uuid);
        if (attributeInstance.m_22111_(modifierUUID) == null) {
            attributeInstance.m_22118_(new AttributeModifier(modifierUUID, name, value, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public void SpawnThunderBolt(BlockPos pos) {
        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
        if (lightning != null) {
            lightning.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            lightning.m_20879_(null);
            lightning.setDamage(6.0f);
            this.f_19853_.m_7967_((Entity)lightning);
            ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ParticleTypes.f_175830_, pos, 0.3f, 0.5f, 0.3f, 5, 1.0f);
        }
    }

    public void SpawnThunderBolt(Vec3 pos) {
        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
        if (lightning != null) {
            lightning.m_6027_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            lightning.m_20879_(null);
            this.f_19853_.m_7967_((Entity)lightning);
            ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ParticleTypes.f_175830_, pos, 0.3f, 0.5f, 0.3f, 5, 1.0f);
        }
    }

    public void setSpeed(Experiment009BossEntity entity) {
        AttributeModifier speedModifier = new AttributeModifier(UUID.fromString("10-0-0-0-0"), "Speed", -0.4, AttributeModifier.Operation.MULTIPLY_BASE);
        if (entity.m_20089_() == Pose.SWIMMING) {
            if (!entity.m_21051_(Attributes.f_22279_).m_22109_(speedModifier)) {
                entity.m_21051_(Attributes.f_22279_).m_22118_(speedModifier);
            }
        } else if (entity.m_21051_(Attributes.f_22279_).m_22109_(speedModifier)) {
            entity.m_21051_(Attributes.f_22279_).m_22130_(speedModifier);
        }
    }

    public void crawlingSystem(LivingEntity target) {
        if (target != null) {
            this.setCrawlingPoseIfNeeded(target);
            this.crawlToTarget(target);
        } else if (!this.m_6069_() && !this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_())).m_60795_()) {
            this.m_20124_(Pose.SWIMMING);
        }
    }

    public void setCrawlingPoseIfNeeded(LivingEntity target) {
        if (target.m_20089_() == Pose.SWIMMING && this.m_20089_() != Pose.SWIMMING) {
            if (target.m_20186_() < this.m_20188_() && !target.f_19853_.m_8055_(new BlockPos(target.m_20185_(), target.m_20188_(), target.m_20189_()).m_7494_()).m_60795_()) {
                this.m_20124_(Pose.SWIMMING);
            }
        } else if (!this.m_6069_() && this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_()).m_7494_()).m_60795_()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void crawlToTarget(LivingEntity target) {
        if (target.m_20089_() == Pose.SWIMMING && this.m_20089_() == Pose.SWIMMING) {
            Vec3 direction = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_(0.05)));
        }
    }

    public void updateSwimmingMovement() {
        if (this.m_20069_()) {
            if (this.m_5448_() != null) {
                Vec3 direction = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_();
                this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_(0.07)));
            }
            if (this.m_204029_(FluidTags.f_13131_)) {
                this.m_20124_(Pose.SWIMMING);
                this.m_20282_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_20282_(false);
            }
        } else if (this.m_20089_() == Pose.SWIMMING && !this.m_20069_() && this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_()).m_7494_()).m_60795_()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    @Override
    public void WhenPattedReaction(Player player, InteractionHand hand) {
        Level level = player.m_183503_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ChangedAddonCriteriaTriggers.PAT_ENTITY_TRIGGER.Trigger(serverPlayer, (Entity)this, "pats_on_the_beast");
        }
        ArrayList<TranslatableComponent> translatableComponentList = new ArrayList<TranslatableComponent>();
        translatableComponentList.add(new TranslatableComponent("changed_addon.entity_dialogues.exp9.pat.type_1"));
        translatableComponentList.add(new TranslatableComponent("changed_addon.entity_dialogues.exp9.pat.type_2"));
        translatableComponentList.add(new TranslatableComponent("changed_addon.entity_dialogues.exp9.pat.type_3"));
        ParticlesUtil.sendParticles(player.m_183503_(), (ParticleOptions)ChangedParticles.emote((Entity)this, (Emote)Emote.ANGRY), this.m_20185_(), this.m_20186_() + (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ + 0.65, this.m_20189_(), 0.0, 0.0, 0.0, 1, 0.0f);
        player.m_5661_((Component)translatableComponentList.get(this.m_21187_().nextInt(translatableComponentList.size())), false);
        this.applyRampage();
    }

    private void applyRampage() {
        MobEffectInstance mobEffectInstance;
        MobEffectInstance thisEffect = this.m_21124_(MobEffects.f_19600_);
        if (thisEffect != null) {
            int pDuration = thisEffect.m_19557_() + 10;
            int pAmplifier = Mth.m_14045_((int)(thisEffect.m_19564_() + 1), (int)0, (int)5);
            mobEffectInstance = new MobEffectInstance(MobEffects.f_19600_, pDuration, pAmplifier, thisEffect.m_19571_(), thisEffect.m_19572_(), thisEffect.m_19575_());
        } else {
            mobEffectInstance = new MobEffectInstance(MobEffects.f_19600_, 20, 0, true, true, true);
        }
        this.m_7292_(mobEffectInstance);
    }

    @Mod.EventBusSubscriber(modid="changed_addon")
    public static class WhenAttackAEntity {
        @SubscribeEvent
        public static void WhenAttack(LivingAttackEvent event) {
            Experiment009BossEntity experiment009BossEntity;
            LivingEntity target = event.getEntityLiving();
            Entity source = event.getSource().m_7639_();
            if (source instanceof Experiment009BossEntity && (experiment009BossEntity = (Experiment009BossEntity)source).isPhase3()) {
                experiment009BossEntity.m_5634_(0.5f);
            }
        }
    }
}

