/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.bosses;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.foxyas.changedaddon.abilities.DodgeAbilityInstance;
import net.foxyas.changedaddon.client.renderer.layers.features.SonarOutlineLayer;
import net.foxyas.changedaddon.client.renderer.renderTypes.ChangedAddonRenderTypes;
import net.foxyas.changedaddon.entity.goals.generic.attacks.ComboAbilityGoal;
import net.foxyas.changedaddon.entity.goals.generic.attacks.KnockBackBurstGoal;
import net.foxyas.changedaddon.entity.goals.generic.attacks.SimpleComboAbilityGoal;
import net.foxyas.changedaddon.entity.goals.void_fox.VoidFoxAntiFlyingAttack;
import net.foxyas.changedaddon.entity.goals.void_fox.VoidFoxDashAttack;
import net.foxyas.changedaddon.entity.interfaces.CrawlFeature;
import net.foxyas.changedaddon.entity.interfaces.IHasBossMusic;
import net.foxyas.changedaddon.entity.projectile.AbstractVoidFoxParticleProjectile;
import net.foxyas.changedaddon.entity.projectile.VoidFoxParticleProjectile;
import net.foxyas.changedaddon.init.ChangedAddonAbilities;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.EyeStyle;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.entity.TransfurMode;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidFoxEntity
extends ChangedEntity
implements CrawlFeature,
IHasBossMusic,
SonarOutlineLayer.CustomSonarRenderable {
    public static final int MAX_1_COOLDOWN = 120;
    public static final int MAX_2_COOLDOWN = 120;
    private static final int MAX_COOLDOWN = 120;
    public final ServerBossEvent bossBar = this.getBossBar();
    public int timesUsedAttack1;
    public int timesUsedAttack2;
    public int timesUsedAttack3;
    public int timesUsedAttack4 = 0;
    public int stunTicks = 0;
    public DodgeAbilityInstance dodgeAbilityInstance = null;
    private int Attack1Cooldown;
    private int Attack2Cooldown;
    private int Attack3Cooldown;
    private int Attack4Cooldown;
    private int AttackInUse;
    private int ticksInUse;
    private int ticksTakeDmgFromFire = 0;

    public VoidFoxEntity(PlayMessages.SpawnEntity ignoredPacket, Level world) {
        this((EntityType<VoidFoxEntity>)((EntityType)ChangedAddonEntities.VOID_FOX.get()), world);
    }

    public VoidFoxEntity(EntityType<VoidFoxEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 1000;
        this.m_21557_(false);
        this.m_21530_();
        this.dodgeAbilityInstance = (DodgeAbilityInstance)this.registerAbility(abilityInstance -> true, new DodgeAbilityInstance((AbstractAbility)ChangedAddonAbilities.DODGE.get(), IAbstractChangedEntity.forEntity((ChangedEntity)this)));
    }

    public static int getMaxCooldown() {
        return 120;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = ChangedEntity.createLatexAttributes();
        builder = builder.m_22268_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get(), 3.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    public boolean m_142535_(float p_148859_, float p_148860_, @NotNull DamageSource p_148861_) {
        return false;
    }

    public ServerBossEvent getBossBar() {
        ServerBossEvent bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10);
        bossBar.m_7006_(true);
        bossBar.m_7003_(true);
        return bossBar;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public LatexType getLatexType() {
        return LatexType.NEUTRAL;
    }

    public TransfurMode getTransfurMode() {
        if (this.m_5448_() != null) {
            return TransfurMode.NONE;
        }
        return TransfurMode.ABSORPTION;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void RegisterHit() {
        this.f_21345_.m_148105_().forEach(wrappedGoal -> {
            Goal patt7047$temp = wrappedGoal.m_26015_();
            if (patt7047$temp instanceof KnockBackBurstGoal) {
                KnockBackBurstGoal knockBackBurstGoal = (KnockBackBurstGoal)patt7047$temp;
                knockBackBurstGoal.registerHit();
            }
        });
    }

    public void RegisterDamage(float amount) {
        this.f_21345_.m_148105_().forEach(wrappedGoal -> {
            Goal patt7348$temp = wrappedGoal.m_26015_();
            if (patt7348$temp instanceof KnockBackBurstGoal) {
                KnockBackBurstGoal knockBackBurstGoal = (KnockBackBurstGoal)patt7348$temp;
                knockBackBurstGoal.registerDamage(amount);
            }
        });
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(10, (Goal)new VoidFoxAntiFlyingAttack((Mob)this, 0.0f, 32.0f, 1.0f, 40){

            @Override
            public void m_8056_() {
                super.m_8056_();
                LivingEntity livingEntity = this.getTarget();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)new TextComponent("Flying will not help you").m_130938_(style -> {
                        Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                        returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                        return returnStyle;
                    }), true);
                }
            }
        });
        this.f_21345_.m_25352_(15, (Goal)new KnockBackBurstGoal((Mob)this, 10.0));
        this.f_21345_.m_25352_(5, (Goal)new VoidFoxDashAttack((Mob)this, (EntityType)ChangedAddonEntities.PARTICLE_PROJECTILE.get()){

            @Override
            public boolean m_8036_() {
                if (VoidFoxEntity.this.getAttack2Cooldown() < 120) {
                    return false;
                }
                if (VoidFoxEntity.this.AttackInUse > 0 && VoidFoxEntity.this.AttackInUse != 1) {
                    return false;
                }
                if (VoidFoxEntity.this.timesUsedAttack1 >= 2) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                LivingEntity livingEntity = this.getTarget();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)new TextComponent("Here i go!").m_130938_(style -> {
                        Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                        returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                        return returnStyle;
                    }), true);
                }
                VoidFoxEntity.this.setAttack2Cooldown(0);
                ++VoidFoxEntity.this.timesUsedAttack1;
                VoidFoxEntity.this.timesUsedAttack2 = 0;
                VoidFoxEntity.this.timesUsedAttack3 = 0;
                VoidFoxEntity.this.timesUsedAttack4 = 0;
            }

            @Override
            public void m_8037_() {
                VoidFoxEntity.this.AttackInUse = 1;
                super.m_8037_();
            }

            public void m_8041_() {
                super.m_8041_();
                VoidFoxEntity.this.AttackInUse = 0;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new ComboAbilityGoal((Mob)this, 3.0f, 18.0f, 3.0f, 5, new SoundEvent[]{SoundEvents.f_12317_, SoundEvents.f_12316_, SoundEvents.f_12313_, SoundEvents.f_12090_}, new ParticleOptions[]{ParticleTypes.f_123747_, ParticleTypes.f_123813_, ParticleTypes.f_123747_}){

            @Override
            public boolean m_8036_() {
                if (VoidFoxEntity.this.getAttack1Cooldown() < VoidFoxEntity.getMaxCooldown()) {
                    return false;
                }
                if (VoidFoxEntity.this.AttackInUse > 0 && VoidFoxEntity.this.AttackInUse != 2) {
                    return false;
                }
                if (VoidFoxEntity.this.timesUsedAttack2 >= 2) {
                    return false;
                }
                if (VoidFoxEntity.this.m_21187_().nextFloat() >= 0.25f) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                LivingEntity livingEntity = VoidFoxEntity.this.m_5448_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)new TextComponent("Lest DANCE").m_130938_(style -> {
                        Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                        returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                        return returnStyle;
                    }), true);
                }
                VoidFoxEntity.this.setAttack1Cooldown(0);
                VoidFoxEntity.this.timesUsedAttack1 = 0;
                ++VoidFoxEntity.this.timesUsedAttack2;
                VoidFoxEntity.this.timesUsedAttack3 = 0;
                VoidFoxEntity.this.timesUsedAttack4 = 0;
            }

            @Override
            public void m_8037_() {
                VoidFoxEntity.this.AttackInUse = 2;
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                if (this.isShouldEnd()) {
                    LivingEntity livingEntity;
                    if (VoidFoxEntity.this.m_5448_() != null) {
                        FoxyasUtils.repairArmor(VoidFoxEntity.this.m_5448_(), 25);
                    }
                    if ((livingEntity = VoidFoxEntity.this.m_5448_()) instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_5661_((Component)new TextComponent("Heh nice one").m_130938_(style -> {
                            Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                            returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                            return returnStyle;
                        }), true);
                        VoidFoxEntity.this.stunTicks = 120;
                    }
                }
                super.m_8041_();
                VoidFoxEntity.this.AttackInUse = 0;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SimpleComboAbilityGoal((Mob)this, 2, 3.0f, 18.0f, 3.0f, 5, new SoundEvent[]{SoundEvents.f_12317_, SoundEvents.f_12316_, SoundEvents.f_12313_, SoundEvents.f_12090_}, new ParticleOptions[]{ParticleTypes.f_123747_, ParticleTypes.f_123813_, ParticleTypes.f_123747_}){

            @Override
            public boolean m_8036_() {
                if (VoidFoxEntity.this.getAttack3Cooldown() < VoidFoxEntity.getMaxCooldown()) {
                    return false;
                }
                if (VoidFoxEntity.this.AttackInUse > 0 && VoidFoxEntity.this.AttackInUse != 3) {
                    return false;
                }
                if (VoidFoxEntity.this.timesUsedAttack3 >= 4) {
                    return false;
                }
                if (VoidFoxEntity.this.m_21187_().nextFloat() >= 0.7f) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                LivingEntity livingEntity = this.getTarget();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)new TextComponent("can you keep up with me?").m_130938_(style -> {
                        Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                        returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                        return returnStyle;
                    }), true);
                }
                VoidFoxEntity.this.setAttack3Cooldown(0);
                VoidFoxEntity.this.timesUsedAttack1 = 0;
                VoidFoxEntity.this.timesUsedAttack2 = 0;
                ++VoidFoxEntity.this.timesUsedAttack3;
                VoidFoxEntity.this.timesUsedAttack4 = 0;
            }

            @Override
            public void m_8037_() {
                VoidFoxEntity.this.AttackInUse = 3;
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                if (this.isShouldEnd()) {
                    LivingEntity livingEntity;
                    if (this.getTarget() != null) {
                        FoxyasUtils.repairArmor(this.getTarget(), 25);
                    }
                    if ((livingEntity = this.getTarget()) instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_5661_((Component)new TextComponent("Heh it seems so").m_130938_(style -> {
                            Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                            returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                            return returnStyle;
                        }), true);
                        VoidFoxEntity.this.stunTicks = 120;
                    }
                }
                super.m_8041_();
                VoidFoxEntity.this.AttackInUse = 0;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SimpleComboAbilityGoal((Mob)this, 3, 3.0f, 18.0f, 3.0f, 2, new SoundEvent[]{SoundEvents.f_12317_, SoundEvents.f_12316_, SoundEvents.f_12313_, SoundEvents.f_12090_}, new ParticleOptions[]{ParticleTypes.f_123747_, ParticleTypes.f_123813_, ParticleTypes.f_123747_}){

            @Override
            public boolean m_8036_() {
                if (VoidFoxEntity.this.getAttack4Cooldown() < VoidFoxEntity.getMaxCooldown()) {
                    return false;
                }
                if (VoidFoxEntity.this.AttackInUse > 0 && VoidFoxEntity.this.AttackInUse != 4) {
                    return false;
                }
                if (VoidFoxEntity.this.timesUsedAttack4 >= 4) {
                    return false;
                }
                if ((double)VoidFoxEntity.this.m_21187_().nextFloat() >= 0.5) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public void m_8056_() {
                LivingEntity livingEntity = this.getTarget();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)new TextComponent("can you keep up with me like this?").m_130938_(style -> {
                        Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                        returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                        return returnStyle;
                    }), true);
                }
                super.m_8056_();
                VoidFoxEntity.this.setAttack4Cooldown(0);
                VoidFoxEntity.this.timesUsedAttack1 = 0;
                VoidFoxEntity.this.timesUsedAttack2 = 0;
                VoidFoxEntity.this.timesUsedAttack3 = 0;
                ++VoidFoxEntity.this.timesUsedAttack4;
            }

            @Override
            public void m_8037_() {
                VoidFoxEntity.this.AttackInUse = 4;
                super.m_8037_();
            }

            @Override
            public void m_8041_() {
                if (this.isShouldEnd()) {
                    LivingEntity livingEntity;
                    if (this.getTarget() != null) {
                        FoxyasUtils.repairArmor(this.getTarget(), 25);
                    }
                    if ((livingEntity = this.getTarget()) instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_5661_((Component)new TextComponent("Wow yeah it seems so").m_130938_(style -> {
                            Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                            returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                            return returnStyle;
                        }), true);
                        VoidFoxEntity.this.stunTicks = 120;
                    }
                }
                super.m_8041_();
                VoidFoxEntity.this.AttackInUse = 0;
            }
        });
    }

    public int getAttack1Cooldown() {
        return this.Attack1Cooldown;
    }

    public void setAttack1Cooldown(int attack1Cooldown) {
        this.Attack1Cooldown = attack1Cooldown;
    }

    public int getAttack2Cooldown() {
        return this.Attack2Cooldown;
    }

    public void setAttack2Cooldown(int attack2Cooldown) {
        this.Attack2Cooldown = attack2Cooldown;
    }

    public int getAttack3Cooldown() {
        return this.Attack3Cooldown;
    }

    public void setAttack3Cooldown(int attack3Cooldown) {
        this.Attack3Cooldown = attack3Cooldown;
    }

    public int getAttack4Cooldown() {
        return this.Attack4Cooldown;
    }

    public void setAttack4Cooldown(int attack4Cooldown) {
        this.Attack4Cooldown = attack4Cooldown;
    }

    public Color3 getDripColor() {
        return this.m_21187_().nextBoolean() ? Color3.BLACK : Color3.WHITE;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return super.m_6049_();
    }

    public void doClawsAttackEffect() {
        double d0 = (double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))) * 1.0;
        double d1 = (double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.0;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_() + d0, this.m_20227_(0.5), this.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_() + d0, this.m_20227_(0.6), this.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_() + d0, this.m_20227_(0.7), this.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 0.75f);
        }
    }

    public double getTorsoYOffset(ChangedEntity self) {
        float ageAdjusted = (float)self.f_19797_ * 0.33333334f * 0.25f * 0.15f;
        float ageSin = Mth.m_14031_((float)(ageAdjusted * (float)Math.PI * 0.5f));
        float ageCos = Mth.m_14089_((float)(ageAdjusted * (float)Math.PI * 0.5f));
        float bpiSize = (self.getBasicPlayerInfo().getSize() - 1.0f) * 2.0f;
        return Mth.m_14179_((float)Mth.m_14179_((float)(1.0f - Mth.m_14154_((float)(Mth.m_14091_((float)ageAdjusted, (float)2.0f) - 1.0f))), (float)(ageSin * ageSin * ageSin * ageSin), (float)(1.0f - ageCos * ageCos * ageCos * ageCos)), (float)0.95f, (float)0.87f) + bpiSize;
    }

    public double getTorsoYOffsetForFallFly(ChangedEntity self) {
        float bpiSize = (self.getBasicPlayerInfo().getSize() - 1.0f) * 2.0f;
        return 0.375 + (double)bpiSize;
    }

    public double m_6048_() {
        if (this.m_20089_() == Pose.STANDING || this.m_20089_() == Pose.CROUCHING) {
            return super.m_6048_() + this.getTorsoYOffset(this) + (this.m_6047_() ? 1.2 : 1.15);
        }
        return this.getTorsoYOffsetForFallFly(this);
    }

    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        return true;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("AttacksHandle")) {
            CompoundTag attackTag = tag.m_128469_("AttacksHandle");
            if (attackTag.m_128441_("Attack1Cooldown")) {
                this.Attack1Cooldown = attackTag.m_128451_("Attack1Cooldown");
            }
            if (attackTag.m_128441_("Attack2Cooldown")) {
                this.Attack2Cooldown = attackTag.m_128451_("Attack2Cooldown");
            }
            if (attackTag.m_128441_("Attack3Cooldown")) {
                this.Attack3Cooldown = attackTag.m_128451_("Attack3Cooldown");
            }
            if (attackTag.m_128441_("Attack4Cooldown")) {
                this.Attack4Cooldown = attackTag.m_128451_("Attack4Cooldown");
            }
            if (attackTag.m_128441_("AttackInUse")) {
                this.AttackInUse = attackTag.m_128451_("AttackInUse");
            }
            if (attackTag.m_128441_("timeUsedAttack1")) {
                this.timesUsedAttack1 = attackTag.m_128451_("timeUsedAttack1");
            }
            if (attackTag.m_128441_("timeUsedAttack2")) {
                this.timesUsedAttack2 = attackTag.m_128451_("timeUsedAttack2");
            }
            if (attackTag.m_128441_("timeUsedAttack3")) {
                this.timesUsedAttack3 = attackTag.m_128451_("timeUsedAttack3");
            }
            if (attackTag.m_128441_("timeUsedAttack4")) {
                this.timesUsedAttack4 = attackTag.m_128451_("timeUsedAttack4");
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag attackTag = new CompoundTag();
        attackTag.m_128405_("Attack1Cooldown", this.Attack1Cooldown);
        attackTag.m_128405_("Attack2Cooldown", this.Attack2Cooldown);
        attackTag.m_128405_("Attack3Cooldown", this.Attack3Cooldown);
        attackTag.m_128405_("Attack4Cooldown", this.Attack4Cooldown);
        attackTag.m_128405_("AttackInUse", this.AttackInUse);
        attackTag.m_128405_("timeUsedAttack1", this.timesUsedAttack1);
        attackTag.m_128405_("timeUsedAttack2", this.timesUsedAttack2);
        attackTag.m_128405_("timeUsedAttack3", this.timesUsedAttack3);
        attackTag.m_128405_("timeUsedAttack4", this.timesUsedAttack4);
        tag.m_128365_("AttacksHandle", (Tag)attackTag);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean willHit;
        float randomValue = this.m_21187_().nextFloat();
        float value = this.computeHealthRatio() <= 0.5f ? 0.75f : 0.5f;
        boolean bl = willHit = randomValue <= value;
        if (source.m_7639_() instanceof AbstractVoidFoxParticleProjectile || source.m_7640_() instanceof AbstractVoidFoxParticleProjectile) {
            boolean f = super.m_6469_(source, amount * 3.5f);
            this.f_19802_ = 0;
            this.f_20917_ = 1;
            this.f_20918_ = 1.0f;
            this.f_20916_ = 1;
            return f;
        }
        if (source.m_19384_()) {
            ++this.ticksTakeDmgFromFire;
        }
        if (source.m_7639_() != null) {
            if (this.AttackInUse > 0) {
                if (this.AttackInUse != 1) {
                    return super.m_6469_(source, amount);
                }
                if (!this.isMoreOp()) {
                    this.f_21345_.m_25386_().forEach(wrappedGoal -> {
                        VoidFoxDashAttack dashAttack;
                        Goal patt26621$temp = wrappedGoal.m_26015_();
                        if (patt26621$temp instanceof VoidFoxDashAttack && (dashAttack = (VoidFoxDashAttack)patt26621$temp).isChargingDash()) {
                            dashAttack.setTickCount(dashAttack.getTickCount() + 5);
                        }
                    });
                } else {
                    this.f_21345_.m_25386_().forEach(wrappedGoal -> {
                        VoidFoxDashAttack dashAttack;
                        Goal patt27093$temp = wrappedGoal.m_26015_();
                        if (patt27093$temp instanceof VoidFoxDashAttack && (dashAttack = (VoidFoxDashAttack)patt27093$temp).isChargingDash()) {
                            dashAttack.setTickCount(dashAttack.getTickCount() + 1);
                        }
                    });
                    return super.m_6469_(source, amount);
                }
            }
            if (!willHit) {
                this.setDodging(source.m_7639_());
                return false;
            }
            this.RegisterDamage(amount);
            return super.m_6469_(source, amount);
        }
        if (source.m_7640_() != null && source.m_7640_().m_6095_().getRegistryName() != null && source.m_7640_().m_6095_().getRegistryName().toString().contains("bullet")) {
            this.RegisterDamage(amount);
            this.setDodging(source.m_7639_());
            return false;
        }
        return super.m_6469_(source, amount);
    }

    private void setDodging(Entity entity) {
        if (entity != null) {
            this.m_21563_().m_24964_(entity.m_146892_());
        }
        this.m_21573_().m_26573_();
        if (this.dodgeAbilityInstance != null) {
            this.dodgeAbilityInstance.executeDodgeAnimations((LevelAccessor)this.m_183503_(), (LivingEntity)this);
            this.dodgeAbilityInstance.setDodgeActivate(true);
        }
    }

    public void tickDodgeTicks() {
        if (!this.m_21525_() && this.dodgeAbilityInstance != null && this.dodgeAbilityInstance.isDodgeActive()) {
            this.dodgeAbilityInstance.setDodgeActivate(false);
        }
    }

    public void tickAttackTicks() {
        if (!this.m_21525_()) {
            int value;
            if (this.stunTicks > 0) {
                --this.stunTicks;
                return;
            }
            if (this.AttackInUse != 0) {
                ++this.ticksInUse;
                if (this.ticksInUse > 260) {
                    this.AttackInUse = 0;
                    this.ticksInUse = 0;
                }
                return;
            }
            int n = value = this.isMoreOp() ? 3 : 1;
            if (this.Attack1Cooldown < 120) {
                float delay;
                float f = delay = this.isMoreOp() ? 2.0f : 5.0f;
                if ((float)this.f_19797_ % delay == 1.0f) {
                    ++this.Attack1Cooldown;
                }
            }
            if (this.Attack2Cooldown < 120) {
                this.Attack2Cooldown += value;
            }
            if (this.Attack3Cooldown < 120) {
                this.Attack3Cooldown += value;
            }
            if (this.Attack4Cooldown < 120) {
                this.Attack4Cooldown += value;
            }
        }
    }

    public boolean isMoreOp() {
        return this.computeHealthRatio() <= 0.5f;
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected boolean m_6129_() {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        this.crawlingSystem(this, this.m_5448_());
        this.tickDodgeTicks();
        this.tickAttackTicks();
        this.handleChanges();
        if (!this.f_19853_.f_46443_) {
            if (this.ticksTakeDmgFromFire > 5) {
                this.ticksTakeDmgFromFire = 0;
                this.m_183503_().m_5594_(null, this.m_142538_(), SoundEvents.f_12314_, SoundSource.HOSTILE, 1.0f, 1.0f);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (LivingEntity living : this.m_183503_().m_6443_(LivingEntity.class, this.m_142469_().m_82400_(8.0), livingEntity -> !livingEntity.m_5833_() && !livingEntity.m_7306_((Entity)this))) {
                    Vec3 knock = living.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(1.2);
                    living.m_5997_(knock.f_82479_, knock.f_82480_ * 1.25, knock.f_82481_);
                    if (!(living instanceof Player)) continue;
                    Player player = (Player)living;
                    player.m_5661_((Component)new TextComponent("ENOUGH OF THIS").m_130938_(style -> {
                        Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                        returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                        return returnStyle;
                    }), true);
                }
                this.m_183503_().m_5594_(null, this.m_142538_(), SoundEvents.f_11937_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.m_7311_(0);
                double radius = 1.5;
                for (int theta = 0; theta < 360; theta += 45) {
                    double angleTheta = Math.toRadians(theta);
                    for (int phi = 0; phi <= 180; phi += 45) {
                        double anglePhi = Math.toRadians(phi);
                        double dx = Math.sin(anglePhi) * Math.cos(angleTheta);
                        double dy = Math.cos(anglePhi);
                        double dz = Math.sin(anglePhi) * Math.sin(angleTheta);
                        double px = this.m_20185_() + dx * radius;
                        double py = this.m_20186_() + dy * radius + 1.0;
                        double pz = this.m_20189_() + dz * radius;
                        VoidFoxParticleProjectile projectile = new VoidFoxParticleProjectile((EntityType<? extends AbstractVoidFoxParticleProjectile>)((EntityType)ChangedAddonEntities.PARTICLE_PROJECTILE.get()), this.f_19853_);
                        projectile.setSmoothMotion(true);
                        projectile.m_6034_(px, py, pz);
                        projectile.m_6686_(dx, dy, dz, 1.0f, 0.0f);
                        projectile.m_5602_((Entity)this);
                        projectile.setTarget(this.m_5448_());
                        projectile.setParryAble(true);
                        this.f_19853_.m_7967_((Entity)projectile);
                    }
                }
            }
            if ((double)this.computeHealthRatio() <= 0.5) {
                this.bossBar.m_142711_(this.computeHealthRatio() / 0.5f);
                this.bossBar.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
            } else {
                this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
                this.bossBar.m_5648_(BossEvent.BossBarOverlay.NOTCHED_10);
            }
        }
    }

    private void handleChanges() {
        float value;
        this.f_21345_.m_25386_().forEach(wrappedGoal -> {
            Goal patt34616$temp = wrappedGoal.m_26015_();
            if (patt34616$temp instanceof VoidFoxDashAttack) {
                VoidFoxDashAttack dashAttack = (VoidFoxDashAttack)patt34616$temp;
                if (this.isMoreOp() && dashAttack.isChargingDash()) {
                    dashAttack.setDashSpeed(2.5f);
                }
            }
        });
        if (this.isMoreOp() && !(((value = this.m_21187_().nextFloat(0.25f, 1.25f)) + this.m_21223_()) / this.m_21233_() > 0.5f) && this.f_20916_ <= 0 && this.f_19797_ % 10 == 0) {
            this.m_5634_(value);
        }
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
        player.m_5661_((Component)new TextComponent("A dark presence spreads through the land...\nWill you dare to confront its origin?").m_130938_(style -> {
            Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
            returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
            return returnStyle;
        }), false);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    protected void setAttributes(AttributeMap attributes) {
        Objects.requireNonNull(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(7.5);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(60.0);
        attributes.m_22146_(Attributes.f_22277_).m_22100_(64.0);
        attributes.m_22146_(Attributes.f_22279_).m_22100_(1.25);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(1.25);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(6.0);
        attributes.m_22146_(Attributes.f_22284_).m_22100_(6.0);
        attributes.m_22146_(Attributes.f_22285_).m_22100_(0.5);
        attributes.m_22146_(Attributes.f_22278_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22282_).m_22100_(3.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor p_21434_, @NotNull DifficultyInstance p_21435_, @NotNull MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        if (this.getUnderlyingPlayer() == null) {
            this.handleBoss();
        }
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void handleBoss() {
        Objects.requireNonNull(this.m_21051_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(7.5);
        this.m_21051_(Attributes.f_22276_).m_22100_(500.0);
        this.m_21051_(Attributes.f_22277_).m_22100_(64.0);
        this.m_21051_(Attributes.f_22279_).m_22100_(1.1);
        this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(1.1);
        this.m_21051_(Attributes.f_22281_).m_22100_(10.0);
        this.m_21051_(Attributes.f_22284_).m_22100_(20.0);
        this.m_21051_(Attributes.f_22285_).m_22100_(12.0);
        this.m_21051_(Attributes.f_22278_).m_22100_(0.0);
        this.m_21051_(Attributes.f_22282_).m_22100_(2.0);
        this.m_21153_(500.0f);
        this.getBasicPlayerInfo().setEyeStyle(EyeStyle.TALL);
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        super.m_6710_(entity);
    }

    @Override
    public ResourceLocation getBossMusic() {
        if (this.computeHealthRatio() <= 0.5f) {
            return ChangedAddonSoundEvents.EXP10_THEME.m_11660_();
        }
        return ChangedAddonSoundEvents.EXP9_THEME.m_11660_();
    }

    @Override
    public int getMusicRange() {
        return IHasBossMusic.super.getMusicRange();
    }

    @Override
    public LivingEntity getSelf() {
        return this;
    }

    public int getAttackInUse() {
        return this.AttackInUse;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handleSonarRender(@NotNull SonarOutlineLayer<?, ?> sonarOutlineLayer, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float alpha) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        Minecraft minecraft = Minecraft.m_91087_();
        EntityRenderDispatcher entityRenderDispatcher = minecraft.m_91290_();
        EntityRenderer renderer = entityRenderDispatcher.m_114382_((Entity)this);
        RenderType outline = ChangedAddonRenderTypes.outlineWithTranslucencyCull(renderer.m_5478_((Entity)this));
        sonarOutlineLayer.m_117386_().m_7695_(poseStack, buffer.m_6299_(outline), packedLight, OverlayTexture.f_118083_, r, g, b, alpha);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handleSonarRenderForCamera(@NotNull SonarOutlineLayer<?, ?> sonarOutlineLayer, @NotNull LivingEntity livingEntity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float alpha) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        Minecraft minecraft = Minecraft.m_91087_();
        EntityRenderDispatcher entityRenderDispatcher = minecraft.m_91290_();
        EntityRenderer renderer = entityRenderDispatcher.m_114382_((Entity)livingEntity);
        RenderType outline = ChangedAddonRenderTypes.outlineWithTranslucencyCull(renderer.m_5478_((Entity)livingEntity));
        sonarOutlineLayer.m_117386_().m_7695_(poseStack, buffer.m_6299_(outline), packedLight, OverlayTexture.f_118083_, r, g, b, alpha);
        return true;
    }

    @Mod.EventBusSubscriber(modid="changed_addon")
    public static class WhenAttackAEntity {
        @SubscribeEvent
        public static void WhenAttack(LivingAttackEvent event) {
            LivingEntity target = event.getEntityLiving();
            Entity source = event.getSource().m_7639_();
            float amount = event.getAmount();
            if (source instanceof VoidFoxEntity) {
                VoidFoxEntity voidFoxEntity = (VoidFoxEntity)source;
                voidFoxEntity.RegisterHit();
            } else if (target instanceof VoidFoxEntity) {
                VoidFoxEntity voidFox = (VoidFoxEntity)target;
                if (source != null && voidFox.computeHealthRatio() > 0.5f && (voidFox.m_21223_() - amount) / voidFox.m_21233_() <= 0.5f && source instanceof Player) {
                    Player player = (Player)source;
                    player.m_5661_((Component)new TextComponent("I will hasten the arrival of your death").m_130938_(style -> {
                        Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                        returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                        return returnStyle;
                    }), true);
                }
            }
        }
    }
}

