/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.customHandle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.foxyas.changedaddon.entity.bosses.Experiment009BossEntity;
import net.foxyas.changedaddon.entity.customHandle.BossAbilitiesHandle;
import net.foxyas.changedaddon.init.ChangedAddonParticleTypes;
import net.foxyas.changedaddon.util.DelayedTask;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Exp9AttacksHandle {

    public static class ThunderBoltAreaAttack
    extends Goal {
        private final Experiment009BossEntity boss;
        private final List<LivingEntity> targets = new ArrayList<LivingEntity>();
        private int tickDelay = -1;
        private int thunderIndex = 0;

        public ThunderBoltAreaAttack(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return false;
            }
            boolean isClose = this.boss.m_20270_((Entity)target) <= 3.0f;
            boolean timePassed = this.boss.f_19797_ - this.boss.m_21213_() > 80;
            return isClose && timePassed;
        }

        public void m_8056_() {
            AABB area = this.boss.m_142469_().m_82400_(3.0);
            List nearbyEntities = this.boss.f_19853_.m_6443_(LivingEntity.class, area, e -> e != this.boss && e.m_6084_());
            this.targets.clear();
            this.targets.addAll(nearbyEntities);
            this.tickDelay = 2;
            this.thunderIndex = 0;
        }

        public void m_8037_() {
            if (this.tickDelay > 0) {
                --this.tickDelay;
                return;
            }
            if (this.thunderIndex < this.targets.size()) {
                LivingEntity entity = this.targets.get(this.thunderIndex);
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.boss.f_19853_);
                if (lightning != null) {
                    lightning.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    lightning.m_20874_(true);
                    this.boss.f_19853_.m_7967_((Entity)lightning);
                }
                entity.m_20334_(entity.m_20184_().f_82479_, 0.5, entity.m_20184_().f_82481_);
                entity.f_19864_ = true;
                ++this.thunderIndex;
                this.tickDelay = 5;
            }
        }

        public boolean m_8045_() {
            return this.thunderIndex < this.targets.size();
        }

        public void m_8041_() {
            this.targets.clear();
            this.tickDelay = -1;
            this.thunderIndex = 0;
        }
    }

    public static class ThunderBoltImpactAttack
    extends Goal {
        private final Experiment009BossEntity boss;
        private final List<BlockPos> thunderPositions = new ArrayList<BlockPos>();
        private int tickDelay = -1;
        private int thunderIndex = 0;

        public ThunderBoltImpactAttack(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return false;
            }
            boolean isClose = this.boss.m_20270_((Entity)target) <= 3.0f;
            boolean timePassed = this.boss.f_19797_ - this.boss.m_21213_() > 80;
            return isClose && timePassed;
        }

        public void m_8056_() {
            this.thunderPositions.clear();
            this.thunderIndex = 0;
            this.tickDelay = 2;
            BlockPos center = this.boss.m_142538_();
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (x * x + z * z > 4) continue;
                    this.thunderPositions.add(center.m_142082_(x, 0, z));
                }
            }
            Collections.shuffle(this.thunderPositions);
        }

        public void m_8037_() {
            if (this.tickDelay > 0) {
                --this.tickDelay;
                return;
            }
            if (this.thunderIndex < this.thunderPositions.size()) {
                BlockPos pos = this.thunderPositions.get(this.thunderIndex);
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.boss.f_19853_);
                if (lightning != null) {
                    lightning.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                    lightning.m_20874_(true);
                    this.boss.f_19853_.m_7967_((Entity)lightning);
                }
                AABB hitbox = new AABB(pos).m_82400_(1.5);
                List nearby = this.boss.f_19853_.m_6443_(LivingEntity.class, hitbox, e -> e != this.boss && e.m_6084_());
                for (LivingEntity e2 : nearby) {
                    e2.m_20334_(e2.m_20184_().f_82479_, 0.5, e2.m_20184_().f_82481_);
                    e2.f_19864_ = true;
                    e2.m_6469_((DamageSource)this.boss.getThunderDmg(), 2.5f);
                }
                ++this.thunderIndex;
                this.tickDelay = 2;
            }
        }

        public boolean m_8045_() {
            return this.thunderIndex < this.thunderPositions.size();
        }

        public void m_8041_() {
            this.thunderPositions.clear();
            this.thunderIndex = 0;
            this.tickDelay = -1;
        }
    }

    public static class BurstAttack
    extends Goal {
        private final Experiment009BossEntity boss;

        public BurstAttack(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return false;
            }
            boolean isClose = this.boss.m_20270_((Entity)target) <= 3.0f;
            boolean lastHitTimeHigher = this.boss.m_21213_() > target.m_21213_();
            boolean attackedByAnother = this.boss.m_142581_() != null && this.boss.m_142581_() != target;
            return isClose && attackedByAnother;
        }

        public void m_8056_() {
            BossAbilitiesHandle.ExplosionBurst((Entity)this.boss);
        }
    }

    public static class RandomTeleportAttack
    extends Goal {
        private final Experiment009BossEntity boss;

        public RandomTeleportAttack(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public static void Teleport(Experiment009BossEntity boss, LivingEntity target) {
            if (target == null) {
                return;
            }
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
            boss.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            target.m_6469_((DamageSource)boss.getThunderDmg(), 2.0f);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            if (this.boss.m_5448_() == null) return false;
            if (!this.boss.m_20096_()) {
                if (!this.boss.m_5448_().m_20096_()) return false;
            }
            float f = this.boss.m_21187_().nextFloat();
            float f2 = this.boss.isPhase2() ? 0.35f : 0.25f;
            if (!(f <= f2)) return false;
            if (!((double)this.boss.m_20270_((Entity)this.boss.m_5448_()) >= 1.5)) return false;
            return true;
        }

        public void m_8056_() {
            this.Teleport();
        }

        public void Teleport() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
            this.boss.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            this.boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            target.m_6469_((DamageSource)this.boss.getThunderDmg(), 2.0f);
        }
    }

    public static class TeleportAttack
    extends Goal {
        private final Experiment009BossEntity boss;

        public TeleportAttack(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public static void Teleport(Experiment009BossEntity boss, LivingEntity target) {
            if (target == null) {
                return;
            }
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
            boss.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            target.m_6469_((DamageSource)boss.getThunderDmg(), 2.0f);
        }

        public boolean m_8036_() {
            return this.boss.m_5448_() != null && (this.boss.m_20096_() || this.boss.m_5448_().m_20096_()) && (double)(this.boss.m_21223_() / this.boss.m_21233_()) <= 0.5 && this.boss.m_20270_((Entity)this.boss.m_5448_()) >= 8.0f;
        }

        public void m_8056_() {
            this.Teleport();
        }

        public void Teleport() {
            LivingEntity target = this.boss.m_5448_();
            if (target == null) {
                return;
            }
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
            this.boss.m_6021_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            this.boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            target.m_6469_((DamageSource)this.boss.getThunderDmg(), 2.0f);
        }
    }

    public static class ThunderStorm
    extends Goal {
        public final Experiment009BossEntity boss;
        protected final IntProvider cooldownProvider;
        public int cooldown = 0;

        public ThunderStorm(Experiment009BossEntity boss, IntProvider cooldownProvider) {
            this.boss = boss;
            this.cooldownProvider = cooldownProvider;
        }

        public boolean m_8036_() {
            LivingEntity target = this.getTarget();
            if (target != null) {
                double distance = this.boss.m_20270_((Entity)target);
                if (this.cooldown > 0) {
                    --this.cooldown;
                    return false;
                }
                return distance <= 6.0;
            }
            return false;
        }

        public LivingEntity getTarget() {
            return this.boss.m_5448_();
        }

        public void m_8056_() {
            this.run();
        }

        public void run() {
            this.thunderStorm();
        }

        public void m_8041_() {
            super.m_8041_();
            this.cooldown = this.cooldownProvider.m_142270_(this.boss.m_21187_());
        }

        private void thunderStorm() {
            block4: {
                if (!(this.boss.f_19853_ instanceof ServerLevel)) break block4;
                if (this.boss.m_5448_() == null) {
                    for (int i = 0; i < 7; ++i) {
                        double offsetX = (this.boss.m_21187_().nextDouble() - 0.5) * 10.0;
                        double offsetZ = (this.boss.m_21187_().nextDouble() - 0.5) * 10.0;
                        BlockPos pos = new BlockPos(this.boss.m_20185_() + offsetX, this.boss.m_20186_(), this.boss.m_20189_() + offsetZ);
                        this.boss.SpawnThunderBolt(pos);
                    }
                } else {
                    for (int i = 0; i < 12; ++i) {
                        double offsetX = (this.boss.m_21187_().nextDouble() - 0.5) * 20.0;
                        double offsetZ = (this.boss.m_21187_().nextDouble() - 0.5) * 20.0;
                        BlockPos pos = new BlockPos(this.boss.m_20185_() + offsetX, this.boss.m_20186_(), this.boss.m_20189_() + offsetZ);
                        this.boss.SpawnThunderBolt(pos);
                    }
                }
            }
        }
    }

    public static class ThunderPathway
    extends Goal {
        public final Experiment009BossEntity boss;
        private final int MaxThunderIndex;
        private int ticks;
        private int thunderIndex;
        private boolean running;
        private Vec3 forward;

        public ThunderPathway(Experiment009BossEntity boss) {
            this.boss = boss;
            this.MaxThunderIndex = 10;
        }

        public boolean m_8036_() {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return false;
            }
            double distance = this.boss.m_20270_((Entity)target);
            return distance >= 5.0;
        }

        public LivingEntity getTarget() {
            return this.boss.m_5448_();
        }

        public void m_8056_() {
            this.ticks = 0;
            this.thunderIndex = 0;
            this.running = true;
            this.forward = this.boss.m_20154_().m_82490_(5.0);
        }

        public boolean m_8045_() {
            return this.running;
        }

        public void m_8037_() {
            ++this.ticks;
            if (this.ticks % 2 == 0 && this.thunderIndex < this.MaxThunderIndex) {
                if (this.boss.isPhase2()) {
                    this.forward = this.boss.m_20154_().m_82490_((double)this.MaxThunderIndex);
                }
                Vec3 startPos = this.boss.m_20182_();
                Vec3 currentPos = startPos.m_82549_(this.forward.m_82490_((double)this.thunderIndex / (double)this.MaxThunderIndex));
                this.boss.SpawnThunderBolt(currentPos);
                ++this.thunderIndex;
            }
            if (this.thunderIndex >= this.MaxThunderIndex) {
                this.running = false;
            }
        }
    }

    public static class ThunderShock
    extends Goal {
        public final Experiment009BossEntity boss;

        public ThunderShock(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public LivingEntity getTarget() {
            return this.boss.m_5448_();
        }

        public boolean m_8036_() {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return false;
            }
            double distance = this.boss.m_20270_((Entity)target);
            return distance <= 10.0;
        }

        public void m_8056_() {
            this.run();
        }

        public void run() {
            this.thunderShock();
        }

        private void thunderShock() {
            if (this.getTarget() != null) {
                LivingEntity livingEntity;
                Entity hitEntity;
                EntityHitResult hitResult;
                LivingEntity target = this.getTarget();
                Vec3 startPos = this.boss.m_20182_().m_82520_(0.0, (double)this.boss.m_20192_(), 0.0);
                Vec3 endPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
                for (int i = 0; i < 10; ++i) {
                    double progress = (double)i / 10.0;
                    Vec3 pos = startPos.m_82549_(endPos.m_82546_(startPos).m_82490_(progress));
                    double offsetX = (Math.random() - 0.5) * 0.5;
                    double offsetY = (Math.random() - 0.5) * 0.5;
                    double offsetZ = (Math.random() - 0.5) * 0.5;
                    Vec3 zigzagPos = pos.m_82520_(offsetX, offsetY, offsetZ);
                    BlockHitResult hitResult2 = this.boss.f_19853_.m_45547_(new ClipContext(this.boss.m_20299_(1.0f), this.boss.m_20299_(1.0f).m_82549_(this.boss.m_20252_(1.0f).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.boss));
                    BlockState state = this.boss.m_183503_().m_8055_(hitResult2.m_82425_());
                    if (hitResult2.m_6662_() == HitResult.Type.MISS) {
                        Level level = this.boss.f_19853_;
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, zigzagPos.f_82479_, zigzagPos.f_82480_, zigzagPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (!state.m_60795_() && (state.m_60713_(Blocks.f_50075_) || state.m_60713_(Blocks.f_50074_) || state.m_60713_(Blocks.f_152504_))) break;
                }
                if ((hitResult = PlayerUtil.getEntityHitLookingAt((Entity)this.boss, 10.0f, true)) != null && hitResult.m_6662_() != HitResult.Type.MISS && (hitEntity = hitResult.m_82443_()) instanceof LivingEntity && this.boss.m_6779_(livingEntity = (LivingEntity)hitEntity)) {
                    livingEntity.m_6469_((DamageSource)this.boss.getThunderDmg(), 4.0f);
                    this.boss.m_6674_(InteractionHand.MAIN_HAND);
                }
            }
        }
    }

    public static class ThunderSpeed
    extends Goal {
        public final Experiment009BossEntity boss;

        public ThunderSpeed(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return false;
            }
            double distance = this.boss.m_20270_((Entity)target);
            return distance > 5.0;
        }

        public LivingEntity getTarget() {
            return this.boss.m_5448_();
        }

        public void m_8056_() {
            this.run();
        }

        public void run() {
            this.thunderSpeed();
        }

        private void thunderSpeed() {
            if (this.getTarget() != null) {
                LivingEntity target = this.getTarget();
                Vec3 direction = target.m_20182_().m_82546_(this.boss.m_20182_()).m_82541_();
                this.boss.m_20256_(direction.m_82490_(1.5));
                new DelayedTask(10, () -> {
                    if ((double)this.boss.m_20270_((Entity)target) < 2.5) {
                        this.boss.SpawnThunderBolt(target.m_20182_());
                        target.m_6469_((DamageSource)this.boss.getThunderDmg(), 4.0f);
                        target.m_20256_(target.m_20184_().m_82549_(new Vec3(0.0, 1.0, 0.0)));
                    }
                });
            }
        }
    }

    public static class ThunderWave
    extends Goal {
        public final Experiment009BossEntity boss;

        public ThunderWave(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            LivingEntity target = this.getTarget();
            if (target == null) {
                return false;
            }
            double distance = this.boss.m_20270_((Entity)target);
            return distance < 5.0;
        }

        public void m_8056_() {
            this.run();
        }

        public void run() {
            this.thunderWave();
        }

        public LivingEntity getTarget() {
            return this.boss.m_5448_();
        }

        private void thunderWave() {
            Level level;
            if (this.getTarget() != null && (level = this.boss.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    double offsetX = (this.boss.m_21187_().nextDouble() - 0.5) * 6.0;
                    double offsetZ = (this.boss.m_21187_().nextDouble() - 0.5) * 6.0;
                    BlockPos pos = new BlockPos(this.boss.m_20185_() + offsetX, this.boss.m_20186_(), this.boss.m_20189_() + offsetZ);
                    if (serverLevel.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50016_) continue;
                    this.boss.SpawnThunderBolt(pos);
                }
            }
        }
    }

    public static class TeleportComboGoal
    extends Goal {
        private final Experiment009BossEntity boss;
        private final Random random = new Random();
        private LivingEntity target;
        private int phase = 0;
        private int ticks = 0;
        private int delay = 5;

        public TeleportComboGoal(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            Player player;
            this.target = this.boss.m_5448_();
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
                return false;
            }
            return this.target != null && this.target.m_20096_() && (double)this.boss.m_20270_((Entity)this.target) >= 7.5 && this.boss.m_20270_((Entity)this.target) <= 18.0f && (this.boss.isPhase2() || !this.boss.isPhase2() && this.random.nextFloat() <= 0.25f);
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.m_21254_()) {
                    return false;
                }
                if (player.m_7500_() || player.m_5833_()) {
                    return false;
                }
            }
            return this.phase < 7 && this.target != null && this.target.m_6084_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.phase = 0;
            this.ticks = 0;
            this.delay = this.boss.isPhase2() && this.boss.computeHealthRatio() <= 0.3f ? 3 : 5;
            this.teleportToTarget();
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.ticks;
            if (this.ticks % this.delay == 0) {
                switch (this.phase) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.followAttackAndKnockback();
                        break;
                    }
                    case 5: {
                        this.UpperCut();
                        break;
                    }
                    case 6: {
                        this.hammerSmash();
                    }
                }
                ++this.phase;
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.whenStopUsing();
        }

        private void whenStopUsing() {
            if (!this.boss.m_20096_()) {
                double x = this.boss.m_20185_();
                double z = this.boss.m_20189_();
                int groundY = this.boss.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z);
                Vec3 smashPos = new Vec3(x, (double)groundY + 0.5, z);
                this.boss.m_6021_(smashPos.f_82479_, smashPos.f_82480_, smashPos.f_82481_);
                this.boss.SpawnThunderBolt(smashPos);
            }
        }

        private void teleportToTarget() {
            this.SummonTeleportParticles();
            this.boss.m_6021_(this.target.m_20182_().f_82479_, this.target.m_20182_().f_82480_, this.target.m_20182_().f_82481_);
            this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.boss.m_6674_(InteractionHand.MAIN_HAND);
            Vec3 knockDir = this.target.m_20154_().m_82490_(-1.0).m_82520_(0.0, (double)0.1f, 0.0);
            Vec3 newPos = this.target.m_20182_().m_82520_(0.0, 0.0, 0.0);
            if (this.target.m_21254_()) {
                this.target.m_147240_(2.0, knockDir.f_82479_, knockDir.f_82481_);
            } else {
                this.target.m_147240_(4.0, knockDir.f_82479_, knockDir.f_82481_);
            }
            this.target.f_19802_ = 0;
            this.target.m_6469_((DamageSource)this.boss.getThunderDmg(), 4.0f);
            this.spawnThunder(newPos);
        }

        private void followAttackAndKnockback() {
            this.SummonTeleportParticles();
            Vec3 knockDir = this.target.m_20154_().m_82490_(-1.0).m_82520_(0.0, (double)0.1f, 0.0);
            this.boss.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.target.m_20256_(knockDir);
            this.boss.m_6674_(InteractionHand.MAIN_HAND);
            this.target.f_19802_ = 0;
            this.target.m_6469_((DamageSource)this.boss.getThunderDmg(), 2.0f);
            this.spawnParticles(this.target.m_20182_());
        }

        private void UpperCut() {
            this.SummonTeleportParticles();
            this.target.m_20334_(0.0, 3.0, 0.0);
            this.boss.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.boss.m_6674_(InteractionHand.MAIN_HAND);
            this.target.f_19802_ = 0;
            this.target.m_6469_((DamageSource)this.boss.getThunderDmg(), 4.0f);
            MobEffectInstance slowFallingEffect = new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false);
            this.target.m_7292_(slowFallingEffect);
            this.boss.m_7292_(slowFallingEffect);
            this.spawnParticles(this.target.m_20182_());
        }

        private void hammerSmash() {
            this.SummonTeleportParticles();
            this.target.m_20334_(0.0, -3.0, 0.0);
            this.boss.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.boss.m_6674_(InteractionHand.MAIN_HAND);
            this.target.f_19802_ = 0;
            this.target.m_6469_((DamageSource)this.boss.getThunderDmg(), 4.0f);
            this.boss.m_21195_(MobEffects.f_19591_);
            this.spawnParticles(this.target.m_20182_());
        }

        private void SummonTeleportParticles() {
            Vec3 posDifference = this.target.m_20182_().m_82546_(this.boss.m_20182_());
            int maxAmount = 20;
            for (int i = 0; i <= maxAmount; ++i) {
                double ratio = (double)i / (double)maxAmount;
                Vec3 spawnPos = this.boss.m_146892_().m_82549_(posDifference.m_82490_(ratio));
                ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ChangedAddonParticleTypes.thunderSpark(1), spawnPos, 0.25f, 0.25f, 0.25f, 5, 1.0f);
            }
        }

        private void spawnParticles(Vec3 pos) {
            Level level = this.boss.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
                this.boss.m_5496_(SoundEvents.f_12090_, 2.0f, 1.0f);
            }
        }

        private void spawnThunder(Vec3 pos) {
            Level level = this.boss.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
                this.boss.SpawnThunderBolt(pos);
            }
        }
    }

    public static class TeleportAirComboGoal
    extends Goal {
        private final Experiment009BossEntity boss;
        private final Random random = new Random();
        private LivingEntity target;
        private int phase = 0;
        private int ticks = 0;
        private int delay = 5;

        public TeleportAirComboGoal(Experiment009BossEntity boss) {
            this.boss = boss;
        }

        public boolean m_8036_() {
            Player player;
            this.target = this.boss.m_5448_();
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
                return false;
            }
            return this.target != null && this.target.m_20096_() && (double)this.boss.m_20270_((Entity)this.target) >= 7.5 && this.boss.m_20270_((Entity)this.target) <= 18.0f && (this.boss.isPhase2() || !this.boss.isPhase2() && this.random.nextFloat() <= 0.25f);
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.m_21254_()) {
                    return false;
                }
                if (player.m_7500_() || player.m_5833_()) {
                    return false;
                }
            }
            return this.phase < 5 && this.target != null && this.target.m_6084_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.phase = 0;
            this.ticks = 0;
            this.delay = this.boss.isPhase2() && this.boss.computeHealthRatio() <= 0.3f ? 3 : 5;
            this.teleportTargetUp();
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.ticks;
            if (this.ticks % this.delay == 0) {
                switch (this.phase) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.followAndKnockback();
                        break;
                    }
                    case 4: {
                        this.hammerSmash();
                    }
                }
                ++this.phase;
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.whenStopUsing();
        }

        private void whenStopUsing() {
            if (!this.boss.m_20096_()) {
                double x = this.boss.m_20185_();
                double z = this.boss.m_20189_();
                int groundY = this.boss.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z);
                Vec3 smashPos = new Vec3(x, (double)groundY + 0.5, z);
                this.boss.m_6021_(smashPos.f_82479_, smashPos.f_82480_, smashPos.f_82481_);
                this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                this.boss.SpawnThunderBolt(smashPos);
            }
        }

        private void teleportTargetUp() {
            this.SummonTeleportParticles();
            this.boss.m_6021_(this.target.m_20182_().f_82479_, this.target.m_20182_().f_82480_, this.target.m_20182_().f_82481_);
            this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            this.boss.m_6674_(InteractionHand.MAIN_HAND);
            Vec3 newPos = this.target.m_20182_().m_82520_(0.0, 10.0, 0.0);
            if (this.target.m_21254_()) {
                this.phase = 5;
                this.target.m_6021_(newPos.f_82479_, newPos.f_82480_ * 0.5, newPos.f_82481_);
                this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
                return;
            }
            this.target.m_6021_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            this.target.f_19802_ = 0;
            this.target.m_6469_((DamageSource)this.boss.getThunderDmg(), 4.0f);
            MobEffectInstance slowFallingEffect = new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false);
            this.target.m_7292_(slowFallingEffect);
            this.boss.m_7292_(slowFallingEffect);
            this.spawnThunder(newPos);
        }

        private void SummonTeleportParticles() {
            Vec3 posDifference = this.target.m_20182_().m_82546_(this.boss.m_20182_());
            int maxAmount = 20;
            for (int i = 0; i <= maxAmount; ++i) {
                double ratio = (double)i / (double)maxAmount;
                Vec3 spawnPos = this.boss.m_146892_().m_82549_(posDifference.m_82490_(ratio));
                ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ChangedAddonParticleTypes.thunderSpark(1), spawnPos, 0.25f, 0.25f, 0.25f, 5, 1.0f);
            }
        }

        private void followAndKnockback() {
            this.SummonTeleportParticles();
            Vec3 knockDir = this.target.m_20154_().m_82490_(-1.0).m_82520_(0.0, 0.5, 0.0);
            this.boss.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            this.target.m_20256_(knockDir);
            this.boss.m_6674_(InteractionHand.MAIN_HAND);
            this.target.f_19802_ = 0;
            this.target.m_6469_((DamageSource)this.boss.getThunderDmg(), 2.0f);
            this.spawnParticles(this.target.m_20182_());
        }

        private void hammerSmash() {
            this.SummonTeleportParticles();
            this.target.m_20334_(0.0, -3.0, 0.0);
            this.boss.m_6674_(InteractionHand.MAIN_HAND);
            this.target.f_19802_ = 0;
            this.target.m_6469_((DamageSource)this.boss.getThunderDmg(), 4.0f);
            this.boss.m_21195_(MobEffects.f_19591_);
            this.spawnParticles(this.target.m_20182_());
        }

        private void spawnParticles(Vec3 pos) {
            Level level = this.boss.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
                this.boss.m_5496_(SoundEvents.f_12090_, 2.0f, 1.0f);
            }
        }

        private void spawnThunder(Vec3 pos) {
            Level level = this.boss.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
                this.boss.SpawnThunderBolt(pos);
            }
        }
    }
}

