/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.defaults;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.TamableLatexEntity;
import net.ltxprogrammer.changed.entity.ai.LatexFollowOwnerGoal;
import net.ltxprogrammer.changed.entity.ai.LatexOwnerHurtByTargetGoal;
import net.ltxprogrammer.changed.entity.ai.LatexOwnerHurtTargetGoal;
import net.ltxprogrammer.changed.init.ChangedCriteriaTriggers;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTamableLatexEntity
extends ChangedEntity
implements TamableLatexEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(AbstractTamableLatexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(AbstractTamableLatexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public AbstractTamableLatexEntity(EntityType<? extends ChangedEntity> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(6, (Goal)new LatexFollowOwnerGoal((ChangedEntity)this, 0.35, 10.0f, 2.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new LatexOwnerHurtByTargetGoal((ChangedEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new LatexOwnerHurtTargetGoal((ChangedEntity)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        if (tag.m_128403_("Owner")) {
            uuid = tag.m_128342_("Owner");
        } else {
            String s = tag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)Objects.requireNonNull(this.m_20194_()), (String)s);
        }
        if (tag.m_128441_("FollowOwner")) {
            this.setFollowOwner(tag.m_128471_("FollowOwner"));
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable var4) {
                this.setTame(false);
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.m_142504_() != null) {
            tag.m_128362_("Owner", this.m_142504_());
        }
        tag.m_128379_("FollowOwner", this.isFollowingOwner());
    }

    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        LivingEntity owner = this.getOwner();
        if (livingEntity == owner) {
            return false;
        }
        if (owner != null) {
            return livingEntity == owner.m_142581_();
        }
        return super.targetSelectorTest(livingEntity);
    }

    @Nullable
    public UUID m_142504_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public boolean m_6935_(Player player) {
        return (!this.isTame() || !player.m_142081_().equals(this.m_142504_())) && super.m_6935_(player);
    }

    protected void spawnTamingParticles(boolean success) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!success) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected void spawnHeartParticles() {
        this.spawnTamingParticles(true);
    }

    public void m_7822_(byte event) {
        if (event == 7) {
            this.spawnTamingParticles(true);
        } else if (event == 6) {
            this.spawnTamingParticles(false);
        } else if (event == 18) {
            this.spawnHeartParticles();
        } else {
            super.m_7822_(event);
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.m_142504_();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setFollowOwner(true);
        this.setOwnerUUID(player.m_142081_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ChangedCriteriaTriggers.TAME_LATEX.trigger(serverPlayer, (ChangedEntity)this);
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.f_19853_.f_46443_) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isTame() && this.isTameItem(itemstack) && this.m_21223_() < this.m_21233_()) {
                itemstack.m_41774_(1);
                this.m_5634_(2.0f);
                this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                this.f_19853_.m_7605_((Entity)this, (byte)7);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.isOwnedBy((LivingEntity)player)) {
                boolean shouldFollow = !this.isFollowingOwner();
                this.setFollowOwner(shouldFollow);
                player.m_5661_((Component)new TranslatableComponent(shouldFollow ? "text.changed.tamed.follow" : "text.changed.tamed.wander", new Object[]{this.m_5446_()}), true);
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        return super.m_6071_(player, hand);
    }

    public boolean isFollowingOwner() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setFollowOwner(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        return !(target instanceof AbstractTamableLatexEntity) && super.wantsToAttack(target, owner);
    }

    public void m_6043_() {
        if (!this.isTame()) {
            super.m_6043_();
        }
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean tame) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (tame) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.getOwner();
    }

    public boolean m_6779_(@NotNull LivingEntity entity) {
        return !this.isOwnedBy(entity) && super.m_6779_(entity);
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.getOwner()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(@NotNull Entity entity) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public void m_6667_(@NotNull DamageSource source) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(source);
        if (this.f_20890_ && !this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().m_6352_(deathMessage, Util.f_137441_);
        }
    }

    protected boolean isTameItem(ItemStack stack) {
        return false;
    }
}

