/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp10;

import com.mojang.math.Vector3f;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClawsComboAttackGoal
extends Goal {
    protected final PathfinderMob holder;
    protected final Random random;
    protected final IntProvider cooldownProvider;
    protected final IntProvider attackCountProvider;
    protected final IntProvider castDurationProvider;
    protected final FloatProvider damageProvider;
    protected final DamageSource source;
    protected LivingEntity target;
    protected int cooldown;
    protected int attacks;
    protected Vec3 attackPos;
    protected int castDuration;
    protected int wasBlocked;
    private static final DustParticleOptions PARTICLE = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f);

    public ClawsComboAttackGoal(PathfinderMob holder, IntProvider cooldown, IntProvider attackCount, IntProvider castDuration, FloatProvider damage) {
        this.holder = holder;
        this.random = holder.m_21187_();
        this.cooldownProvider = cooldown;
        this.attackCountProvider = attackCount;
        this.castDurationProvider = castDuration;
        this.damageProvider = damage;
        this.source = new EntityDamageSource("mob", (Entity)holder){

            @Nullable
            public Vec3 m_7270_() {
                return ClawsComboAttackGoal.this.attackPos;
            }
        };
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.target = this.holder.m_5448_();
        return this.target != null && this.target.m_6084_();
    }

    public boolean m_8045_() {
        return this.target.m_6084_() && this.attacks > 0;
    }

    public void m_8056_() {
        this.attacks = this.attackCountProvider.m_142270_(this.random);
        this.castDuration = this.castDurationProvider.m_142270_(this.random);
        this.pickAttackPos();
        this.holder.m_21573_().m_26573_();
        this.holder.m_21563_().m_148051_((Entity)this.target);
    }

    protected void pickAttackPos() {
        this.attackPos = this.target.m_20182_();
    }

    public void m_8037_() {
        if (this.attacks <= 0) {
            return;
        }
        if (this.target != null) {
            this.holder.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        }
        if (this.wasBlocked > 0) {
            --this.wasBlocked;
            ((ServerLevel)this.holder.f_19853_).m_8767_((ParticleOptions)PARTICLE, this.holder.m_20185_() - 1.0, this.holder.m_20186_() - 1.0 + (double)(this.holder.m_20206_() / 2.0f), this.holder.m_20189_() - 1.0, 30 * this.wasBlocked / 30, 2.0, 2.0, 2.0, 0.3);
            if (this.wasBlocked == 0) {
                this.pickAttackPos();
            }
            return;
        }
        if (this.castDuration > 0) {
            --this.castDuration;
            return;
        }
        --this.attacks;
        this.holder.m_6021_(this.attackPos.f_82479_, this.attackPos.f_82480_, this.attackPos.f_82481_);
        this.doDashEffect();
        this.holder.m_6674_(InteractionHand.MAIN_HAND);
        this.holder.f_19853_.m_6269_(null, (Entity)this.holder, ChangedSounds.BOW2, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (this.attacks == 0) {
            this.applyKnockbackAndHurt(6.0f, 2.0f, 3.0f);
        } else {
            this.castDuration = this.castDurationProvider.m_142270_(this.random);
            if (this.applyKnockbackAndHurt(4.0f, 1.0f, 1.0f)) {
                this.wasBlocked = 60;
            } else {
                this.pickAttackPos();
            }
        }
    }

    protected boolean applyKnockbackAndHurt(float radius, float damageMul, float knockbackMul) {
        Level level = this.holder.f_19853_;
        float diameter = radius * 2.0f;
        float radiusSqr = radius * radius;
        List list = level.m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(target -> !target.m_7306_((Entity)this.holder)), (LivingEntity)this.holder, AABB.m_165882_((Vec3)this.attackPos, (double)diameter, (double)diameter, (double)diameter));
        boolean anyBlocked = false;
        for (LivingEntity livingEntity : list) {
            float dist = (float)livingEntity.m_20238_(this.attackPos);
            if (dist > radiusSqr) continue;
            dist = Mth.m_14116_((float)dist);
            boolean blocked = livingEntity.m_21275_(this.source);
            if (livingEntity.m_6469_(this.source, this.damageProvider.m_142269_(this.random) * damageMul)) {
                this.holder.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
                this.doClawsAttackEffect();
            }
            Vec3 direction = livingEntity.m_20182_().m_82546_(this.attackPos).m_82541_();
            float knockback = radius / dist * knockbackMul;
            if (blocked) {
                knockback *= 0.25f;
                anyBlocked = true;
            }
            livingEntity.m_5997_(direction.f_82479_ * (double)knockback, direction.f_82480_ * (double)knockback, direction.f_82481_ * (double)knockback);
        }
        return anyBlocked;
    }

    public void doClawsAttackEffect() {
        double d0 = (double)(-Mth.m_14031_((float)(this.holder.m_146908_() * ((float)Math.PI / 180)))) * 1.0;
        double d1 = (double)Mth.m_14089_((float)(this.holder.m_146908_() * ((float)Math.PI / 180))) * 1.0;
        Level level = this.holder.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.holder.m_20185_() + d0, this.holder.m_20227_(0.5), this.holder.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.holder.m_20185_() + d0, this.holder.m_20227_(0.6), this.holder.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.holder.m_20185_() + d0, this.holder.m_20227_(0.7), this.holder.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            this.holder.f_19853_.m_6263_(null, this.holder.m_20185_(), this.holder.m_20186_(), this.holder.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 0.75f);
        }
    }

    public void doDashEffect() {
        Level level = this.holder.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)PARTICLE, this.holder.m_20185_(), this.holder.m_20227_(0.5), this.holder.m_20189_(), 4, 0.25, 0.25, 0.25, 0.05);
            this.holder.f_19853_.m_6263_(null, this.holder.m_20185_(), this.holder.m_20186_(), this.holder.m_20189_(), ChangedSounds.BOW2, SoundSource.PLAYERS, 1.0f, 0.75f);
        }
    }

    public void m_8041_() {
        this.target = null;
        this.cooldown = this.cooldownProvider.m_142270_(this.random);
        this.attacks = 0;
        this.attackPos = null;
        this.castDuration = 0;
        this.wasBlocked = 0;
    }
}

